/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/gencfile.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon and Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Routines used for generating .h and .c file		*
*									*
*           generateincludefile	generatecodefile 			*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: /r/zep/usr/rts/p/personal/hkaram/tech/src/idlc/backend/RCS/gencfile.c,v 4.2 90/08/20 16:09:42 hkaram Release42 Locker: hkaram $";
#endif

/* modified by Bong Uichanco 5/27/88 so splitfile option will produce */
/*   3 files instead of 2.  file 1 contains Mark routines             */
/*                          file 2 contains Read routines             */
/*                          file 3 contains Write routines            */


/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	gencfile.c,v $
 * Revision 4.2  90/08/20  16:09:42  hkaram
 * @
 * 
 * Revision 1.1  89/07/05  16:35:29  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:18:42  cheung
 * gencfile.c  Ver 4.0
 * 
 * Revision 3.9  89/04/10  17:08:53  cheung
 * gencfile version 3.9
 * 
 * Revision 3.9  89/04/07  23:21:10  cheung
 * gencfile.c  Ver 3.9
 * 
 * Revision 3.9  89/04/04  18:30:27  cheung
 * gencfile.c version 3.9
 * 
 * Revision 3.9  89/03/30  14:10:07  cheung
 * gencfile.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:24:00  cheung
 * gencfile.c  Ver 3.9
 * 
 * Revision 3.3  88/04/06  10:58:14  rajan
 * This revision contains a fix so that proper code is generated if the
 * root of a structure is a class.
 * This fix administered by Sundar Varadarajan.
 * 
 * Revision 3.2  88/04/06  10:48:06  rajan
 * Revision supplied with the 3.2 distribution.
 * 
 * Revision 3.2  87/11/30  14:58:06  rajan
 * *** empty log message ***
 * 
 * Revision 1.2 87/10/30 15:00:00 rajan
 * Modified to produce the declaration
 * A IDLtempA; for every class A
 *
 * Revision 1.1  87/04/18  11:58:51  shannon
 * Initial revision
 * 
 * Revision 2.4  86/05/15  05:28:01  shannon
 * Version 2.4
 * 
 * Revision 2.3  86/05/05  15:16:57  shannon
 * Version 2.3 of IDL System
 * 
 * Revision 2.2  86/04/08  12:53:23  shannon
 * Version2.2
 * 
 * Revision 2.1  86/03/20  16:57:20  shannon
 * SEI Relase
 * 
 * Revision 2.0  86/01/22  07:27:23  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.12  85/09/24  19:01:09  shannon
 * added new set and seq operations
 * 
 * Revision 1.10  85/08/27  20:27:50  shannon
 * fixed array interface routine generation bug
 * 
 * Revision 1.9  85/07/31  09:52:58  shannon
 * changed code for different representations of null and empty class
 * 
 * Revision 1.8  85/07/23  21:05:58  shannon
 * changed null and empty class representation
 * added retrievefirst, retrievelast seq routines
 * 
 * Revision 1.7  85/07/18  19:49:17  shannon
 * added special representation processing for Integer, Rational, array,
 * and SetInteger
 * 
 * Revision 1.6  85/07/05  20:49:11  shannon
 * added unmarker Port processing
 * added typedef int for unattributed and null nodes
 * 
 * Revision 1.5  85/07/03  19:39:20  shannon
 * added restrictions <Restrict To>
 * fixed bug in generated routines for Gclass, Mclass, Wclass
 * --don't create case stmts for descendants without proper flags
 * 
 * Revision 1.4  85/07/02  19:21:10  shannon
 * deleted extra linefeeds for generated files. added a max_attributes
 * variable for generated .c file
 * 
 * Revision 1.3  85/06/25  18:36:05  shannon
 * moved generateincludefile routine to this file
 * 
 * Revision 1.2  85/06/20  10:18:21  shannon
 * fixed bug in the generation of the routine which writes a sequence
 * of a type.
 * fixed bug when descendant of a class root is a C keyword
 * 
 * Revision 1.1  85/06/13  09:30:18  shannon
 * Initial revision
 * 
 * Revision 1.1  85/06/11  10:06:05  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Mar  1985 (shannon) Created.					*
*									*
\* ******************************************************************* */
#include "Backend.h"
#include "macros.h"
#include <stdio.h>
#include <sys/time.h>
#include "misc.h"
#include "genpfile.h"
#include "gencfile2.h"

extern char WRITERFILE[];
extern char READERFILE[];
extern char GLOBALFILE[];

extern Boolean absinclpath;

/*
 *    Forward References:
 */
void PrintAttributes();
void PrintWList();
void PrintWArray();
void PrintMarkList();
void PrintMarkArray();
void PrintClassWriteMark();
void PrintNodeMark();
void GenerateInitRoutines();

/************************************/
/* generate the .h file		    */
/************************************/
void generateincludefile(Thisprocess )
ProcessEntity Thisprocess;
{
	FILE *incfile, *fopen();
	SETAtomic SAtomic;	/* seq/set traversals and values */
	Atomic AnAtomic;
	SEQAttribute restattr;
	Attribute Aattr;
	SETClass SClass;
	Class AClass;
	SEQClass SClass2;
	Class AClass2;
	SETTypeEntity STypeEntity;
	TypeEntity ATypeEntity;
	TypeEntity att_type;
	SETPort SPort;
	Port APort;
	String packagename;		/* name of private package */
	SEQString priv_files;		/* seq of private files included */
	StructureEntity invst;		/* invariant structure of process */
	String name, name2;		/* temporary names */
	char incfilename[MAXFILENAMELENGTH];  /* include file name */

	String GetDate();
	String GetVersion();
	Boolean DefineOperation();

	Assume((IsProcessEntity(Thisprocess)),
		"generateincludefile");

	/* de-reference invariant structure of process */
	invst = Thisprocess->sem_invariant;

	(void)sprintf(incfilename, "%s.h", Thisprocess->lex_name);
	if ((incfile = fopen(incfilename, "w")) == NULL){
		Fatal1(14, 0, Thisprocess->lex_name);
	}
	output1(incfile, "/* %s - IDL declarations generated by idlc,",
		incfilename);
	output2(incfile, " version %s \n    on %s*/\n", GetVersion(),GetDate());
	output0(incfile,"/*LINTLIBRARY*/\n");
	output1 (incfile,"\n#ifndef IDLGEN_%-s_h\n",Thisprocess->lex_name);
	output1 (incfile,"#define IDLGEN_%-s_h\n\n",Thisprocess->lex_name);
  	if (absinclpath == TRUE)
	  {
	   output1(incfile, "# include \"%s\"\n", GLOBALFILE);
	  }
	else
 	  {
	   output1(incfile, "# include <%s>\n", GLOBALFILE);
	  }
	
	output0(incfile, "extern Boolean IDLForceLabels;\n");

	/* Private type declarations */

	(void)fputs("\n/* Private Types */\n", incfile);
	/* first make sure that the private types are defined.*/
	initializeSEQString(priv_files);
	foreachinSETAtomic(invst->inv_privates, SAtomic, AnAtomic)
	    if (!(AnAtomic->sem_isPreludeType))
	      if (typeof(AnAtomic->rep_internalType)==KPackage)
		{ name = AnAtomic->rep_name;
		  packagename = AnAtomic->rep_internalType.VPackage->rep_name;
		  if (!inSEQString(priv_files, packagename)){
		    appendfrontSEQString(priv_files, packagename);
		    output1(incfile, "# include \"%s.h\"\n", packagename);
		  }
	        }
	      else if (IsTypeEntity(AnAtomic->rep_internalType))
		{ name = AnAtomic->rep_name;
		  output2(incfile, "#define %s %s\n",name,
			  AnAtomic->rep_internalType.VTypeEntity.
			   IDLclassCommon->rep_name);
		}


	/* class header declarations */

	(void)fputs("\n/* Class Headers */\n", incfile);
	foreachinSETClass(invst->inv_classes,SClass,AClass) {
	    name = AClass->rep_name;
	    if (!emptySEQAttribute(AClass->sem_allattributes))
		output2(incfile, "typedef struct CA%s * CP%s;\n", name, name);
	}



	/* node constant and pointer declarations */

	(void)fputs("\n/* Nodes */\n", incfile);
	foreachinSEQClass(invst->inv_nodes,SClass2,AClass){
	    name = AClass->rep_name;
	    if (!AClass->rep_enumerated){
	      Boolean private_flag;
	      output2(incfile, "typedef struct R%s * %s;\n", name, name);
	      output2(incfile, "# define K%s %d\n", name, AClass->rep_typeId);
	      private_flag=FALSE;
	      if ((DefineOperation(ClassToTypeEntity(AClass), "Create"))||
		  (DefineOperation(ClassToTypeEntity(AClass), "Destroy")))
		foreachinSEQAttribute(AClass->sem_allattributes, restattr,Aattr)
		{
		  att_type = GetAttributeType(Aattr);
		  if ((typeof(att_type)==KAtomic)&&
		      (!(att_type.VAtomic->sem_isPreludeType)))
		    { private_flag=TRUE;break;};
		}
	      if (DefineOperation(ClassToTypeEntity(AClass), "Create")) {
		if (private_flag) { output2(incfile,"%s IDLCinit_%s();\n",
					    StringToChar(name),
					    StringToChar(name));}
		else { output1(incfile,"# define IDLCinit_%s(X) (X)\n",
			     StringToChar(name));}
		output4(incfile,
			  "# define N%s (I%s(IDLCinit_%s((%s)N_INIT( \\\n",
			name, name, name,name);
		output2(incfile, "\tGetNode(sizeof(struct R%s),K%s), \\\n",
			name, name);
		output2(incfile, "\tK%s,sizeof(struct R%s)))))\n",name,name);
		};
	      if (DefineOperation(ClassToTypeEntity(AClass), "Destroy")) {
		if (private_flag) { output1(incfile,"void IDLCfinal_%s();\n",
					  StringToChar(name));}
		else { output1(incfile,"#define IDLCfinal_%s(X)\n",
			     StringToChar(name));}
		output1(incfile, "# define D%s(n) {", name);
		if (private_flag) { output1(incfile,"IDLCfinal_%s(n);",name); }
		output2(incfile, "F%s(n); FreeNode(n, sizeof(struct R%s));}\n",
			name, name);
	      }
	      if (!DefineOperation(ClassToTypeEntity(AClass), "DefaultInitialize")) {
		output2(incfile, "extern %s I%s();\n", name, name);
	      }
	      else output1(incfile, "# define I%s(N) (N)\n", name);
	      if (!DefineOperation(ClassToTypeEntity(AClass), "DefaultFinalize")) {
		output1(incfile, "extern void F%s();\n", name);
	      }
	      else output1(incfile, "# define F%s(N)\n", name);
	    }
	    else { /* enumerated types */
	      output1(incfile, "typedef int %s;\n", name);
	      output2(incfile, "# define K%s %d\n", name, AClass->rep_typeId);
	      if (DefineOperation(ClassToTypeEntity(AClass), "Create")) {
		output2(incfile, "# define N%s K%s\n", name, name);
	      }
	      if (DefineOperation(ClassToTypeEntity(AClass), "Destroy")) {
		output1(incfile, "# define F%s(n) \n", name);
	      }
	    }
	    output0(incfile, "\n");
	  }


	/* class declarations */

	(void)fputs("\n/* Classes */\n", incfile);
	foreachinSETClass(invst->inv_classes,SClass,AClass) {
	    name = AClass->rep_name;
	   
	    (void)fputs("typedef union {\n", incfile);
	    output0(incfile, "    int IDLinternal;\n");
	    if (!emptySEQAttribute(AClass->sem_allattributes)) {
		output1(incfile, "    CP%s IDLclassCommon;\n", name);
	    }
	    else (void)fputs("    HgenericHeader IDLclassCommon;\n", incfile);

	    foreachinSETClass(AClass->inv_alldescendants,SClass2,AClass2){
		name2 = AClass2->rep_name;
		output2(incfile, "    %s V%s;\n", name2,name2);
	    }
	    output1(incfile, "} %s;\n\n", name);
	}

	/* set and sequences declarations */

	(void)fputs("\n/* Sets and Sequences */\n", incfile);
	foreachinSETTypeEntity(invst->sem_types, STypeEntity, ATypeEntity) {
	    if (IsNamedType(ATypeEntity))
		AddSetSeqOperations(invst, ATypeEntity.VNamedType, incfile);
	}  /* end foreachinSETTypeEntity */ 



	/* Class header and common attributes in class */
	/* for each class with attributes */

	Assume((TRUE), "generateincludefile: after set/seq routines");
	(void)fputs("\n/* Class Attributes */\n", incfile);
	foreachinSETClass(invst->inv_classes,SClass,AClass) {
	    name = AClass->rep_name;
	    if (!emptySEQAttribute(AClass->sem_allattributes)) {
		output1(incfile, "struct CA%s {\n",name);
		output0(incfile, "    IDLnodeHeader IDLhidden;\n");
		PrintAttributes(AClass, incfile);
		output0(incfile, "};\n");
	    }
	}
	Assume((TRUE), "generateincludefile: after class headers");


	/* plain nodes declarations */

	(void)fputs("\n/* Node Structures*/\n", incfile);
	foreachinSEQClass(invst->inv_nodes, SClass2, AClass) {
	    name = AClass->rep_name;
	    if (!AClass->rep_enumerated) {
		output1(incfile, "struct R%s { IDLnodeHeader IDLhidden;\n", 
			name);
		PrintAttributes(AClass, incfile);
		output0(incfile, "};\n");
	    }
	}
	Assume((TRUE), "generateincludefile: after node declarations");

	/* private initialization */
	foreachinSETAtomic(invst->inv_privates, SAtomic, AnAtomic) {
	    name = AnAtomic->rep_name;

	    if (!AnAtomic->sem_isPreludeType &&
		(!DefineOperation(AtomicToTypeEntity(AnAtomic),"DefaultInitialize"))) {
		if (IsTypeEntity(AnAtomic->rep_internalType)) {
		    if (AnAtomic->rep_internalType.VTypeEntity
			.IDLclassCommon->sem_isPreludeType) {
			    output1(incfile, "#define I%s(N) (N)\n", 
					StringToChar(name));
		    }
		    else { 
			output2(incfile,"#define I%s(N) I%s(N)\n",
			       StringToChar(name),
			       StringToChar(AnAtomic->rep_internalType
					    .VTypeEntity.IDLclassCommon->rep_name)); 
		    }
		}
	        else { 
		    output2(incfile,"extern %s I%s();\n",StringToChar(name),
			     StringToChar(name)); 
		}
	    }
	    else { 
		output1(incfile,"#define I%s(N) (N)\n",StringToChar(name));
	    }

	    if (!AnAtomic->sem_isPreludeType && 
		  (!DefineOperation(AtomicToTypeEntity(AnAtomic),"DefaultFinalize"))) {
		if (IsTypeEntity(AnAtomic->rep_internalType)) {
		    if (AnAtomic->rep_internalType.VTypeEntity
		        .IDLclassCommon->sem_isPreludeType) {
			output1(incfile, "#define F%s(N)\n", StringToChar(name));
		    }
		    else { 
			output2(incfile,"#define F%s(N) F%s(N)\n",
			     StringToChar(name),
			     StringToChar(AnAtomic->rep_internalType
					  .VTypeEntity.IDLclassCommon->rep_name)); 
		    }
		}
		else { 
		    output1(incfile,"extern void F%s();\n",StringToChar(name));
		}
	    }
	    else { 
		output1(incfile,"#define F%s(N)\n",StringToChar(name));
	    }
	}

	/* Port declarations */

	(void)fputs("\n/* Port Declarations */\n", incfile);
	foreachinSETPort(Thisprocess->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) == KPrePort) {
		output2(incfile, "%s %s();\n", 
			RootName(APort->syn_data->sem_entity.VStructureEntity),
			APort->rep_name);
	    }
	    else {
		output1(incfile, "void %s();\n", APort->rep_name);
	    }
	}
	Assume((TRUE), "generateincludefile: after port declarations");

	output0 (incfile,"#endif\n");
	(void)fflush(incfile);
	(void)fclose(incfile);
}



/***********************************/
/* generate the .c file		   */
/***********************************/
void generateCcodefileA(pr, SplitFile, timestamp, candlefile)
ProcessEntity pr;	/* process */
Boolean SplitFile;	/* indicator if .c file should be split into 2 */
long timestamp;		/* timestamp of candle file */
char *candlefile;	/* path of candle file */
{

	FILE *cfile1, *cfile2, *cfile3,
	     *fopen();				/* file pointer and fn */
	char cfilename1[MAXFILENAMELENGTH];	/* name of cfile generated */
	char cfilename2[MAXFILENAMELENGTH];	/* name of cfile generated */
	char cfilename3[MAXFILENAMELENGTH];	/* name of cfile generated */
	SETPort SPort;
	Port APort;
	SETTypeEntity STypeEntity;
	TypeEntity ATypeEntity;
	int NextPortID = 0;
	void GenerateWriteMarkRoutines();
	void GenerateReadRoutines();
	SEQClass SClass;
	Class AClass;
	char *name;

	if (SplitFile) {
	    (void)sprintf(cfilename1, "%s1.c", pr->lex_name);
	    if ((cfile1 = fopen(cfilename1, "w")) == NULL){
		    Fatal1(15, 0, pr->lex_name);
	    }
	    (void)sprintf(cfilename2, "%s2.c", pr->lex_name);
	    if ((cfile2 = fopen(cfilename2, "w")) == NULL){
		    Fatal1(15, 0, pr->lex_name);
	    }
	    (void)sprintf(cfilename3, "%s3.c", pr->lex_name);
	    if ((cfile3 = fopen(cfilename3, "w")) == NULL){
		    Fatal1(15, 0, pr->lex_name);
	    }
	}
	else {
	    (void)sprintf(cfilename1, "%s.c", pr->lex_name);
	    (void)sprintf(cfilename2, "%s.c", pr->lex_name);
	    (void)sprintf(cfilename3, "%s.c", pr->lex_name);
	    if ((cfile1 = fopen(cfilename1, "w")) == NULL){
		    Fatal1(15, 0, pr->lex_name);
	    }
	    cfile2 = cfile1;
	    cfile3 = cfile1;
	}
	if (cfile1 != cfile2) {
	    output1(cfile1,"/* %s - IDL mark routines generated by idlc,",
		    cfilename1);
	    output2(cfile1, " version %s \n    on %s*/\n", 
		    GetVersion(), GetDate());
	    output0(cfile1,"/*LINTLIBRARY*/\n");
	    output1(cfile1, "# include \"%s.h\"\n", pr->lex_name);
	    (void)fputs("# include <stdio.h>\n", cfile1);

	    output1(cfile2, "/* %s - IDL read routines generated by idlc,",
		    cfilename2);
	    output2(cfile2, " version %s \n    on %s*/\n", 
		    GetVersion(), GetDate());
	    output0(cfile2,"/*LINTLIBRARY*/\n");
	    output1(cfile2, "# include \"%s.h\"\n", pr->lex_name);
	    (void)fputs("# include <stdio.h>\n", cfile2);

	    output1(cfile3,"/* %s - IDL write routines generated by idlc,",
		    cfilename3);
	    output2(cfile3, " version %s \n    on %s*/\n", 
		    GetVersion(), GetDate());
	    output0(cfile3,"/*LINTLIBRARY*/\n");
	    output1(cfile3, "# include \"%s.h\"\n", pr->lex_name);
	    (void)fputs("# include <stdio.h>\n", cfile3);
	}
	else {
	    output1(cfile1,"/* %s - IDL read/mark/write routines generated by idlc,",
		    cfilename1);
	    output2(cfile1, " version %s \n    on %s*/\n", 
		    GetVersion(), GetDate());
	    output0(cfile1,"/*LINTLIBRARY*/\n");
	    output1(cfile1, "# include \"%s.h\"\n", pr->lex_name);
	    (void)fputs("# include <stdio.h>\n", cfile1);
	}
	output1(cfile1, "\nchar *IDLprocessname = \"%s\";\n", pr->lex_name);
	output1(cfile1, "long IDLcompilationts = %ld;\n", timestamp);
	output1(cfile1, "char *IDLcandlefilename = \"%s\";\n\n", candlefile);

	/* generate definitions for temporary set/seq variables */
	(void)fputs("\n/* Sets and Sequences Temporary Variables */\n", cfile1);
	foreachinSETTypeEntity(pr->sem_invariant->sem_types, STypeEntity, ATypeEntity) {
	    if (IsNamedType(ATypeEntity))
		AddSetSeqDeclarations(pr->sem_invariant, ATypeEntity.VNamedType, cfile1);
	}  /* end foreachinSETTypeEntity */ 
	/* generate init routines for classes */
	GenerateInitRoutines(cfile1, pr->sem_invariant);

	/* First generate for each class A in the invariant a 
	   variable called IDLtempA */
	if (ShouldGenerateMacros(pr->sem_target.VTargetEntity))
	  foreachinSETClass(pr->sem_invariant->inv_classes,SClass,AClass)
	    { name=StringToChar(AClass->rep_name);
	      output2(cfile1,"%s IDLtemp%s;\n",name,name);
	      if (cfile1 != cfile2) 
		output2(cfile3,"%s IDLtemp%s;\n",name,name);
	    }
	if (!emptySETPort(pr->sem_ports)) 
	  {
	    /* for each input, output, marker, and unmarker Port, 
		define Port id */

	    NextPortID = 0;
	    foreachinSETPort(pr->sem_ports, SPort, APort) {
		NextPortID += 2;
		output2(cfile1, "# define P%s %d\n", 
			    APort->rep_name, NextPortID);
		if (cfile1 != cfile2)  {
		  output2(cfile2, "# define P%s %d\n", 
			  APort->rep_name, NextPortID);
		  output2(cfile3, "# define P%s %d\n", 
			  APort->rep_name, NextPortID);
		}
	    }
	    output0(cfile1,"int IDLportState;\n");
	    if (cfile1 != cfile3)  {
		output0(cfile2,"int IDLportState;\n");
		output0(cfile3,"int IDLportState;\n");
	    }
	    GenerateWriteMarkRoutines(cfile1, cfile3, pr);
	    GenerateReadRoutines(cfile2, pr);
	  }
	(void)fclose(cfile1);
	if (cfile2 != cfile1) 
	    (void)fclose(cfile2);
	if (cfile3 != cfile1) 
	    (void)fclose(cfile3);
}

void GenerateWriteMarkRoutines(cfile, cfile3, pr)
FILE *cfile,*cfile3;	   /* file pointer */
ProcessEntity pr;  /* process */
{

	SETPort tp;		/* set/seq traversals and values */
	Port pval;		
	SETTypeEntity tnt;	
	TypeEntity ntval;	
	SETAtomic tpnt;		
	Atomic pntval;		
	Atomic pntval2;		
	SETClass tc;		
	Class cval;		
	SEQClass tn;		
	Class nval;		
	SEQAttribute tf;	
	Attribute fval;		
	String tname;		/* temporary names */
	String name;
	String pname;
	String stname;
	String rootname;
	String ext_name, int_name;
	TypeEntity stroot;	/* root of a structure */
	SETflag flagset;	/* pointer to a flag set of a nonterminal  */
	StructureEntity invst;	/* invariant structure of the process */
	Boolean haspostmark = FALSE;
	Boolean Splitfile; /* indicates whether the Split file option is on */

	Atomic GetPortAtomic();
	char *GetInternalName();
	char *GetExternalName();
	Boolean InAllPorts();
	Boolean InOnePort();

	Assume((IsProcessEntity(pr)&&
	       (cfile != NULL)), "GenerateWriteMarkRoutines");

	Splitfile = cfile != cfile3;

	/* de-reference invariant structure */
	invst = pr->sem_invariant;

	foreachinSETPort(pr->sem_ports, tp, pval){
	    if ((typeof(pval->sem_portType) == KPostPort) || 
		(typeof(pval->sem_portType) == KMarkPort)){
	    	(void)fputs("# define DynMode 0\n", cfile);
    	    	(void)fputs("# define TwoPassMode 1\n", cfile);
	    	(void)fputs("# define FlatMode 0\n", cfile);
	    	(void)fputs("# define DynFormat 0\n", cfile);
		output0(cfile,"char charBuf[256];\n");
		if (absinclpath == TRUE)
	          {
	           output1(cfile, "# include \"%s\"\n", WRITERFILE);
		  }
		else
	 	  {
	           output1(cfile, "# include <%s>\n", WRITERFILE);
		  }
		if (cfile != cfile3) {
		  (void)fputs("# define DynMode 0\n", cfile3);
		  (void)fputs("# define TwoPassMode 1\n", cfile3);
		  (void)fputs("# define FlatMode 0\n", cfile3);
		  (void)fputs("# define DynFormat 0\n", cfile3);
		  output0(cfile3,"char charBuf[256];\n");
		  if (absinclpath == TRUE)
		    {
		     output1(cfile3, "# include \"%s\"\n", WRITERFILE);
		    }
		  else
		    {
		     output1(cfile3, "# include <%s>\n", WRITERFILE);
		    }
		  output0(cfile3, "extern Boolean IDLForceLabels;\n");
		};
		haspostmark = TRUE;
		break;
	    }
	}
	if (!haspostmark) return;
	output0(cfile, "Boolean IDLForceLabels = FALSE;\n");

	foreachinSETTypeEntity(invst->sem_types, tnt, ntval){

	    tname = ntval.IDLclassCommon->rep_name;
	    flagset = ntval.IDLclassCommon->inv_flags;

		/* for each class and plain node */

	    if ((typeof(ntval) == KClass) && 
			(!emptySETClass(ntval.VClass->sem_subclasses) ||
			(!ntval.VClass->rep_enumerated))) {

		if (inSETflag(flagset, KMSELF)) 
		    output1(cfile, "void M%s();\n", tname);
		if (inSETflag(flagset, KUSELF)) 
		    output1(cfile, "void U%s();\n", tname);
		if (inSETflag(flagset, KWSELF)) 
		    if (Splitfile)
		      output1(cfile3, "void W%s();\n", tname)
		    else
		      output1(cfile3, "static void W%s();\n", tname)
		if ((inSETflag(flagset, KMSET)) || 
		    (inSETflag(flagset, KMSEQ)) )
		    output2(cfile, "void M%s%s();\n", LLISTPREFIX, tname);
		if ((inSETflag(flagset, KUSET)) || 
		    (inSETflag(flagset, KUSEQ)) )
		    output2(cfile, "void U%s%s();\n", LLISTPREFIX, tname);
		if (inSETflag(flagset, KWSET)) 
		    if (Splitfile)
		      output1(cfile3, "void WSET%s();\n", tname)
		    else
		      output1(cfile3, "static void WSET%s();\n", tname)
		if (inSETflag(flagset, KWSEQ)) 
		    if (Splitfile)
		      output1(cfile3, "void WSEQ%s();\n", tname)
		    else
		      output1(cfile3, "static void WSEQ%s();\n", tname)
		if (inSETflag(flagset, KMARR)) 
		    output2(cfile, "void M%s%s();\n", ARRAYPREFIX, tname);
		if (inSETflag(flagset, KUARR)) 
		    output2(cfile, "void U%s%s();\n", ARRAYPREFIX, tname);
		if (inSETflag(flagset, KWASET)) 
		    if (Splitfile)
		      output1(cfile3, "void WSET%s();\n", tname)
		    else
		      output1(cfile3, "static void WSET%s();\n", tname)
		if (inSETflag(flagset, KWASEQ)) 
		    if (Splitfile)
		      output1(cfile3, "void WSEQ%s();\n", tname)
		    else
		      output1(cfile3, "static void WSEQ%s();\n", tname)
	    }
		
		/* for each enumerated node */

	    else if ((typeof(ntval)==KClass)&&(ntval.VClass->rep_enumerated)) {
		if (inSETflag(flagset, KMSELF)) 
		    output1(cfile, "#define M%s(X) \n", tname);
		if (inSETflag(flagset, KWSELF)) {
		    output1(cfile3, "#define W%s(X) ", tname);
		    output1(cfile3, "IDLout(\"%s\")\n", ntval.VClass->sem_name);
		}
		if (inSETflag(flagset, KUSELF)) 
		    output1(cfile, "#define U%s(X) \n", tname);
		if ((inSETflag(flagset, KMSET)) || (inSETflag(flagset, KMSEQ))) 
		    output2(cfile, "#define M%s%s(X) \n", LLISTPREFIX, tname);
		if (inSETflag(flagset, KWSET)) 
		    if (Splitfile)
		      output1(cfile3, "void WSET%s();\n", tname)
		    else
		      output1(cfile3, "static void WSET%s();\n", tname)
		if (inSETflag(flagset, KWSEQ)) 
		    if (Splitfile)
		      output1(cfile3, "void WSEQ%s();\n", tname)
		    else
		      output1(cfile3, "static void WSEQ%s();\n", tname)
		if ((inSETflag(flagset, KUSET)) || (inSETflag(flagset, KUSEQ))) 
		    output2(cfile, "#define U%s%s(X) \n", LLISTPREFIX, tname);
		if (inSETflag(flagset, KMARR))
		    output2(cfile, "#define M%s%s(X) \n", ARRAYPREFIX, tname);
		if (inSETflag(flagset, KUARR))
		    output2(cfile, "#define U%s%s(X) \n", ARRAYPREFIX, tname);
		if (inSETflag(flagset, KWASET)) 
		    if (Splitfile)
		      output1(cfile3, "void WSET%s();\n", tname)
		    else
		      output1(cfile3, "static void WSET%s();\n", tname)
		if (inSETflag(flagset, KWASEQ)) 
		    if (Splitfile)
		      output1(cfile3, "void WSEQ%s();\n", tname)
		    else
		      output1(cfile3, "static void WSEQ%s();\n", tname)
		output0(cfile, "\n");
		if (cfile != cfile3) 
		  output0(cfile3, "\n");
	    }
	}

		
		/* for each private type */
	foreachinSETAtomic(invst->inv_privates, tpnt, pntval) {
	    flagset = pntval->inv_flags;
	    tname = pntval->rep_name;
	    if (!pntval->sem_isPreludeType && (inSETflag(flagset,KWSELF)))
	    { 
		if (Splitfile)
  	          output1(cfile3,"void W%s();\n",StringToChar(tname))
		else
  	          output1(cfile3,"static void W%s();\n",StringToChar(tname))
	    }
	    if (inSETflag(flagset, KMSELF))  {
		if (pntval->sem_isPreludeType) {
		    output1(cfile,"#define M%s(N)\n",StringToChar(tname)); 
		}
		else {
		    if (IsTypeEntity(pntval->rep_internalType)) {
			if (pntval->rep_internalType.VTypeEntity
			    .IDLclassCommon->sem_isPreludeType) {
				output1(cfile, "#define M%s(N)\n", 
					StringToChar(tname));
			}
			else { 		  
			    output2(cfile, "#define M%s(X) M%s(X)\n",
				    tname, pntval->rep_internalType.
				    VTypeEntity.IDLclassCommon->rep_name);
			}
		    }
		    else {
			output1(cfile, "#define M%s(X)\n", tname);
		    }
		}
	    }
	    

	    if ((inSETflag(flagset, KMSET)) || 
		(inSETflag(flagset, KMSEQ)) )
		output2(cfile, "void M%s%s();\n", LLISTPREFIX, tname);
	    if ((inSETflag(flagset, KUSET)) || 
		(inSETflag(flagset, KUSEQ)) )
		output2(cfile, "void U%s%s();\n", LLISTPREFIX, tname);
	    if (inSETflag(flagset, KWSET)) 
		if (Splitfile)
		  output1(cfile3, "void WSET%s();\n", tname)
		else
		  output1(cfile3, "static void WSET%s();\n", tname)
	    if (inSETflag(flagset, KWSEQ)) 
		if (Splitfile)
		  output1(cfile3, "void WSEQ%s();\n", tname)
  		else
		  output1(cfile3, "static void WSEQ%s();\n", tname)
	    if (inSETflag(flagset, KMARR)) 
		output2(cfile, "void M%s%s();\n", ARRAYPREFIX, tname);
	    if (inSETflag(flagset, KUARR)) 
		output2(cfile, "void U%s%s();\n", ARRAYPREFIX, tname);
	    if (inSETflag(flagset, KWASET)) 
		if (Splitfile)
		  output1(cfile3, "void WSET%s();\n", tname)
		else
		  output1(cfile3, "static void WSET%s();\n", tname)
	    if (inSETflag(flagset, KWASEQ)) 
		if (Splitfile)
		  output1(cfile3, "void WSEQ%s();\n", tname)
		else
		  output1(cfile3, "static void WSEQ%s();\n", tname)
	}



	    /* for each class */
	foreachinSETClass(invst->inv_classes, tc, cval) {
	    tname = cval->rep_name;
	    if (inSETflag(cval->inv_flags, KWSEQ)) {
		PrintWList(tname, SEQPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(cval->inv_flags, KWSET)) {
		PrintWList(tname, SETPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(cval->inv_flags, KWASEQ)){
		PrintWArray(tname, SEQPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(cval->inv_flags, KWASET)) {
		PrintWArray(tname, SETPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(cval->inv_flags, KMSEQ) || 
			inSETflag(cval->inv_flags,KMSET)){
		PrintMarkList(tname, "M", cfile);
	    }
	    if (inSETflag(cval->inv_flags, KUSEQ) || 
			inSETflag(cval->inv_flags,KUSET)){
		PrintMarkList(tname, "U", cfile);
	    }
	    if (inSETflag(cval->inv_flags, KMARR)) {
		PrintMarkArray(tname, "M", cfile);
	    }
	    if (inSETflag(cval->inv_flags, KUARR)) {
		PrintMarkArray(tname, "U", cfile);
	    }
	    if (inSETflag(cval->inv_flags, KWSELF)) {
		PrintClassWriteMark(pr, cval, "W", KWSELF, cfile3,Splitfile);
	    }
	    if (inSETflag(cval->inv_flags, KMSELF)) {
		PrintClassWriteMark(pr, cval, "M", KMSELF, cfile,Splitfile);
	    }
	    if (inSETflag(cval->inv_flags, KUSELF)) {
		PrintClassWriteMark(pr, cval, "U", KUSELF, cfile,Splitfile);
	    }
	}   /* end for class*/

	/* for each  node */
	foreachinSEQClass(invst->inv_nodes, tn, nval) {
	    tname = nval->rep_name;
	    if (inSETflag(nval->inv_flags, KWSEQ)) {
		PrintWList(tname, SEQPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(nval->inv_flags, KWSET)) {
		PrintWList(tname, SETPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(nval->inv_flags, KWASEQ)){
		PrintWArray(tname, SEQPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(nval->inv_flags, KWASET)){
		PrintWArray(tname, SETPREFIX, cfile3,Splitfile);
	    }

	    /* the rest of the functions are for plain nodes only */
	    if (nval->rep_enumerated)
		continue;

	    if ((inSETflag(nval->inv_flags, KMSEQ)) ||
	        (inSETflag(nval->inv_flags, KMSET))) {
		PrintMarkList(tname, "M", cfile);
	    }
	    if ((inSETflag(nval->inv_flags, KUSEQ)) ||
	        (inSETflag(nval->inv_flags, KUSET))) {
		PrintMarkList(tname, "U", cfile);
	    }
	    if (inSETflag(nval->inv_flags, KMARR)) {
		PrintMarkArray(tname, "M", cfile);
	    }
	    if (inSETflag(nval->inv_flags, KUARR)) {
		PrintMarkArray(tname, "U", cfile);
	    }
	    if (inSETflag(nval->inv_flags, KMSELF)) {
		PrintNodeMark(nval, pr, "M", cfile);
	    }
	    if (inSETflag(nval->inv_flags, KUSELF)) {
		PrintNodeMark(nval, pr, "U", cfile);
	    }
	    if (inSETflag(nval->inv_flags, KWSELF)) {
		if (Splitfile)
		  output1(cfile3, "void W%s(IDLn)\n", tname)
		else
		  output1(cfile3, "static void W%s(IDLn)\n", tname)
		output1(cfile3, "register %s IDLn;\n", tname);
		output0(cfile3, "{\n\tregister String Sep;\n");
		output1(cfile3, "\tif (IDLn==(%s)NULL) {WError(ErrNullNode); ",
				tname);
		output0(cfile3, "return; }\n");
		output0(cfile3, "\tif (!NodeTouched(IDLn)) {IDLoutLabel(IDLn); ");
		output0(cfile3, "IDLoutC(UpArrow); return; }\n");
		output0(cfile3, "\telse if (NodeShared(IDLn) || IDLForceLabels) {\n");
		output0(cfile3, "\t\tIDLoutLabel(IDLn); IDLoutC(Colon);\n");
		output0(cfile3, "\t\tUnmarkShared(IDLn); UnmarkTouched(IDLn);\n");	
	output0(cfile3, "\t} else {UnmarkTouched(IDLn); }\n");
		output1(cfile3, "\tIDLout(\"%s\"); Sep = \"[\";\n", 
				nval->sem_name);
		foreachinSEQAttribute(nval->sem_allattributes, tf, fval) {
		    if (!InOnePort(pr, fval->inv_ports, KPostPort))
			continue;

		    if (!InAllPorts(pr, fval->inv_ports, KPostPort)) {
		      output0(cfile3, "\n\tif ( ");
		      foreachinSETPort(fval->inv_ports, tp, pval) {
			if (typeof(pval->sem_portType) == KPostPort)
			    output1(cfile3, "(IDLportState == P%s) ||", 
				    pval->rep_name);
		      }
		      output0(cfile3, "(0) ) \n");
		    }
		    output1(cfile3,"\t{IDLout(Sep); IDLout(\"%s\");",
				fval->lex_name);
		    output0(cfile3, " IDLoutC(AttrSep);\n");

		    output2(cfile3, "\t(void)W%s(IDLn->%s);\n", 
				    GetAttTypeName(fval),
				    fval->rep_name);
	            output0(cfile3, "\tSep = \";\\n\";\n\t}\n");
		} /* end foreachinSEQAttribute */

	        output0(cfile3,"\tif (Sep[0] != OpenBracket) IDLout(\"]\\n\");");
	        output0(cfile3, "\n}\n");

	    } /* end if */


	} /* end for each node */
	Assume((TRUE), "GenerateWriteMark: after node routines");

	/* for each private type */
	foreachinSETAtomic(invst->inv_privates, tpnt, pntval)  {
	    flagset = pntval->inv_flags;
	    name = pntval->rep_name;

	    if (!pntval->sem_isPreludeType && inSETflag(flagset, KWSELF)){
		if (Splitfile)
		  output2(cfile3,"void W%s(IDLc)\n%s IDLc;\n{\n",
			  StringToChar(name),StringToChar(name))
		else
		  output2(cfile3,"static void W%s(IDLc)\n%s IDLc;\n{\n",
			  StringToChar(name),StringToChar(name))
		output0(cfile3,"\tswitch(IDLportState){\n");
		foreachinSETPort(pntval->inv_ports,tp,pval) {
		    if (typeof(pval->sem_portType)!=KPostPort)
			continue;
		    pntval2 = GetPortAtomic(pval, pntval);
		    ext_name=pntval2->rep_externalType.VTypeEntity
			      .IDLclassCommon->rep_name;
		    if (IsTypeEntity(pntval->rep_internalType))
			  int_name = pntval->rep_internalType.VTypeEntity
				.IDLclassCommon->rep_name;
		    else int_name = pntval->rep_name;

		    output1(cfile3,"\tcase P%s: {\n", StringToChar(pval->rep_name));
		    output1(cfile3,"\t   %s IDLext;\n", StringToChar(ext_name));
		    if (ext_name==int_name) {
		    output0(cfile3, "\t    IDLext=IDLc;\n");
		    }
		    else {		
			output3(cfile3, "\t    %s %sTo%s();\n",
				  StringToChar(ext_name),
				  StringToChar(int_name),
				  StringToChar(ext_name));
			output2(cfile3, "\t    IDLext=%sTo%s(IDLc);\n",
				  StringToChar(int_name),
				  StringToChar(ext_name));
		    }

		    if (inSETflag(pntval2->rep_externalType.VTypeEntity
				      .IDLclassCommon->inv_flags,KMSELF)) {
			  output1(cfile3, "\t    M%s(IDLext);\n",
				      StringToChar(ext_name));
		    }
		    output1(cfile3, "\t    (void)W%s(IDLext);\n\t  };break;\n",
				StringToChar(ext_name));
		}
		output0(cfile3,"\t}\n}\n");
	    }

	    if (inSETflag(flagset, KWSEQ)) {
		PrintWList(name, SEQPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(flagset, KWSET)) {
		PrintWList(name, SETPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(flagset, KWASEQ)){
		PrintWArray(name, SEQPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(flagset, KWASET)) {
		PrintWArray(name, SETPREFIX, cfile3,Splitfile);
	    }
	    if (inSETflag(flagset, KMSEQ) || 
			inSETflag(flagset,KMSET)){
		PrintMarkList(name, "M", cfile);
	    }
	    if (inSETflag(flagset, KUSEQ) || 
			inSETflag(flagset,KUSET)){
		PrintMarkList(name, "U", cfile);
	    }
	    if (inSETflag(flagset, KMARR)) {
		PrintMarkArray(name, "M", cfile);
	    }
	    if (inSETflag(flagset, KUARR)) {
		PrintMarkArray(name, "U", cfile);
	    }

	}
	Assume((TRUE), "GenerateWriteMark: after atomic routines");

	foreachinSETPort(pr->sem_ports, tp, pval) {
	  stroot = GetRoot(pval->syn_data->sem_entity.VStructureEntity);
	  rootname = RootName(pval->syn_data->sem_entity.VStructureEntity);
	  pname = pval->rep_name;
	  stname = pval->syn_data->lex_name;

	  /* for each output Port */
	  if (typeof(pval->sem_portType) == KPostPort) {
	    output0(cfile3, "/*VARARGS*/\n");
	    output1(cfile3, "void %s (filePtr, IDLN\n", pname);
	    output0(cfile3, "# if DynMode\n, mode\n# endif\n# if DynFormat\n");
	    output0(cfile3, ", format\n# endif\n)\nFILE * filePtr;\n");
	    output1(cfile3, "%s IDLN;\n# if DynMode\nint mode;\n", rootname);
	    output0(cfile3, "# endif\n# if DynFormat\nint format;\n");
	    output1(cfile3, "#endif\n{\tvoid M%s();\n",rootname);
	    output1(cfile3, "\tIDLportState = P%s;\n", pname);
	    output0(cfile3, "\tIDLcurrentFile = filePtr;\n");
	    output0(cfile3, "# if DynMode\n\tswitch (mode) {\n");
	    output0(cfile3, "\tcase FLAT:\n# endif\n");

/* FlatMode not supported yet: need O_Node and FreeHeap
	    output0(cfile3, "# if (DynMode || FlatMode)\n");
	    if ((typeof(stroot)==KClass) && IsClassType(stroot.VClass)) {
	        output0(cfile3, "\t\tO_Node(IDLN.IDLinternal);\n");
	    }
	    else if ((typeof(stroot)==KClass) && IsNodeType(stroot.VClass)) {
		output0(cfile, "\t\tO_Node((int)IDLN);\n");
	    }
	    output0(cfile3, "\t\twhile (doList != (struct ncell *)NULL) {\n");
	    output0(cfile3, "\t\t   register struct ncell *l;\n");
	    output0(cfile3, "\t\t   l = doList; doList = l->next;\n");
	    output0(cfile3, "\t\t   O_Node(l->value); FreeHeap(l);\n");
	    output0(cfile3, "\t\t}\n");
	    output0(cfile3, "\t\twhile (doneList != (struct ncell *)NULL) {\n");
	    output0(cfile3, "\t\t    register struct ncell *l;\n");
	    output0(cfile3, "\t\t    l = doneList;\n");
	    output0(cfile3, "\t\t    UnmarkTouched(l->value); \n");
	    output0(cfile3, "\t\t    UnmarkShared(l->value);\n");
	    output0(cfile3, "\t\t    doneList = l->next;FreeHeap(l);\n");
	    output0(cfile3, "\t\t}\n");
	    output0(cfile3, "# endif\n");
*/
	    
	    output0(cfile3, "# if DynMode\n\t\tbreak;\n");
	    output0(cfile3, "\tcase TWOPASS:\n# endif\n");
	    output0(cfile3, "# if DynMode || TwoPassMode\n");
	    output1(cfile3, "\t\t(void)fprintf(IDLcurrentFile, \"-- structure %s\\n\");\n",
		    stname);
	    output2(cfile3, "\t\tM%s(IDLN);\n\t\t(void)W%s(IDLN);\n", 
			rootname, rootname);
	    output0(cfile3, "\n# endif\n# if DynMode\n\t\tbreak;\n");
	    output0(cfile3, "\tdefault:\n\t\tWError(ErrPortMode);\n\t}\n");
	    output0(cfile3, "# endif\n\t(void)fputs(\"#\\n\", IDLcurrentFile);\n");
	    output0(cfile3, "\treturn;\n}\n");
	  } /* if output Port */

	  /* for each marker Port */
	  else if (typeof(pval->sem_portType) == KMarkPort) {
	    output2(cfile, "void %s (IDLC)\n%s IDLC;\n{\n",pname, rootname);
	    output1(cfile, "\tIDLportState = P%s;\n", pname);
	    output1(cfile, "\n\tM%s(IDLC);\n", rootname);
	    output0(cfile, "}\n");
	  }

	  /* for each unmarker Port */
	  else if (typeof(pval->sem_portType) == KUnmarkPort) {
	    output2(cfile, "void %s (IDLC)\n%s IDLC;\n{\n", pname, rootname);
	    output2(cfile, "\tIDLportState = P%s;\n\tU%s(IDLC);\n",
		    pname, rootname);
	    output0(cfile, "}\n");
	  }

	}   /* end for each in SETPort */
}

void GenerateReadRoutines(cfile, pr)
FILE *cfile;		    /* file pointer */
ProcessEntity pr;	    /* process */
{

	SETPort tp;		/* traversal of Port set */
	Port pval;		/* value of a Port in the set */
	SETTypeEntity tnt;	/* traversal of set of nonterminals */
	TypeEntity ntval;	/* value of a nonterminal in the set */
	SETClass td;		/* traversal of the descendants of a class */
	Class dval;		/* value of a descendant in the class */
	SETAtomic tpnt;		/* traversal of set of privates */
/*	SETAtomic tpnt2;	   commented out below  */
	Atomic pntval,pntval2;	/* value of a Atomic in the set */
	SEQClass tn;		/* traversal of seq of nodes */
	Class nval;		/* value of a node in the seq */
	SEQAttribute tf;	/* traversal of fields of a node or class */
	Attribute fval;		/* value of a field in the seq */
	String tname;		/* name of a nonterminal */
	SETflag flagset;	/* pointer to a flag set of a nonterminal  */
	int i;			/* counter */
	int num_nodes;		/* number of nodes in invariant structure */
	int max_attributes;	/* maximum number of attributes in any node */
	int att_count;		/* used to count maximum number of attributes */
	Boolean hasreader;	/* indicator if process has reader */	
	StructureEntity invst;	/* invariant structure of the process */
	String ext_name, int_name;
	String name2,
	       pname, rootname; /* temporary names */
	TypeEntity stroot;	/* root of a structure */
	TypeEntity att_type;	/* typeof an attribute */

	Atomic GetPortAtomic();
	char *GetAttrStoreTypeCase();
	char *GetInternalName();
	char *GetExternalName();
	Boolean InAllPorts();
	Boolean InOnePort();
	Boolean ReadAttribute();
        Boolean NCStringMatch();


	Assume((IsProcessEntity(pr)&& (cfile != NULL)),
		"GenerateReadRoutines");

	/* de-reference the invariant structure */
	invst = pr->sem_invariant;

	/* check if there are reader routines. If not, return right away */
	hasreader = FALSE;
	foreachinSETPort(pr->sem_ports, tp, pval){
	    if (typeof(pval->sem_portType) == KPrePort) {
		hasreader = TRUE;
		break;
	    }
	}
	if (!hasreader)
	    return;

	/* begin writing read routines */

	if (absinclpath == TRUE)
	  {
	   output1(cfile, "# include \"%s\"\n", READERFILE);
	  }
	else
	  {
	   output1(cfile, "# include <%s>\n", READERFILE);
	  }
	(void)fputs("Boolean ReaderOK;\n", cfile);

	output0(cfile, "extern ntype *IDLAllNodeTypes;\n");
	output0(cfile, "extern char **IDLNodeAttributes;\n");
	output0(cfile, "extern int IDLnum_nodetypes;\n");
	output0(cfile, "extern int IDLmax_attributes;\n");

	/* print out the node structure and node count */

	num_nodes = 0;
	output1(cfile, "static ntype IDL%sAllNodeTypes[] = {\n",pr->lex_name);
	foreachinSEQClass(invst->inv_nodes, tn, nval) {
	    tname = nval->rep_name;
	    output2(cfile, "  { \"%s\", K%s },\n",nval->sem_name, tname);
	    ++num_nodes;
	}
	output0(cfile, "  { (char *)\"\", (int)NULL}\n};\n");


	/* calculate the maximum attributes */
	max_attributes = 0;
	foreachinSEQClass(invst->inv_nodes, tn, nval){
	    att_count = lengthSEQAttribute(nval->sem_allattributes) + 1;
	      if (att_count > max_attributes) 
		  max_attributes = att_count;
	}
	output1(cfile, "#define IDLMAXATTRIBUTES %d\n", max_attributes);

	/* print out the node attributes structure */

	output0(cfile, "static struct  {\n    char *attributes[IDLMAXATTRIBUTES];\n}");
	output1(cfile, " IDL%sNodeAttributes[] = {\n",pr->lex_name);
	foreachinSEQClass(invst->inv_nodes, tn, nval){
	  if (!nval->rep_enumerated) {
	    output0(cfile, "  {" ); 
	    foreachinSEQAttribute(nval->sem_allattributes, tf, fval){
		output1(cfile, " \"%s\",", fval->lex_name);
	    }
	    output0(cfile, " (char *)\"\" },\n");
	  }
	}
	output0(cfile, "  { (char *)\"\" }\n};\n");
	output2(cfile, "static int IDL%snum_nodetypes  = %d;\n\n", 
		pr->lex_name, num_nodes);


	/* write out G routines */
	foreachinSETTypeEntity(invst->sem_types, tnt, ntval){

	    tname = ntval.IDLclassCommon->rep_name;
	    flagset = ntval.IDLclassCommon->inv_flags;

		/* for each class and plain node */

	    if ((typeof(ntval) == KClass) && 
		    (!emptySETClass(ntval.VClass->sem_subclasses) ||
		    (!ntval.VClass->rep_enumerated))) {

		if (IsClassType(ntval.VClass) && (inSETflag(flagset, KGSELF))){
		    output2(cfile,"%s G%s();\n",tname, tname);
		}
		else if (IsNodeType(ntval.VClass) && (inSETflag(flagset, KGSELF))){
		    output2(cfile, 
			"# define G%s(R) ((%s)((R)->UnionField.NodeField))\n", 
			tname, tname);
		}
		if ((inSETflag(flagset, KGSET)) || 
		    (inSETflag(flagset, KGSEQ)) ) {
		    output4(cfile, "%s%s G%s%s();\n", 
				LLISTPREFIX, tname, LLISTPREFIX, tname);
		    if (inSETflag(flagset, KGSET)) {
			output4(cfile, "#define G%s%s(R) G%s%s(R)\n", 
				SETPREFIX, tname, LLISTPREFIX, tname);
		    }
		    if (inSETflag(flagset, KGSEQ)) {
			output4(cfile, "#define G%s%s(R) G%s%s(R)\n", 
				SEQPREFIX, tname, LLISTPREFIX, tname);
		    }
		}
		if (inSETflag(flagset, KGARR)) {
		    output4(cfile, "%s%s G%s%s();\n", 
				ARRAYPREFIX, tname, ARRAYPREFIX, tname);
		    output4(cfile, "#define G%s%s(R) G%s%s(R)\n",
				SETPREFIX, tname, ARRAYPREFIX, tname);
		    output4(cfile, "#define G%s%s(R) G%s%s(R)\n",
				SEQPREFIX, tname, ARRAYPREFIX, tname);
		}
		output0(cfile, "\n");
	    }
		
		/* for each enumerated node */

	    else if ((typeof(ntval) == KClass)&&(ntval.VClass->rep_enumerated)) {
		if (inSETflag(flagset, KGSELF)) {
		    output2(cfile, "static struct NodeType _%s[1] = {K%s, };\n",
			    tname, tname);
		    output2(cfile, "#define G%s(R) K%s\n", tname, tname);
		}
		if ((inSETflag(flagset, KGSET)) || 
		    (inSETflag(flagset, KGSEQ)) ) {
		    output4(cfile, "%s%s G%s%s();\n", 
				LLISTPREFIX, tname, LLISTPREFIX, tname);
		    if (inSETflag(flagset, KGSET)) {
			output4(cfile, "#define G%s%s(R) G%s%s(R)\n", 
				SETPREFIX, tname, LLISTPREFIX, tname);
		    }
		    if (inSETflag(flagset, KGSEQ)) {
			output4(cfile, "#define G%s%s(R) G%s%s(R)\n", 
				SEQPREFIX, tname, LLISTPREFIX, tname);
		    }
		}
		if (inSETflag(flagset, KGARR)) {
		    output4(cfile, "%s%s G%s%s();\n", 
				ARRAYPREFIX, tname, ARRAYPREFIX, tname);
		}
		output0(cfile, "\n");
	    }
	}

		
		/* for each private type */
	    
	foreachinSETAtomic(invst->inv_privates, tpnt, pntval) {
	    flagset = pntval->inv_flags;
	    tname = pntval->rep_name;
	    if (!pntval->sem_isPreludeType && (inSETflag(flagset,KGSELF)))
	      { /* declarations concerned with reading private types */
/*		SETTypeEntity ptypes;
		initializeSETTypeEntity(ptypes);   Not used commented out */
		output2(cfile,"%s G%s();\n",StringToChar(tname),
			StringToChar(tname));
/* declared locally
		foreachinSETPort(pntval->inv_ports,tp,pval)
		  if ((typeof(pval->sem_portType)==KPrePort)&&
		      (typeof(pval->syn_data->sem_entity)==KStructureEntity))
		    foreachinSETAtomic(GetStructureEntity(pval->syn_data)->inv_privates,
				       tpnt2,pntval2)
		      if ((tname==pntval2->rep_name) &&
			  (IsTypeEntity(pntval2->rep_externalType)))
			addSETTypeEntity(ptypes,pntval2->rep_externalType.VTypeEntity);
		foreachinSETTypeEntity(ptypes,tnt,ntval) {
		  String ext_name, int_name;
		  if (IsTypeEntity(pntval->rep_internalType))
		    int_name = pntval->rep_internalType.VTypeEntity.IDLclassCommon->rep_name;
		  else int_name = pntval->rep_name;
		  if (IsTypeEntity(pntval->rep_externalType)) {
		    ext_name = pntval->rep_externalType.VTypeEntity.IDLclassCommon;
		    if (int_name != ext_name) {
		      output3(cfile,"extern %s %sTo%s();\n",
			      StringToChar(ext_name),
			      StringToChar(int_name),
			      StringToChar(ext_name)); }
		  }
	      }
*/
/*
	    if (!pntval->sem_isPreludeType &&(inSETflag(flagset, KGSELF)))  {
		if (IsTypeEntity(pntval->rep_externalType)) {
		    if (IntTypeSameExtType(pntval)) {
			output2(cfile, "#define G%s(X) G%s(X)\n",
				tname,
				GetExternalRepName(pntval->rep_externalType));
		    }
		    else {
			output4(cfile, "%s G%s(); extern %s * I%s();\n",
			    tname, tname, tname, tname);
		    }
		}
	    }
*/
	      }
	    if ((inSETflag(flagset, KGSET)) || 
		(inSETflag(flagset, KGSEQ)) ) {
		output4(cfile, "%s%s G%s%s();\n", 
			    LLISTPREFIX, tname, LLISTPREFIX, tname);
		if (inSETflag(flagset, KGSET)) {
		    output4(cfile, "#define G%s%s(R) G%s%s(R)\n", 
			    SETPREFIX, tname, LLISTPREFIX, tname);
		}
		if (inSETflag(flagset, KGSEQ)) {
		    output4(cfile, "#define G%s%s(R) G%s%s(R)\n", 
			    SEQPREFIX, tname, LLISTPREFIX, tname);
		}
	    }
	    if (inSETflag(flagset, KGARR)) {
		output4(cfile, "%s%s G%s%s();\n", 
			    ARRAYPREFIX, tname, ARRAYPREFIX, tname);
		if (!inSETflag(flagset, KGSET)) {
		    output4(cfile, "#define G%s%s(R) G%s%s(R)\n",
				SETPREFIX, tname, ARRAYPREFIX, tname);
		}
		if (!inSETflag(flagset, KGSEQ)) {
		    output4(cfile, "#define G%s%s(R) G%s%s(R)\n",
				SEQPREFIX, tname, ARRAYPREFIX, tname);
		}
	    }
	}
	Assume((TRUE), "GenerateReadRoutines: before inport routines");

	/* write input Port routines */
	foreachinSETPort(pr->sem_ports, tp, pval) {
	      /* for each input Port */
	  pname = pval->rep_name;
	  stroot = GetRoot(pval->syn_data->sem_entity.VStructureEntity);
	  rootname = RootName(pval->syn_data->sem_entity.VStructureEntity);

	  if (typeof(pval->sem_portType) == KPrePort) {
	    if ((typeof(stroot)==KClass) && (IsClassType(stroot.VClass))) {
		output2(cfile, "%s %s (IDLF)\n", rootname, pname);
		output1(cfile, "FILE *IDLF;\n{\t%s IDLC;\n", rootname);
		output0(cfile, "\tNodeType IDLN;\n");
		output1(cfile, "\tNodeType %sNodeAlloc();\n", pr->lex_name);
		output1(cfile, "\tvoid %sAttrStore();\n", pr->lex_name);
		output0(cfile, "\textern PF_NodeType GenericNodeAlloc;\n");
		output0(cfile, "\textern PF_AttrStore GenericAttrStore;\n");
		output1(cfile, "\n\tIDLAllNodeTypes = IDL%sAllNodeTypes;\n",
			pr->lex_name);
		output1(cfile, "\n\tIDLNodeAttributes = (char **)IDL%sNodeAttributes;\n",
			pr->lex_name);
		output0(cfile, "\tIDLmax_attributes = IDLMAXATTRIBUTES;\n");
		output1(cfile, "\tIDLnum_nodetypes = IDL%snum_nodetypes;\n",
			pr->lex_name);
		output1(cfile, "\tGenericNodeAlloc = %sNodeAlloc;\n",
				pr->lex_name);
		output1(cfile, "\tGenericAttrStore = %sAttrStore;\n",
				pr->lex_name);
		output1(cfile, "\tIDLportState = P%s;\n",
			StringToChar(pval->rep_name)); 
		output0(cfile, "\tIDLN = Reader(IDLF);\n");
		output0(cfile, "\tif (OK) switch (TypeNode(IDLN)) {\n");
		foreachinSETClass(stroot.VClass->inv_alldescendants, td, dval) {
		    if (IsNodeType(dval)){
			tname = dval->invar.IDLclassCommon->rep_name;
		        output3(cfile, 
			    "\t    case K%s: IDLC.V%s = (%s)AtNode(IDLN); break;\n",
			    tname, tname, tname);
		    }
		}
		output0(cfile,"\t    default: Error(ErrBadRootType, Lex.Pos);");
		output0(cfile, " OK = 0;break;\n\t}\n");
		output0(cfile, "\tReaderOK = OK;");
		output0(cfile, "\n\treturn(IDLC);\n}\n");
	    }
	    else if ((typeof(stroot)==KClass) && (IsNodeType(stroot.VClass))) {
		output2(cfile, "%s %s(IDLF)\n", rootname, pname);
		output1(cfile, "FILE *IDLF;\n{\t%s IDLC;\n",rootname);
		output0(cfile, "\tNodeType IDLN;\n");
		output1(cfile, "\tNodeType %sNodeAlloc();\n", pr->lex_name);
		output1(cfile, "\tvoid %sAttrStore();\n", pr->lex_name);
		output0(cfile, "\textern PF_NodeType GenericNodeAlloc;\n");
		output0(cfile, "\textern PF_AttrStore GenericAttrStore;\n");
		output1(cfile, "\n\tIDLAllNodeTypes = IDL%sAllNodeTypes;\n",
			pr->lex_name);
		output1(cfile, "\n\tIDLNodeAttributes = (char **)IDL%sNodeAttributes;\n",
			pr->lex_name);
		output0(cfile, "\tIDLmax_attributes = IDLMAXATTRIBUTES;\n");
		output1(cfile, "\tIDLnum_nodetypes = IDL%snum_nodetypes;\n",
			pr->lex_name);
		output1(cfile, "\tGenericNodeAlloc = %sNodeAlloc;\n",
				pr->lex_name);
		output1(cfile, "\tGenericAttrStore = %sAttrStore;\n",
				pr->lex_name);
		output1(cfile, "\tIDLportState = P%s;\n",
			StringToChar(pval->rep_name)); 
		output0(cfile, "\tIDLN = Reader(IDLF);\n");
		output1(cfile, "\tif (!OK) {\n\t\tIDLC = (%s)NULL;\n\t}\n",
				rootname);
		output1(cfile, "\telse if (TypeNode(IDLN) == K%s) {\n",rootname);
		output1(cfile, "\t\tIDLC = (%s)AtNode(IDLN);}\n", rootname);
		output0(cfile, "\telse {\n");
		output0(cfile, "\t\tError(ErrBadRootType, Lex.Pos);\n");
		output1(cfile, "\t\tOK = 0;\n\t\tIDLC = (%s)NULL; }\n",
				rootname);
		output0(cfile, "\tReaderOK = OK;\n\treturn(IDLC);\n}\n");
	    }
	  }
	}   /* end for each in SETPort */

	/* generate node allocation routine */

	output1(cfile, "NodeType %sNodeAlloc(IDLN)\nregister int IDLN;\n",
			pr->lex_name);
	output0(cfile, "{\tregister NodeType IDLnt;\n\tswitch(IDLN) {\n");
	foreachinSEQClass(invst->inv_nodes, tn, nval)  {
	    tname = nval->rep_name;
	    if (inSETflag(nval->inv_flags, KGSELF)) {
		if (!nval->rep_enumerated)  {
		    output2(cfile, "\t    case K%s: SetNPtr(IDLnt, (int)N%s);",
			    tname, tname);
		    output0(cfile, " break;\n");
		}
		else output2(cfile, "\t    case K%s: IDLnt = _%s; break;\n",
			    tname, tname);
	    }
	}
	output0(cfile, "\t    default: Error(ErrBadNodeType, Lex.Pos);\n");
	output0(cfile, "\t             OK = 0;\n");
	output0(cfile, "\t             break;\t}\n\treturn(IDLnt);\n}\n");


	/* for each class & node & atomic */

	foreachinSETTypeEntity(invst->sem_types, tnt, ntval) {
	    if ((typeof(ntval) == KClass) || (typeof(ntval) == KAtomic)){
		flagset = ntval.IDLclassCommon->inv_flags;
		tname = ntval.IDLclassCommon->rep_name;

		if ((inSETflag(flagset, KGSEQ)) ||
		    (inSETflag(flagset, KGSET))) {

		    output4(cfile, "%s%s G%s%s (IDLR)\n", 
				LLISTPREFIX, tname, LLISTPREFIX, tname);
		    output0(cfile, "RepType IDLR;\n{");
		    output0(cfile, "\tregister SeqType IDLS1;\n");
		    output2(cfile, "\tregister %s%s IDLS2, IDLP, retval;\n",
				LLISTPREFIX, tname);
		    output0(cfile, "\tIDLS1 = IDLR->UnionField.seqVal;\n");
		    output0(cfile, "\tif (IDLS1){\n");
		    output2(cfile, "\t\tretval = IDLP = (%s%s)GetListCell",
				LLISTPREFIX, tname);
		    output1(cfile, "(sizeof(C%s));\n", tname);
		    output1(cfile, "\t\tIDLP->value = G%s(IDLS1->value); \n", tname);
		    output0(cfile, "\t\tIDLS1 = IDLS1->next;\n\t\twhile (IDLS1) {\n");
		    output3(cfile, "\t\t\tIDLS2 = (%s%s)GetListCell(sizeof(C%s));",
				LLISTPREFIX, tname, tname);
		    output1(cfile, "\n\t\t\tIDLS2->value = G%s(IDLS1->value);\n",
				tname);
		    output0(cfile, "\t\t\tIDLP->next = IDLS2; IDLP = IDLS2; ");
		    output2(cfile,"IDLS1 = IDLS1->next;\n\t\t}\n\t\tIDLP->next = (%s%s)NULL;",
			    	LLISTPREFIX, tname);
		    output2(cfile, "\n\t}\n\telse retval = (%s%s)NULL;\n",
			    	LLISTPREFIX, tname);
		    output0(cfile, "\treturn(retval);\n}\n");
		}
		if (inSETflag(flagset, KGARR)) {
		    output4(cfile, "%s%s G%s%s(IDLR)\n", 
				ARRAYPREFIX, tname, ARRAYPREFIX, tname);
		    output0(cfile, "RepType IDLR;\n{");
		    output2(cfile, "\t%s%s IDLAtype;\n", ARRAYPREFIX, tname);
		    output0(cfile, "\tregister SeqType IDLS;\n");
		    output0(cfile, "\tregister int size;\n");
		    output1(cfile, "\tregister %s *IDLA;\n", tname);
		    output0(cfile, "\tsize = 0;\n");
		    output0(cfile, "\tIDLS = IDLR->UnionField.seqVal;\n");
		    output0(cfile, "\twhile (IDLS) {++size; IDLS=IDLS->next;}\n");
		    output1(cfile, "\tIDLA = (%s *)IDLNewArray(size);\n",
			    tname);
		    output0(cfile, "\tIDLAtype.array = IDLA;\n");
		    output0(cfile, "\tIDLAtype.size = size;\n");
		    output0(cfile, "\tIDLAtype.length = size;\n");
		    output0(cfile, "\tIDLS = IDLR->UnionField.seqVal;\n");
		    output1(cfile, "\twhile (IDLS) {\n\t\t*IDLA = G%s(IDLS->value);\n",
				tname);
		    output0(cfile, "\t\tIDLS = IDLS->next;\n\t\tIDLA++;\n\t}");
		    output0(cfile, "\n\treturn(IDLAtype);\n}\n");
		} 
		if ((typeof(ntval)==KClass) &&
		    (IsClassType(ntval.VClass)) && (inSETflag(flagset,KGSELF))){
		    output2(cfile, "%s G%s (IDLR)\n", tname, tname);
		    output0(cfile, "register RepType IDLR;\n");
		    output1(cfile, "{\n\t%s IDLRet;\n", tname);
		    output0(cfile, "\tswitch(IDLR->UnionField.NodeField");
		    output0(cfile, "->IDLhidden.TypeID) {\n");
		    foreachinSETClass(ntval.VClass->inv_alldescendants,td,dval){
			if (!inSETflag(dval->inv_flags, KGSELF))
			    continue;
			if (IsNodeType(dval)) {
			  name2 = dval->rep_name;
			  output2(cfile, "\t\tcase K%s: IDLRet.V%s =", 
					name2, name2);
			  output1(cfile, " G%s(IDLR); break;\n", name2);
		        }
		    }
		    output0(cfile, 
			  "\t\tdefault: Error(ErrBadClassNode, Lex.Pos);\n");
		    output0(cfile, "\t}\n\treturn(IDLRet);\n}\n");
		}  /* end if Class && inSETflag */
	    }
	}
		

		    
	/* for each private type */

	foreachinSETAtomic(invst->inv_privates, tpnt, pntval) {
	  flagset = pntval->inv_flags;
	  if (!pntval->sem_isPreludeType && (inSETflag(flagset, KGSELF))) {
	      tname=pntval->rep_name;
	      output2(cfile,"%s G%s(IDLR)\nregister RepType IDLR;\n{\n",
		      StringToChar(tname),StringToChar(tname));
	      output0(cfile,"\tswitch(IDLportState){\n");
	      foreachinSETPort(pntval->inv_ports,tp,pval) {
		  if (typeof(pval->sem_portType)!=KPrePort)
		      continue;
		  pntval2 = GetPortAtomic(pval, pntval);

		  if (IsTypeEntity(pntval->rep_internalType))
		      int_name = pntval->rep_internalType.VTypeEntity
			.IDLclassCommon->rep_name;
		  else int_name = pntval->rep_name;

		  if (IsTypeEntity(pntval2->rep_externalType)) { 
			ext_name=pntval2->rep_externalType.VTypeEntity
			      .IDLclassCommon->rep_name;
			output2(cfile,"\tcase P%s:\n\t  {  %s IDLn;\n",
				StringToChar(pval->rep_name),
				StringToChar(ext_name));
			if (int_name != ext_name) {
			    output3(cfile, "\t    %s %sTo%s();\n",
				  StringToChar(int_name),
				  StringToChar(ext_name),
				  StringToChar(int_name));
/*				  StringToChar(ext_name),
				  StringToChar(int_name),
				  StringToChar(ext_name));
*/
			}
			output1(cfile, "\t    IDLn=G%s(IDLR);\n",
				StringToChar(ext_name));
			if (int_name == ext_name) {
			    output0(cfile, "\t    return IDLn;\n\t  }\n")
			}
			else {
			    output2(cfile,
				     "\t    return(%sTo%s(IDLn));\n\t  }\n",
				     StringToChar(ext_name),
				     StringToChar(int_name));
			}
		   }
	      } /* foreachinSETPort */

	      output0(cfile,"\t}\n/*NOTREACHED*/\n}\n");
	  }
	}

	/* generate attribute storage routine if there is a reader */
	output1(cfile, "void %sAttrStore(IDLN,IDLA,IDLR)\n", pr->lex_name);
	output0(cfile, "register NodeType IDLN;\nregister AttrDesc IDLA;\n");
	output0(cfile, "register RepType IDLR;\n{");
	output0(cfile, "\tswitch(IDLN->IDLhidden.TypeID) {\n");
	foreachinSEQClass(invst->inv_nodes, tn, nval) {
	    tname = nval->rep_name;
	    if ((!emptySEQAttribute(nval->sem_allattributes)) &&
		(inSETflag(nval->inv_flags, KGSELF))) {
		
		output1(cfile, "\t\tcase K%s: switch (IDLA) {\n", tname);
		i = 0;
		foreachinSEQAttribute(nval->sem_allattributes, tf, fval) {

		  att_type = GetAttributeType(fval);
		  if (!ReadAttribute(fval)) /* attribute is not read in */
			++i;
	          else if ((typeof(att_type) == KSetOf) &&
			   (NCStringMatch(att_type.VSetOf->rep_package, 
					  BITVECTOR))) {
			   
		    output5(cfile, "\t\t\tcase %d: G%s(IDLR,((%s)(IDLN))->%s, %d);\n",
				++i, att_type.VSetOf->rep_name,
				tname, fval->rep_name, 
				atoi(att_type.VSetOf->rep_numelements.
				VintegerToken ->lex_externalform));
		    output0(cfile, "\t\t\t         break;\n");
		  }
	          else {
		    output4(cfile, "\t\t\tcase %d: ((%s)(IDLN))->%s = %s\n", ++i,
				tname, fval->rep_name,
				GetAttrStoreTypeCase(fval));
		    output0(cfile, "\t\t\t         break;\n");
	          }

		}
		output0(cfile, "\t\t\tdefault: Error(ErrBadAttribute,");
		output0(cfile, "Lex.Pos); \n\t\t} break;\n");
	    }
	}
 	output0(cfile, "\t\tdefault: Error(ErrBadNodeType, Lex.Pos);");
 	output0(cfile, " break;\n\t}\n\tDelRep(IDLR);\n}\n");

}

void PrintAttributes(AClass, incfile)
Class AClass;
FILE *incfile;
{
	SEQAttribute SAttribute;
	Attribute AnAttribute;
	TypeEntity att_type;
	int currpos;
	int attsize;
	int diff;
	int num_att;


	Assume((IsClass(AClass)&&(incfile!=NULL)), "PrintAttributes");

	currpos = 32;
	num_att = 0;
	foreachinSEQAttribute(AClass->sem_allattributes,SAttribute,AnAttribute){
	    ++num_att;
	    att_type = GetAttributeType(AnAttribute);
	    attsize = att_type.IDLclassCommon->rep_size;
	    if (Att_Offset(AnAttribute) > currpos) {
		diff = Att_Offset(AnAttribute) - currpos;
		if ((diff % 8) == 0) {
		    output2(incfile, "    char placeholder%d[%d];\n",
				num_att, (diff/8));
		}
		else {
		    output2(incfile, "    unsigned int placeholder%d:%d;\n",
				num_att, diff);
		}
		currpos = Att_Offset(AnAttribute);
	    }
	    if (typeof(att_type) == KSetOf) {
		if (NCStringMatch(att_type.VSetOf->rep_package,BITVECTOR)){
		    output3(incfile, "    %s %s[%d];\n", 
			    att_type.VSetOf->rep_name,
			    AnAttribute->rep_name, 
			    atoi(att_type.VSetOf->rep_numelements.VintegerToken
			    ->lex_externalform));
		}
		else output2(incfile, "    %s %s;\n", 
			GetAttTypeName(AnAttribute), 
			AnAttribute->rep_name);
	    }
	    else output2(incfile, "    %s %s;\n", 
		    GetAttTypeName(AnAttribute), 
		    AnAttribute->rep_name);
	    currpos += attsize;
	}
}


void PrintWList(name, setseqstring, cfile,Splitfile)
String name;
String setseqstring;
FILE *cfile;
Boolean Splitfile;
{
	Assume((IsString(name) && 
		((!strcmp(setseqstring, SEQPREFIX))||
		 (!strcmp(setseqstring, SETPREFIX)))),
		 "PrintWList");

	if (Splitfile)
	  output2(cfile, "void W%s%s(IDLS)\n", setseqstring, name)
	else
	  output2(cfile, "static void W%s%s(IDLS)\n", setseqstring, name)
	output2(cfile, "register %s%s IDLS;\n{", LLISTPREFIX, name);
	if (!strcmp(setseqstring, SEQPREFIX)){
	    output0(cfile, "\tIDLoutC(OpenAngle);\n");
	}
	else {
	    output0(cfile, "\tIDLoutC(OpenBrace);\n");
	}
	output0(cfile, "\tif (IDLS) {\n");
	output1(cfile, "\t\t(void)W%s(IDLS->value);\n\t\tIDLS = IDLS->next;\n", 
			name);
	output0(cfile, "\t\twhile (IDLS) {\n");
	output0(cfile, "\t\t    IDLoutC(ListLink);\n");
	output1(cfile, "\t\t    (void)W%s(IDLS->value);\n", name);
	output0(cfile, "\t\t    IDLS = IDLS->next;\n");
	output0(cfile, "\t\t}\n\t}\n"); 
	if (!strcmp(setseqstring, SEQPREFIX)){
	    output0(cfile, "\tIDLoutC(CloseAngle);\n");
	}
	else output0(cfile, "\tIDLoutC(CloseBrace);\n");
	output0(cfile, "}\n");
}

void PrintWArray(name, setseqstring, cfile,Splitfile)
String name;
String setseqstring;
FILE *cfile;
Boolean Splitfile;
{
	Assume((IsString(name) && 
		((!strcmp(setseqstring, SEQPREFIX))||
		 (!strcmp(setseqstring, SETPREFIX)))&&
		 (cfile != NULL)),
		 "PrintWArray");

	if (Splitfile)
	  output2(cfile, "void W%s%s(IDLAtype)\n", setseqstring, name)
	else
	  output2(cfile, "static void W%s%s(IDLAtype)\n", setseqstring, name)
	output2(cfile, "%s%s IDLAtype;\n", setseqstring, name);
	output0(cfile, "{\tregister int len;\n");
	output1(cfile, "\tregister %s *IDLA;\n", name);
	output0(cfile, "\tIDLA = IDLAtype.array;\n");
	if (!strcmp(setseqstring, SEQPREFIX)) {
	    output0(cfile, "\tIDLoutC(OpenAngle);\n");
	}
	else {
	    output0(cfile, "\tIDLoutC(OpenBrace);\n");
	}
	output0(cfile, "\tfor (len=0; len<IDLAtype.length;++len,++IDLA) {\n");
	output0(cfile, "\t\tIDLoutC(ListLink);\n");
	output1(cfile, "\t\t(void)W%s(*IDLA);\n\t}\n", name);
	if (!strcmp(setseqstring, SEQPREFIX)){
	    output0(cfile, "\tIDLoutC(CloseAngle);\n");
	}
	else {
	    output0(cfile, "\tIDLoutC(CloseBrace);\n");
	}
	output0(cfile, "}\n");
}

void PrintMarkList(name, markUnmark, cfile)
String name;
String markUnmark;
FILE *cfile;
{
	Assume((IsString(name) && 
		((!strcmp(markUnmark, "M"))||
		 (!strcmp(markUnmark, "U")))&&
		 (cfile != NULL)),
		 "PrintMarkList");

	output3(cfile, "void %s%s%s(IDLS)\n", markUnmark, LLISTPREFIX, name);
	output2(cfile, "register %s%s IDLS;\n{\n", LLISTPREFIX, name);
	output0(cfile, "\t\twhile (IDLS) {\n");
	output2(cfile, "\t\t    %s%s(IDLS->value);\n", markUnmark, name);
	output0(cfile, "\t\t    IDLS = IDLS->next;\n");
	output0(cfile, "\t\t}\n}\n");
}

void PrintMarkArray(name, markUnmark, cfile)
String name;
String markUnmark;
FILE *cfile;
{

	Assume((IsString(name) && 
		((!strcmp(markUnmark, "M"))||
		 (!strcmp(markUnmark, "U")))&&
		 (cfile != NULL)),
		 "PrintMarkArray");
	output3(cfile, "void %s%s%s(IDLAtype)\n", markUnmark, ARRAYPREFIX, name);
	output2(cfile, "%s%s IDLAtype;\n{\n", ARRAYPREFIX, name);
	output1(cfile, "\tregister %s *IDLA;\n", name);
	output0(cfile, "\tregister int len;\n\tlen = IDLAtype.length;\n");
	output0(cfile, "\tfor (IDLA=IDLAtype.array; len; len--, ++IDLA)\n");
	output2(cfile, "\t\t{ %s%s(*IDLA); }\n}\n", markUnmark, name);
}

void PrintClassWriteMark(pr, cval, writemarkstring, aflag, cfile,Splitfile)
ProcessEntity pr;
Class cval;
String writemarkstring;
int aflag;  /* KUSELF KMSELF KWSELF */
FILE *cfile;
Boolean Splitfile;
{
	String name, name2;
	SETClass td;
	Class dval;
	SETPort SPort;
	Port APort;
	int porttype;
	Boolean SubclassInAllPorts();
	Boolean SubclassInOnePort();
	Boolean inall;

	Assume((IsClass(cval) && 
		((!strcmp(writemarkstring, "W"))||
		 (!strcmp(writemarkstring, "M"))||
		 (!strcmp(writemarkstring, "U")))&&
		 ((aflag==KUSELF)||(aflag==KMSELF)||(aflag==KWSELF)) &&
		 (cfile != NULL)),
		 "PrintClassWriteMark");
	name = cval->rep_name;
	if (Splitfile)
	  output2(cfile, "void %s%s (IDLC)\n", writemarkstring, name)
	else 
	  output2(cfile, "static void %s%s (IDLC)\n", writemarkstring, name)
	output1(cfile, "%s IDLC;\n{", name);
	output0(cfile, "\n\tswitch(typeof(IDLC)) {\n");
	foreachinSETClass(cval->inv_alldescendants, td, dval) {
	    if (IsNodeType(dval) && (inSETflag(dval->inv_flags, aflag))) { 
		    name2=dval->rep_name;

		    if (!strcmp(writemarkstring, "M")) {
			if ((!SubclassInOnePort(pr, cval, dval, KMarkPort)) &&
			    (!SubclassInOnePort(pr, cval, dval, KPostPort))) 
			     continue;

			output1(cfile, "\t    case K%s: \n", name2);

			inall = SubclassInAllPorts(pr, cval, dval, KMarkPort) &&
			        SubclassInAllPorts(pr, cval, dval, KPostPort);

			if (!inall) {
			  output0(cfile, "\t\tif ( ");
			  foreachinSETPort(dval->inv_ports, SPort, APort) {
			    if (!HasSubclass(APort, cval, dval))
				continue;
			    if ((typeof(APort->sem_portType)==KMarkPort) || 
				(typeof(APort->sem_portType)==KPostPort))
				output1(cfile, "(IDLportState == P%s) ||", 
					APort->rep_name);
			  }
			  output0(cfile, "(0) )\n");
			}
			output3(cfile, "\t\t%s%s(IDLC.V%s);\n",
			    writemarkstring, name2, name2);
			if (!inall) {
			    output0(cfile,"\t\telse {WError(ErrBadClassType);");
			    output0(cfile,"\n\t\t    (void)fprintf(stderr, \"\\tBad class is %%d\\n\",typeof(IDLC));}\n");
			}
			output0(cfile, "\t\tbreak;\n");
		    }
		    else {
			if (!strcmp(writemarkstring, "W"))
			    porttype = KPostPort;
			else
			    porttype = KUnmarkPort;
			if (!SubclassInOnePort(pr, cval, dval, porttype))
			    continue;

			output1(cfile, "\t    case K%s: \n", name2);

			inall = SubclassInAllPorts(pr, cval, dval, porttype);
			if (!inall) {
			  output0(cfile, "\t\tif ( ");
			  foreachinSETPort(dval->inv_ports, SPort, APort) {
			    if (!HasSubclass(APort, cval, dval))
				continue;
			    if (typeof(APort->sem_portType)==porttype) 
				output1(cfile, "(IDLportState == P%s) ||", 
					APort->rep_name);
			  }
			  output0(cfile, "(0) )\n");
			}
			output3(cfile, "\t\t%s%s(IDLC.V%s);\n",
			    writemarkstring, name2, name2);
			if (!inall) {
			    output0(cfile,"\t\telse {WError(ErrBadClassType);");
			    output0(cfile,"\n\t\t    (void)fprintf(stderr, \"\\tBad class is %%d\\n\",typeof(IDLC));}\n");
			}
			output0(cfile, "\t\tbreak;\n");
		    }
	    }
	}
	output0(cfile, "\t    default: WError(ErrBadClassType);\n");
	output0(cfile, "\t\t         (void)fprintf(stderr, \"\\tBad class is %%d\\n\",typeof(IDLC));\n");
	output0(cfile, "\t}\n}\n");
}

void PrintNodeMark(node, pr, markUnmark, cfile)
Class node;
ProcessEntity pr;
String markUnmark;
FILE *cfile;
{
     	SEQAttribute SAtt;
	Attribute AnAtt;
	SETPort SPort;
	Port APort;
	String name;
	TypeEntity att_type;
	NamedType component;
	String buf;
	SETflag flagset;


	Assume((IsClass(node)&&IsProcessEntity(pr)&&
	       ((!strcmp(markUnmark, "M"))||(!strcmp(markUnmark, "U")))&&
	       (cfile != NULL)),
	       "PrintNodeMark");

	name = node->rep_name;

	output2(cfile, "void %s%s(IDLn)\n", markUnmark, name);
	output1(cfile, "register %s IDLn;\n", name);
	output1(cfile, "{\n\tif (IDLn==(%s)NULL) return;\n", name);
	if (!strcmp(markUnmark, "M")) {
	    output0(cfile, "\tif (NodeTouched(IDLn)) {\n\t\tMarkShared(IDLn);");
	    output0(cfile, " return; }\n");
	    output0(cfile, "\telse {\n\t\tMarkTouched(IDLn);\n");
	}
	else {
	    output0(cfile, "\tif (!NodeTouched(IDLn)) return;\n");
	    output0(cfile, "\telse {\n\t\t");
	    output0(cfile, "UnmarkTouched(IDLn); UnmarkShared(IDLn);\n");
	}
	foreachinSEQAttribute(node->sem_allattributes, SAtt, AnAtt) {

	    if (!strcmp(markUnmark, "M")) {
		if ((!InOnePort(pr, AnAtt->inv_ports, KMarkPort)) &&
		 (!InOnePort(pr, AnAtt->inv_ports, KPostPort))) 
		     continue;
		if ((!InAllPorts(pr, AnAtt->inv_ports, KMarkPort)) ||
		   (!InAllPorts(pr, AnAtt->inv_ports, KPostPort))) {
		  output0(cfile, "\n\t\tif ( ");
		  foreachinSETPort(AnAtt->inv_ports, SPort, APort) {
		    if ((typeof(APort->sem_portType)==KMarkPort) || 
			(typeof(APort->sem_portType)==KPostPort))
			output1(cfile, "(IDLportState == P%s) ||", 
				APort->rep_name);
		  }
		  output0(cfile, "(0) )\n");
		}
	    }
	    else {
		if (!InOnePort(pr, AnAtt->inv_ports, KUnmarkPort))
		    continue;
		if (!InAllPorts(pr, AnAtt->inv_ports, KUnmarkPort)) {
		  output0(cfile, "\n\t\tif ( ");
		  foreachinSETPort(AnAtt->inv_ports, SPort, APort) {
		    if (typeof(APort->sem_portType)==KUnmarkPort) 
			output1(cfile, "(IDLportState == P%s) ||", 
				APort->rep_name);
		  }
		  output0(cfile, "(0) )\n");
		}
	    }
	    

		/* if attribute type is a set or sequence */
	    att_type = GetAttributeType(AnAtt);
	    if ((typeof(att_type) == KSetOf) || (typeof(att_type) == KSeqOf)){
		component = GetComponentType(att_type.VSetOrSeq);
		buf = component.IDLclassCommon->rep_name;
		flagset = component.IDLclassCommon->inv_flags;
		if (!strcmp(markUnmark, "M")) {
		    if (inSETflag(flagset, KMSET) ||
			inSETflag(flagset, KMSEQ)) {
			output3(cfile, "\t\t{M%s%s(IDLn->%s);}\n", 
				    LLISTPREFIX, buf, AnAtt->rep_name);
		    }
		    else if (inSETflag(flagset, KMARR)) {
			output3(cfile, "\t\t{M%s%s(IDLn->%s);}\n", 
			    ARRAYPREFIX, buf, AnAtt->rep_name);
		    }
		    else {
			output0(cfile, ";");
		    }
		}
		else {
		    if (inSETflag(flagset, KUSET) ||
			inSETflag(flagset, KUSEQ)) {
			output3(cfile, "\t\t{U%s%s(IDLn->%s);}\n", 
				    LLISTPREFIX, buf, AnAtt->rep_name);
		    }
		    else if (inSETflag(flagset, KUARR)) {
			output3(cfile, "\t\t{U%s%s(IDLn->%s);}\n", 
			    ARRAYPREFIX, buf, AnAtt->rep_name);
		    }
		    else {
			output0(cfile, ";");
		    }
		}
	    }

		/* if attribute type is a private, node or class  */
	    else {
		flagset = att_type.IDLclassCommon->inv_flags;
		if (!strcmp(markUnmark, "M")) {
		    if (inSETflag(flagset, KMSELF)) {
			output3(cfile, "\t\t{%s%s(IDLn->%s);}\n", 
			    markUnmark,
			    GetAttTypeName(AnAtt), AnAtt->rep_name);
		    }
		    else {
			output0(cfile, ";");
		    }
		}
		else {
		    if (inSETflag(flagset, KUSELF)) {
			output3(cfile, "\t\t{%s%s(IDLn->%s);}\n", 
			    markUnmark,
			    GetAttTypeName(AnAtt), AnAtt->rep_name);
		    }
		    else {
			output0(cfile, ";");
		    }
		}
	    }
	}
	output0(cfile, "\t}\n}\n");
}

void GenerateCMacros(pr)
ProcessEntity pr;
{
    SETClass SClass;		/* set/seq traversals and values */
    Class AClass;
    SEQClass SNode;
    Class ANode;
    SEQAttribute SAtt;
    Attribute AnAtt;
    SETClass Ssubclass;
    Class Asubclass;
    SETClass Ssubclass2;
    Class Asubclass2;
    String name;		/* for de-referencing */
    String dname;
    StructureEntity invst;
    char buf[81];		/* to construct name of file */
    FILE *mfile, *fopen();	/* file ptr and function */

    Assume((IsProcessEntity(pr)), "GenerateCMacros");

    (void)sprintf(buf, "%sMacros.h", pr->lex_name);
    if ((mfile=fopen(buf, "w")) == NULL) {
	(void)(void)fprintf(stderr, "Can't open macros file %s\n", buf);
	return;
    }


    invst = pr->sem_invariant;

    /* generate attribute accesses */
    output0(mfile, "/* Class Attribute accessing macros */\n\n");
    foreachinSETClass(invst->inv_classes, SClass, AClass) {
	name = AClass->rep_name;
	foreachinSEQAttribute(AClass->sem_allattributes, SAtt, AnAtt) {
	    output3(mfile, "#define %sOf%s(A%s) ",
			AnAtt->lex_name, name, name);
	    output2(mfile, "(A%s).IDLclassCommon->%s\n", name, AnAtt->rep_name);
	}
    }
    output0(mfile, "\n/* Node Attribute  accessing macros */\n\n");
    foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	name = ANode->rep_name;
	foreachinSEQAttribute(ANode->sem_allattributes, SAtt, AnAtt) {
	    output3(mfile, "#define %sOf%s(A%s) ",
			AnAtt->lex_name, name, name);
	    output2(mfile, " (A%s)->%s\n", name, AnAtt->rep_name);
	}
    }

    /* generate conversion macros */
    output0(mfile, "\n/* Widening Conversion macros */\n\n");
    foreachinSEQClass(invst->inv_classes, SClass, AClass) {
	name = AClass->rep_name;
	output2(mfile, "extern %s IDLtemp%s;\n", name, name);
	foreachinSETClass(AClass->inv_alldescendants, Ssubclass, Asubclass) {
	    dname = Asubclass->rep_name;
	    /* descendant to class */
	    output3(mfile, "#define %sTo%s(A%s) \\\n",dname, name, dname);
	    output4(mfile, "\t(IDLtemp%s.V%s = A%s, IDLtemp%s)\n", 
			name, dname, dname, name);
	}
	output0(mfile, "\n");
    }
    /* generate conversion macros */
    output0(mfile, "\n/* Narrowing Conversion macros */\n\n");
    foreachinSEQClass(invst->inv_classes, SClass, AClass) {
	name = AClass->rep_name;
	foreachinSETClass(AClass->inv_alldescendants, Ssubclass, Asubclass) {
	    dname = Asubclass->rep_name;

	    output3(mfile, "#define %sTo%s(A%s) \\\n",name, dname, name);
	    /* class to node descendant */
	    if (emptySETClass(Asubclass->sem_subclasses)) {
		output4(mfile, "\t((typeof(A%s)==K%s) ? (A%s).V%s :\\\n",
		    name, dname, name, dname);
		output4(mfile, "\t(ConversionError(\"%s\",\"%s\"), (A%s).V%s))\n",
		    name, dname, name, dname);
	    }
	    else {
		output0(mfile, "\t((");
		foreachinSETClass(Asubclass->inv_alldescendants, 
						Ssubclass2, Asubclass2) {
		    if (emptySETClass(Asubclass2->sem_subclasses)) {
			output2(mfile, "(typeof(A%s)==K%s)||", name, 
				Asubclass2->rep_name);
		    }
		}
		output2(mfile, "0) ?\\\n\t(A%s).V%s :\\\n", name, dname);
		output4(mfile, "\t(ConversionError(\"%s\",\"%s\"), (A%s).V%s))\n",
		    name, dname, name, dname);
	    }

	}
	output0(mfile, "\n");
    }

    /* generate Is macros for classes */
    foreachinSEQClass(invst->inv_classes, SClass, AClass) {
	name = AClass->rep_name;
	output1(mfile, "#define Is%s(C) (", name);
	foreachinSETClass(AClass->inv_alldescendants, Ssubclass, Asubclass) {
	    if (emptySETClass(Asubclass->sem_subclasses)) {
		dname = Asubclass->rep_name;
		output1(mfile, " (typeof(C)==K%s) ||", dname);
	    }
	}
	output0(mfile, " 0 )\n");
    }
}

void GenerateInitRoutines(cfile, st)
FILE *cfile;
StructureEntity st;
{
	SEQClass 	tn;
	Class 		nval;
	SEQAttribute	tf;
	Attribute	fval;
	SETAttribute	tattrset;
	String 		name;
	SETAttribute	privates;
	TypeEntity	att_type;

	/* For each node generate routines to initialize the private types
	   contained in them. */
	foreachinSEQClass(st->inv_nodes,tn,nval){
	    name=nval->rep_name;
	    if ((!nval->rep_enumerated)&&
		 ((DefineOperation(ClassToTypeEntity(nval), "Create"))
		 ||(DefineOperation(ClassToTypeEntity(nval), "Destroy"))))
	    {
		initializeSETAttribute(privates);
	        foreachinSEQAttribute(nval->sem_allattributes, tf,fval) {
		    att_type = GetAttributeType(fval);
		    if ((typeof(att_type)==KAtomic)&&
			(!(att_type.VAtomic->sem_isPreludeType)))
			      addSETAttribute(privates,fval);
		}
		if (!emptySETAttribute(privates)){
		    if (DefineOperation(ClassToTypeEntity(nval), "Create")) { 
			output2(cfile,"%s IDLCinit_%s(IDLn)\n",
				StringToChar(name),
				StringToChar(name));
			output1(cfile,"%s IDLn;\n{\n",StringToChar(name));
			foreachinSETAttribute(privates,tattrset,fval) {
			    att_type = GetAttributeType(fval);
			    output3(cfile, "\tIDLn->%s=I%s(IDLn->%s);\n",
				    StringToChar(fval->rep_name),
				    StringToChar(att_type.
						IDLclassCommon->rep_name),
				    StringToChar(fval->rep_name));
			}
			output0(cfile,"\treturn(IDLn);\n}\n\n");
		    }
		    if (DefineOperation(ClassToTypeEntity(nval), "Destroy")) { 
			output1(cfile,"/*ARGSUSED*/\nvoid IDLCfinal_%s(IDLn)\n",
				StringToChar(name));
			output1(cfile,"%s IDLn;\n{\n",StringToChar(name));
			foreachinSETAttribute(privates,tattrset,fval) {
			    att_type = GetAttributeType(fval);
			    output2(cfile, "\tF%s(IDLn->%s);\n",
				    StringToChar(att_type.
						IDLclassCommon->rep_name),
				    StringToChar(fval->rep_name));
			}
			output0(cfile,"}\n\n");
		    }
	        }
	    }
	}
}
