/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/flags.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Backend.h"
#include "macros.h"
#include <stdio.h>

/* Add SetOrSeq flags */

void SetOrSeqtest(ThisType, TheSetflag, TheSeqflag)
TypeEntity ThisType;
int TheSetflag;
int TheSeqflag;
{
	NamedType comptype;

	switch typeof(ThisType) {
	    case KSeqOf:
		comptype = ThisType.VSeqOf->sem_component;
		addSETflag(comptype.IDLclassCommon->invar
			    .IDLclassCommon->inv_flags,
			    TheSeqflag);
		break;
	    case KSetOf:
		comptype = ThisType.VSetOf->sem_component;
		addSETflag(comptype.IDLclassCommon->invar
			    .IDLclassCommon->inv_flags,
			    TheSetflag);
		break;
	}
}


void SetFlags(Thisprocess)
ProcessEntity Thisprocess;
{

	SETTypeEntity SType;
	TypeEntity AType;
	SETPort Sport;
	Port Aport;
	StructureEntity invariant;
	StructureEntity portst;
	Boolean ShouldMark();

	Assume((IsProcessEntity(Thisprocess)),
		"SetFlags");
	
	invariant = Thisprocess->sem_invariant;

	/* set I flags for invariant */

	foreachinSETTypeEntity(invariant->sem_types, SType, AType) {
	    SetOrSeqtest(AType, KILSET, KILSEQ);
	}

	/* set flags for port nonterminals */

	foreachinSETPort(Thisprocess->sem_ports,Sport,Aport) {
	    portst = GetStructureEntity(Aport->syn_data);
	    switch (typeof(Aport->sem_portType)) {
	    case KPrePort:
		foreachinSETTypeEntity(portst->sem_types, SType,AType){
		    addSETflag(AType.IDLclassCommon->
			       invar.IDLclassCommon->inv_flags, KGSELF);
		    if ((typeof(AType)==KAtomic) &&
			(IsTypeEntity(AType.VAtomic->rep_externalType))) {

			addSETflag(AType.VAtomic->rep_externalType.VTypeEntity.
				   IDLclassCommon->invar.
				   IDLclassCommon->inv_flags, KGSELF);
		    }
		    SetOrSeqtest(AType, KGSET, KGSEQ);
		}
		break;
	    case KMarkPort:
		foreachinSETTypeEntity(portst->sem_types, SType,AType){
		    if (ShouldMark(AType)) {
			addSETflag(AType.IDLclassCommon->
			       invar.IDLclassCommon->inv_flags, KMSELF);
			SetOrSeqtest(AType, KMSET, KMSEQ);
		    }
		    if (typeof(AType)==KAtomic) {
			if (IsTypeEntity(AType.VAtomic->invar.VAtomic->
					rep_internalType)) {

			    if (ShouldMark(AType.VAtomic->invar.VAtomic->rep_internalType.VTypeEntity))
				addSETflag(AType.VAtomic->invar.VAtomic->
				   rep_internalType.VTypeEntity.
				   IDLclassCommon->inv_flags, KMSELF);
			}
		    }
		}
		break;
	    case KUnmarkPort: 
		foreachinSETTypeEntity(portst->sem_types, SType,AType){
		    addSETflag(AType.IDLclassCommon->
			       invar.IDLclassCommon->inv_flags, KUSELF);
		    if (typeof(AType)==KAtomic) {
			if (IsTypeEntity(AType.VAtomic->invar.VAtomic->
					rep_internalType)) {

			    addSETflag(AType.VAtomic->invar.VAtomic->
				   rep_internalType.VTypeEntity.
				   IDLclassCommon->inv_flags, KUSELF);
			}
		    }
		    SetOrSeqtest(AType, KUSET, KUSEQ);
		}
		break;
	    case KPostPort: 
		foreachinSETTypeEntity(portst->sem_types, SType,AType){
		    if (ShouldMark(AType))
			addSETflag(AType.IDLclassCommon->
			       invar.IDLclassCommon->inv_flags, KMSELF);
		    addSETflag(AType.IDLclassCommon->
				   invar.IDLclassCommon->inv_flags, KWSELF);

		    if (typeof(AType)==KAtomic) {
			if (IsTypeEntity(AType.VAtomic->invar.VAtomic->
					rep_internalType)) {

			    if (ShouldMark(AType.VAtomic->invar.VAtomic->rep_internalType.VTypeEntity))
				addSETflag(AType.VAtomic->invar.VAtomic->
				   rep_internalType.VTypeEntity.
				   IDLclassCommon->inv_flags, KMSELF);
			}
		    }
		    if (typeof(AType)==KAtomic) {
			if (IsTypeEntity(AType.VAtomic->invar.VAtomic->
					rep_externalType)) {

			    addSETflag(AType.VAtomic->invar.VAtomic->
				   rep_externalType.VTypeEntity.
				   IDLclassCommon->inv_flags, KWSELF);
			}
		    }
		    if (ShouldMark(AType))
			SetOrSeqtest(AType, KMSET, KMSEQ);
		    SetOrSeqtest(AType, KWSET, KWSEQ);
		}
		break;
	    }
	}
}

/*****************/
/* for debugging */
/*****************/
void Printflags(thetypes)
SETTypeEntity thetypes;
{
    SETflag Sflag;
    flag Aflag;
    SETTypeEntity SType;
    TypeEntity AType;

    foreachinSETTypeEntity(thetypes, SType, AType){
	(void) printf("%s: ", AType.IDLclassCommon->sem_name);
	foreachinSETflag(AType.IDLclassCommon->inv_flags, Sflag, Aflag)
	    (void) printf("%d ", Aflag);
	(void) printf("\n");
    }
}


Boolean ShouldMark(atype)
TypeEntity atype;
{
    Boolean mark;
    if (typeof(atype) == KAtomic) {
	if (typeof(atype.VAtomic->inv_internal)==KAtomic)
	    mark = FALSE;
	else if (typeof(atype.VAtomic->inv_internal)==KClass)
	    mark = TRUE;
	else if (typeof(atype.VAtomic->inv_internal)==KPackage)
	    mark = FALSE;
	else if (typeof(atype.VAtomic->inv_internal)==KSetOf)
	    mark =ShouldMark(atype.VAtomic->inv_internal.VSetOf->sem_component);
	else if (typeof(atype.VAtomic->inv_internal)==KSeqOf)
	    mark =ShouldMark(atype.VAtomic->inv_internal.VSeqOf->sem_component);
	else
	    mark = TRUE;
    }
    else if (typeof(atype)==KSetOf || typeof(atype)==KSeqOf)
	mark = ShouldMark(atype.VSetOrSeq.IDLclassCommon->sem_component);
    else mark = TRUE;

    return(mark);
}
