/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/error.h 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/* macros for error handling */
#define COMMENT		-1
#define EXTENSION	-2
#define WARNING 	-3
#define RECOVERABLE 	-4
#define SERIOUS		-5
#define FATAL		-6

#define Comment0(no, spos)		ErrHandler(COMMENT, no, spos, "", "")
#define Comment1(no, spos, a1)		ErrHandler(COMMENT, no, spos, a1, "")
#define Comment2(no, spos, a1, a2)	ErrHandler(COMMENT, no, spos, a1, a2)

#define Extension0(no, spos)		ErrHandler(EXTENSION, no, spos, "", "")
#define Extension1(no, spos, a1)	ErrHandler(EXTENSION, no, spos, a1, "")
#define Extension2(no, spos, a1, a2)	ErrHandler(EXTENSION, no, spos, a1, a2)

#define Warning0(no, spos)		ErrHandler(WARNING, no, spos, "", "")
#define Warning1(no, spos, a1)		ErrHandler(WARNING, no, spos, a1, "")
#define Warning2(no, spos, a1, a2)	ErrHandler(WARNING, no, spos, a1, a2)

#define Recoverable0(no, spos)		ErrHandler(RECOVERABLE, no, spos, "", "")
#define Recoverable1(no, spos, a1)	ErrHandler(RECOVERABLE, no, spos, a1, "")
#define Recoverable2(no, spos, a1, a2)	ErrHandler(RECOVERABLE, no, spos, a1, a2)

#define Serious0(no, spos)		ErrHandler(SERIOUS, no, spos, "", "")
#define Serious1(no, spos, a1)		ErrHandler(SERIOUS, no, spos, a1, "")
#define Serious2(no, spos, a1, a2)	ErrHandler(SERIOUS, no, spos, a1, a2)

#define Fatal0(no, spos)		ErrHandler(FATAL, no, spos, "", "")
#define Fatal1(no, spos, a1)		ErrHandler(FATAL, no, spos, a1, "")
#define Fatal2(no, spos, a1, a2)	ErrHandler(FATAL, no, spos, a1, a2)
