/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/error.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: This file contains miscellaneous files for error 		*
*		handling, etc 						*
*									*
*           ErrHandler							*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: error.c,v 1.1 89/07/05 16:35:22 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	error.c,v $
 * Revision 1.1  89/07/05  16:35:22  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:18:22  cheung
 * error.c  Ver 4.0
 * 
 * Revision 3.9  89/04/07  23:20:51  cheung
 * error.c  Ver 3.9
 * 
 * Revision 3.9  89/03/30  14:09:51  cheung
 * error.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:23:40  cheung
 * error.c  Ver 3.9
 * 
 * Revision 3.2  87/11/30  14:57:58  rajan
 * *** empty log message ***
 * 
 * Revision 1.1  87/04/18  11:59:00  shannon
 * Initial revision
 * 
 * Revision 2.4  86/05/15  05:28:37  shannon
 * Version 2.4
 * 
 * Revision 2.3  86/05/05  15:17:36  shannon
 * Version 2.3 of IDL System
 * 
 * Revision 2.2  86/04/08  12:56:33  shannon
 * Version2.2
 * 
 * Revision 2.1  86/03/20  16:58:14  shannon
 * SEI Relase
 * 
 * Revision 2.0  86/01/22  07:33:15  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.1  85/06/11  10:18:21  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include <stdio.h>
#include "error.h"
extern FILE *err_out;


/***********************************************************************
 *
 * Procedure ErrHandler
 *
 * Purpose: Write an error message to err_out and handle error appropriately
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

ErrHandler(type, number, sourcepos, arg1, arg2)

int type;		/* type of error */
int number;		/* error number */
int sourcepos;		/* source position of error */
char *arg1,*arg2;	/* arguments */
{

        void exit();
        extern void ERRNewErrorInstance();
        extern void ERRAddStringArg();
        extern void ERRWriteErrorInstance();

	ERRNewErrorInstance(err_out, number, sourcepos);
	if (strcmp(arg1, "")) {
	    ERRAddStringArg(arg1);
	    if (strcmp(arg2, "")) 
		ERRAddStringArg(arg2);
	}
	ERRWriteErrorInstance();

	if (type == SERIOUS)
	    exit(1);
	else if (type == FATAL)
	    exit(1);
}
