/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/csetseq.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon and Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#include "Backend.h"
#include "macros.h"
#include <stdio.h>

AddSetSeqOperations(st, component, incfile)
StructureEntity st;
NamedType component;
FILE *incfile;
{
	SETflag flagset;	/* flag set of the nonterminal */
	String name;		/* name of the component */
	SetOf aset;
	SeqOf aseq;
	Boolean hasset = FALSE;
	Boolean hasseq = FALSE;
	static int NextTag = 0;
	Boolean DefineOperation();

	Assume((IsStructureEntity(st)&&IsNamedType(component)&&(incfile!=NULL)), 
		"AddSetSeqOperations");

	if (FindSet(st, component, &aset) ==FOUND) {
	    hasset = TRUE;
	}
	if (FindSeq(st, component, &aseq) ==FOUND) {
	    hasseq = TRUE;
	}
	if (!(hasset || hasseq))
	    return;

	name = component.IDLclassCommon->rep_name;
	flagset = component.IDLclassCommon->inv_flags;
	    
	if (inSETflag(flagset, KILSET) || inSETflag(flagset, KILSEQ)) {
	    output1(incfile, "typedef struct IDLtag%d{\n", ++NextTag);
	    output1(incfile, "        struct IDLtag%d *next;\n", 
			NextTag);
		output4(incfile, "        %s value;\n} C%s, *%s%s;\n\n",
			name, name, LLISTPREFIX, name);

	    /* check if component has size <= 32, if not can't have ops */
	    if (component.IDLclassCommon->rep_size > 32) {
		Recoverable1(374, st->lex_endpos, component.IDLclassCommon->sem_name);
		return;
	    }

	    if (inSETflag(flagset, KILSET)) {
		PrintSetListOperations(incfile, flagset, aset, component);
	    }

	    if (inSETflag(flagset, KILSEQ)) {
		PrintSeqListOperations(incfile, flagset, aseq, component);
	    }
		
	    output0(incfile, "\n");
	}
	if (inSETflag(flagset, KIASET) || inSETflag(flagset, KIASEQ)) {

	    output0(incfile, 
		    "typedef struct {\n\tint size;\n\tint length;\n");
	    output3(incfile, "\t%s *array;\n} %s%s;\n", 
		    name, ARRAYPREFIX, name);

	    /* check if component has size <= 32, if not can't have ops */
	    if (component.IDLclassCommon->rep_size > 32) {
		Recoverable1(374, st->lex_endpos, component.IDLclassCommon->sem_name);
		return;
	    }

	    if (inSETflag(flagset, KIASET)) {
	      output0(incfile, "extern GenArray IDLGenArraytemp;\n");
	      PrintSetArrayOperations(incfile, flagset, aset, component);
	    }
	    if (inSETflag(flagset, KIASEQ)) {
	      output0(incfile, "extern GenArray IDLGenArraytemp;\n");
	      PrintSeqArrayOperations(incfile, flagset, aseq, component);
	    }
	}

	if (inSETflag(flagset, KIBSET)) {
	    output1(incfile, "#define %s SETBitArray\n", aset->rep_name);
	    PrintSetBitArrayOperations(incfile, flagset, aset, component);
	}
}

PrintSetListOperations(incfile, flagset, aset, component)
FILE *incfile;
SETflag flagset;
SetOf aset;
NamedType component;
{
    String name; 

    Assume(((incfile!=NULL)&&IsNamedType(component)&&IsSetOf(aset)), 
		"PrintSetListOperations");

    name = component.IDLclassCommon->rep_name;
    if (inSETflag(flagset, KILSET)) {

        if ((typeof(component)==KClass) &&
	       (IsClassType(component.VClass)) &&
   	    (! component.VClass->rep_enumerated)) {
	      output2(incfile, "extern %s IDL%stempvalue;\n", name, name);
        }
	output3(incfile, "# define SET%s %s%s\n", name, LLISTPREFIX, name);

	if (DefineOperation(SetOfToTypeEntity(aset), "inSET")) {
	    output3(incfile, "# define inSET%s(%sset,%svalue) ",
		    name, name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile,"IDLInList((pGenList)%sset,(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue)))\n",
		      name,name,name, name);
	    }
	    else {
	      output2(incfile,"IDLInList((pGenList)%sset,(int)%svalue)\n",
			 name, name);
	    }
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "initializeSET")) {
	    output2(incfile, "# define initializeSET%s(%sset) ", 
		    name,name);
	    output2(incfile, "%sset = (SET%s)NULL\n", name, name);
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "addSET")) {
	    output3(incfile, "# define addSET%s(%sset,%svalue) {if \\\n",
		    name, name, name);
	    output1(incfile, "\t\t(!IDLInList((pGenList)%sset,",
		    name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output3(incfile, "(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue))))\\\n", name, name, name);
	    }
	    else {
	      output1(incfile, "(int)%svalue))\\\n", name);
	    }
	    output2(incfile, "\t\t%sset=(SET%s)IDLListAddFront",
		    name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output2(incfile, "((pGenList)%sset,(*(int *)(&IDL%stempvalue)));}\n",
		      name, name);
	    }
	    else {
	      output2(incfile, "((pGenList)%sset,(int)%svalue);}\n",
			 name, name);
	    }
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "removeSET")) {
	    output3(incfile, "# define removeSET%s(%sset,%svalue) ",
		    name, name, name);
	    output1(incfile, "%sset=\\\n", name);
	    output1(incfile, "\t\t(SET%s)IDLListRemoveCell((pGenList)",	name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile, "%sset,(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue)))\n", name, name, name, name);
	    }
	    else {
	      output2(incfile, "%sset,(int)%svalue)\n", name, name);
	    }
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "foreachinSET")) {
	    output3(incfile, "# define foreachinSET%s(%sset,%sptr,",
		name, name, name);
	    output1(incfile, "%svalue) for \\\n", name);
	    output2(incfile, "\t\t(%sptr = %sset; \\\n", name, name);

	    if (typeof(component)==KClass &&
		IsClassType(component.VClass)) {
		output3(incfile,"\t\t%sptr!=(SET%s)NULL&&((%svalue.IDLinternal",
			name, name, name);
		output1(incfile, "=%sptr->value.IDLinternal,",
			name);
	    }
	    else {
		output3(incfile, " \t\t%sptr!=(SET%s)NULL&&((%svalue=",
			name, name, name);
		output1(incfile, "%sptr->value,", name);
	    }

	    output2(incfile, "%sptr=%sptr->next)||1);)\n", name, name);
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "copySET")) {
	    output2(incfile, "# define copySET%s(%sset) ",name, name);
	    output2(incfile, "(SET%s)IDLListCopy((pGenList)%sset)\n", name, name);
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "equalSET")) {
	    output1(incfile, "# define equalSET%s(set1, set2) ",name);
	    output0(incfile, "IDLListsEqual((pGenList)set1, (pGenList)set2)\n");
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "emptySET")) {
	    output2(incfile, "# define emptySET%s(%sset) ",name, name);
	    output2(incfile, "((%sset)==(SET%s)NULL)\n", name, name);
	    output0(incfile, "\n\n");
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "sizeSET")) {
	    output2(incfile, "# define sizeSET%s(%sset) ",name, name);
	    output1(incfile, "IDLListLength((pGenList)%sset)\n", name);
	    output0(incfile, "\n\n");
	}
    }
}



PrintSeqListOperations(incfile, flagset, aseq, component)
FILE *incfile;
SETflag flagset;
SeqOf aseq;
NamedType component;
{
    String name;

    Assume(((incfile!=NULL)&&IsNamedType(component)&&IsSeqOf(aseq)), 
		"PrintSeqListOperations");

    name = component.IDLclassCommon->rep_name;
    if (inSETflag(flagset, KILSEQ)) {

        if ((typeof(component)==KClass) &&
	       (IsClassType(component.VClass)) &&
   	    (! component.VClass->rep_enumerated)) {
	      output2(incfile, "extern %s IDL%stempvalue;\n", name, name);
        }
	output3(incfile, "# define SEQ%s %s%s\n", name, LLISTPREFIX, name);

	if (DefineOperation(SeqOfToTypeEntity(aseq), "inSEQ")) {
	    output3(incfile, "# define inSEQ%s(%sseq,%svalue) ",
		    name, name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile,"IDLInList((pGenList)%sseq,(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue)))\n",
		      name, name, name, name);
	    }
	    else {
	      output2(incfile,"IDLInList((pGenList)%sseq,(int)%svalue)\n",
			 name, name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "initializeSEQ")) {
	    output2(incfile, "# define initializeSEQ%s(%sseq) ", 
		    name,name);
	    output2(incfile, "%sseq = (SEQ%s)NULL\n", name, name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "appendfrontSEQ")) {
	    output2(incfile, "# define appendfrontSEQ%s(%sseq,",
		    name, name);
	    output2(incfile, "%svalue) %sseq=\\\n", name, name);
	    output1(incfile, "\t\t(SEQ%s)IDLListAddFront((pGenList)",
		     name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile, "%sseq,(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue)))\n", name, name, name, name);
	    }
	    else {
	      output2(incfile, "%sseq,(int)%svalue)\n", name, name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "appendrearSEQ")) {
	    output3(incfile, "# define appendrearSEQ%s(%sseq,%svalue) ",
		    name, name, name);
	    output1(incfile, "%sseq=\\\n", name);
	    output1(incfile, "\t\t(SEQ%s)IDLListAddRear((pGenList)",
		    name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile, "%sseq,(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue)))\n", name, name, name, name);
	    }
	    else {
	      output2(incfile, "%sseq,(int)%svalue)\n", name, name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "modifyithinSEQ")) {
	    output4(incfile, "# define modifyithinSEQ%s(%sseq,%sindex,%svalue)\\",
		    name, name, name, name);
	    output2(incfile, "\n\t\tIDLListModifyIth((pGenList)%sseq,%sindex,",
		    name,name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output3(incfile, "(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue)))\n", name, name, name);
	    }
	    else {
	      output1(incfile, "(int)%svalue)\n", name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "orderedinsertSEQ")) {
	    output2(incfile, "# define orderedinsertSEQ%s(%sseq,",
		    name, name);
	    output3(incfile, "%svalue,%scompfn) %sseq=\\\n", 
		    name, name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output1(incfile, "\t\t(SEQ%s)IDLListOrderedInsertUnion((", name);
	      output4(incfile, "pGenList)%sseq,(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue))",
		      name, name, name, name);
	      output1(incfile,",%scompfn)\n",name);
	    }
	    else {
	      output1(incfile, "\t\t(SEQ%s)IDLListOrderedInsert((", name);
	      output3(incfile, "pGenList)%sseq,(int)%svalue,%scompfn)\n",
			 name, name, name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "retrievefirstSEQ")) {
	    output1(incfile, "# define retrievefirstSEQ%s", name);
	    output2(incfile, "(%sseq, %svalue)\\\n ",
		    name, name);
	    if (typeof(component)==KClass &&
		IsClassType(component.VClass)) {
		output1(incfile, "\t\t%svalue.IDLclassCommon = ",
		    name);
		if (emptySEQAttribute(component.VClass->sem_allattributes)){
		    output0(incfile, 
			 "(HgenericHeader)IDLListRetrieveFirst((");
		}
		else output1(incfile, "(CP%s)IDLListRetrieveFirst((",
		    name);
	    }
	    else output2(incfile, "\t\t%svalue = (%s)IDLListRetrieveFirst((",
		    name,name);
	    output1(incfile, "pGenList)%sseq)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "retrievelastSEQ")) {
	    output1(incfile, "# define retrievelastSEQ%s", name);
	    output2(incfile, "(%sseq, %svalue)\\\n ",
		    name, name);
	    if (typeof(component)==KClass &&
		IsClassType(component.VClass)) {
		output1(incfile, "\t\t%svalue.IDLclassCommon = ",
		    name);
		if (emptySEQAttribute(component.VClass->sem_allattributes)){
		    output0(incfile, 
			 "(HgenericHeader)IDLListRetrieveLast((");
		}
		else output1(incfile, "(CP%s)IDLListRetrieveLast((",
		    name);
	    }
	    else output2(incfile, "\t\t%svalue = (%s)IDLListRetrieveLast((",
		    name, name);
	    output1(incfile, "pGenList)%sseq)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "ithinSEQ")) {
	    output1(incfile, "# define ithinSEQ%s", name);
	    output2(incfile, "(%sseq, index, %svalue)\\\n", name, name);
	    if (typeof(component) == KClass &&
		 IsClassType(component.VClass)) {
		output1(incfile, "\t\t%svalue.IDLclassCommon = ",
		    name);
		if (emptySEQAttribute(component.VClass->sem_allattributes)){
		    output0(incfile, 
			 "(HgenericHeader)IDLListRetrieveIth((");
		}
		else output1(incfile, "(CP%s)IDLListRetrieveIth((",
		    name);
	    }
	    else output2(incfile, "\t\t%svalue = (%s)IDLListRetrieveIth((",
		name, name);
	    output1(incfile, "pGenList)%sseq, index)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "tailSEQ")) {
	    output1(incfile, "# define tailSEQ%s", name);
	    output1(incfile, "(%sseq)\\\n", name);
	    output3(incfile, "\t\t((%sseq)!=(SEQ%s)NULL ? %sseq->next :",
		name, name, name);
	    output1(incfile, " (SEQ%s)NULL)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "removefirstSEQ")) {
	    output3(incfile, "# define removefirstSEQ%s(%sseq) %sseq=\\\n",
		    name, name, name);
	    output1(incfile, "\t\t(SEQ%s)IDLListRemoveFirstCell((",
		    name);
	    output1(incfile, "pGenList)%sseq)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "removeSEQ")) {
	    output3(incfile, "# define removeSEQ%s(%sseq,%svalue) ",
		    name, name, name);
	    output1(incfile, "%sseq=\\\n", name);
	    output1(incfile, "\t\t(SEQ%s)IDLListRemoveCell((",
		    name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile, "pGenList)%sseq,(*(int *)(IDL%stempvalue=(%svalue),&IDL%stempvalue)))\n",
		      name, name, name, name);
	    }
	    else {
	      output2(incfile, "pGenList)%sseq,(int)%svalue)\n",
			 name, name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "removeithinSEQ")) {
	    output3(incfile, "# define removeithinSEQ%s(%sseq,%sindex) ",
		    name, name, name);
	    output1(incfile, "%sseq=\\\n", name);
	    output3(incfile, "\t\t(SEQ%s)IDLListRemoveIthCell((pGenList)%sseq,%sindex)\n",
		    name, name, name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "removelastSEQ")) {
	    output3(incfile,"# define removelastSEQ%s(%sseq) %sseq=\\\n",
		    name, name, name);
	    output1(incfile, "\t\t(SEQ%s)IDLListRemoveLastCell((",
		    name);
	    output1(incfile, "pGenList)%sseq)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "foreachinSEQ")) {
	    output3(incfile, "# define foreachinSEQ%s(%sseq,%sptr,",
		    name, name, name);
	    output1(incfile, "%svalue) for\\\n", name);
	    output2(incfile, "(%sptr = %sseq; \\\n", name, name);
	    if (typeof(component)==KClass &&
		IsClassType(component.VClass)) {
		output3(incfile,"\t\t%sptr!=(SEQ%s)NULL&&((%svalue.IDLinternal",
			name, name, name);
		output1(incfile, "=%sptr->value.IDLinternal,",
			name);
	    }
	    else {
		output3(incfile, " \t\t%sptr!=(SEQ%s)NULL&&((%svalue=",
			name, name, name);
		output1(incfile, "%sptr->value,", name);
	    }
	    output2(incfile, "%sptr=%sptr->next)||1);)\n", name, name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "emptySEQ")) {
	    output2(incfile, "# define emptySEQ%s(%sseq) ", name, name);
	    output2(incfile, "((%sseq)==(SEQ%s)NULL)\n", name, name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "lengthSEQ")) {
	    output2(incfile, "# define lengthSEQ%s(%sseq) ",name, name);
	    output1(incfile, "IDLListLength((pGenList)%sseq)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "copySEQ")) {
	    output2(incfile, "# define copySEQ%s(%sseq) ",name, name);
	    output2(incfile, "(SEQ%s)IDLListCopy((pGenList)%sseq)\n", name, name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "equalSEQ")) {
	    output1(incfile, "# define equalSEQ%s(seq1, seq2) ",name);
	    output0(incfile, "IDLListsEqual((pGenList)seq1, (pGenList)seq2)\n");
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "sortSEQ")) {
	    output2(incfile, "# define sortSEQ%s(%sseq, compfn) ",
					name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output3(incfile, "%sseq = (SEQ%s)IDLListSortUnion((pGenList)%sseq, compfn)\n", 
					name, name, name);	    
	    }
	    else
	      output3(incfile, "%sseq = (SEQ%s)IDLListSort((pGenList)%sseq, compfn)\n", 
					name, name, name);
	}
    }
}


PrintSetArrayOperations(incfile, flagset, aset, component)
FILE *incfile;
SETflag flagset;
SetOf aset;
NamedType component;
{
    SetSeqSize numelems;
    String name;
    Assume((IsSetOf(aset)&&IsNamedType(component)),
		"PrintSetArrayOperations");

    name = component.IDLclassCommon->rep_name;
    
    if (inSETflag(flagset, KIASET)) {
	numelems = aset->rep_numelements;

        if ((typeof(component)==KClass) &&
	       (IsClassType(component.VClass)) &&
   	    (! component.VClass->rep_enumerated)) {
	      output2(incfile, "extern %s IDL%stempvalue;\n", name, name);
        }
	output3(incfile, "# define SET%s %s%s\n", name, ARRAYPREFIX, name);
	if (typeof(numelems)==KintegerToken) {
	    output2(incfile, "# define MAXSIZESET%s %d\n", 
		    name, atoi(numelems.VintegerToken->lex_externalform));
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "inSET")) {
	    output3(incfile, "# define inSET%s(%sarray, a%s) ", 
		name,name,name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile, "IDLInArray(%sarray, (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)))\n", 
		      name,name, name, name);
	    }
	    else {
	      output2(incfile, "IDLInArray(%sarray, a%s)\n", 
			 name,name);
	    }
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "initializeSET")) {
	    output2(incfile, "# define initializeSET%s(%sarray) ",
			name, name);
	    if (typeof(numelems) == Kanynumber) {
		output1(incfile, "IDLInitializeArray(*(GenArray *)&(%sarray),0)\n", name);
	    }
	    else {
		output2(incfile, "IDLInitializeArray(*(GenArray *)&(%sarray),MAXSIZESET%s)\n", 
			name, name);
	    }
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "addSET")) {
	    output3(incfile, "# define addSET%s(%sarray, a%s)",
			name, name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output3(incfile, "{if (!inSET%s(%sarray, a%s))",
		      name, name, name);
	    }
	    else {
	      output3(incfile, "{if (!inSET%s(%sarray, a%s)) ",
			 name, name, name);
	    }
	    if (typeof(numelems) == Kanynumber) {
	      if ((typeof(component)==KClass) &&
		  (IsClassType(component.VClass)) &&
		  (! component.VClass->rep_enumerated)) {
		output2(incfile, "IDLArrayAddRear(&(%sarray), (*(int *)(&(IDL%stempvalue))));",
			name, name);
	      }
	      else {
		output2(incfile, "IDLArrayAddRear(&(%sarray), a%s);",
			   name, name);
	      }
	    }
	    else {
		output2(incfile,"if (IDLLengthArray(%sarray)<MAXSIZESET%s)\\\n",
			name, name);
		if ((typeof(component)==KClass) &&
		    (IsClassType(component.VClass)) &&
		    (! component.VClass->rep_enumerated)) {
		  output2(incfile, "IDLArrayAddRear(&(%sarray), (*(int *)(&(IDL%stempvalue))));",
			  name, name);
		}
		else {
		  output2(incfile, "IDLArrayAddRear(&(%sarray), a%s);",
			     name, name);
		}
	    }
	    output0(incfile, "}\n");
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "removeSET")) {
	    output3(incfile, "# define removeSET%s(%sarray, a%s) ",
		    name, name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile, "IDLArrayRemoveElem(&(%sarray), (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)))\n",
		      name, name, name, name);
	    }
	    else {
	      output2(incfile, "IDLArrayRemoveElem(&(%sarray), a%s)\n",
			 name, name);
	    }
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "emptySET")) {
	    output2(incfile, "# define emptySET%s(%sarray) ",
		name, name);
	    output1(incfile, "IDLEmptyArray(%sarray)\n", name);
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "copySET")) {
	    output2(incfile, "# define copySET%s(%sarraya) ",
		    StringToChar(name), StringToChar(name)); 
	    output2(incfile, "*(SET%s *) (IDLGenArraytemp = IDLArrayCopy(%sarraya), &IDLGenArraytemp)\n",
		    StringToChar(name), StringToChar(name));
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "sizeSET")) {
	    output2(incfile, "# define sizeSET%s(%sarray) ",
		name, name);
	    output1(incfile, "IDLLengthArray(%sarray)\n", name);
	}
	if (DefineOperation(SetOfToTypeEntity(aset), "foreachinSET")) {
	    output2(incfile, "# define foreachinSET%s(%sarray, ",
		name, name);
	    output3(incfile, "S%s, A%s) foreachinArray(%sarray, ",
		name, name, name);
	    output2(incfile, "S%s, A%s)\n", name, name);
	}
    }
}

PrintSeqArrayOperations(incfile, flagset, aseq, component)
FILE *incfile;
SETflag flagset;
SeqOf aseq;
NamedType component;
{
    String name;
    SetSeqSize numelems;

    name = component.IDLclassCommon->rep_name;
    if (inSETflag(flagset, KIASEQ)) {
	numelems = aseq->rep_numelements;

        if ((typeof(component)==KClass) &&
	       (IsClassType(component.VClass)) &&
   	    (! component.VClass->rep_enumerated)) {
	      output2(incfile, "extern %s IDL%stempvalue;\n", name, name);
        }
	output3(incfile, "# define SEQ%s %s%s\n", name, ARRAYPREFIX, name);

	if (typeof(numelems)==KintegerToken) {
	    output2(incfile, "# define MAXSIZESEQ%s %d\n",
			name, atoi(numelems.VintegerToken->lex_externalform));
	}
	
	if (DefineOperation(SeqOfToTypeEntity(aseq), "inSEQ")) {
	    output3(incfile, "# define inSEQ%s(%sarray, a%s) ",
		name, name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile, "IDLInArray(%sarray, (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)))\n", 
		     name, name, name, name);
	    }
	    else {
	      output2(incfile, "IDLInArray(%sarray, (int)a%s)\n", 
			 name, name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "initializeSEQ")) {
	    output2(incfile, "# define initializeSEQ%s(%sarray) ",
		name, name);
	    if (typeof(numelems)==Kanynumber) {
		output1(incfile, "IDLInitializeArray(*(GenArray *)&(%sarray),0)\n", name);
	    }
	    else {
		output2(incfile, "IDLInitializeArray(*(GenArray *)&(%sarray),MAXSIZESEQ%s)\n",
			 name, name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "appendfrontSEQ")) {
	    output3(incfile, "# define appendfrontSEQ%s(%sarray, a%s) ",
		name, name, name);
	    if (typeof(numelems) == KintegerToken) {
		output1(incfile, "{if (IDLLengthArray(%sarray) <", name);
		output1(incfile, "MAXSIZESEQ%s)\\\n ", name);
		if ((typeof(component)==KClass) &&
		    (IsClassType(component.VClass)) &&
		    (! component.VClass->rep_enumerated)) {
		  output4(incfile, "\tIDLArrayAddFront((GenArray *)&(%sarray), (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)));}\n",
			  name, name, name, name);
		}
		else {
		  output2(incfile, "\tIDLArrayAddFront((GenArray *)&(%sarray), a%s);}\n",
			     name, name);
		}
	    }
	    else {
	      if ((typeof(component)==KClass) &&
		  (IsClassType(component.VClass)) &&
		  (! component.VClass->rep_enumerated)) {
		output4(incfile, "IDLArrayAddFront((GenArray *)&(%sarray), (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)))\n",
			name, name, name, name);
	      }
	      else {
		output2(incfile, "IDLArrayAddFront((GenArray *)&(%sarray), a%s)\n",
			   name, name);
	      }
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "appendrearSEQ")) {
	    output3(incfile, "# define appendrearSEQ%s(%sarray, a%s) ",
		name, name, name);
	    if (typeof(numelems) == KintegerToken) {
		output1(incfile, "{if (IDLLengthArray(%sarray) <", name);
		output1(incfile, "MAXSIZESEQ%s)\\\n ", name);
		if ((typeof(component)==KClass) &&
		    (IsClassType(component.VClass)) &&
		    (! component.VClass->rep_enumerated)) {
		  output4(incfile, "\tIDLArrayAddRear((GenArray *)&(%sarray), (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)));}\n",
			  name, name, name, name);
		}
		else {
		  output2(incfile, "\tIDLArrayAddRear((GenArray *)&(%sarray), (int)a%s);}\n",
			     name, name);
		}
	    }
	    else {
	      if ((typeof(component)==KClass) &&
		  (IsClassType(component.VClass)) &&
		  (! component.VClass->rep_enumerated)) {
		output4(incfile, "IDLArrayAddRear((GenArray *)&(%sarray), (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)))\n",
			name, name, name, name);
	      }
	      else {
		output2(incfile, "IDLArrayAddRear((GenArray *)&(%sarray), (int)a%s)\n",
			   name, name);
	      }
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "modifyithinSEQ")) {
	  output3(incfile, "# define modifyithinSEQ%s(%sarray, index, a%s) \\\n",
		 name, name, name);
	  output1(incfile, "if(index >= 1 && index <= %sarray.length) ", name);
	  output2(incfile, "%sarray.array[index-1] = a%s;\n",
		  name, name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "orderedinsertSEQ")) {
	    output3(incfile, "# define orderedinsertSEQ%s(%sarray, a%s, ",
		name, name, name);
	    output0(incfile, "cmpfn) ");
	    if (typeof(numelems) == KintegerToken) {
		output1(incfile, "{if (IDLLengthArray(%sarray) >=", name);
		output1(incfile, "MAXSIZESEQ%s) \\\n", name);
		output1(incfile, "\tIDLArrayRemoveLast(%sarray); ",
			name);
		if ((typeof(component)==KClass) &&
		    (IsClassType(component.VClass)) &&
		    (! component.VClass->rep_enumerated)) {
		  output4(incfile, "IDLArrayOrderedInsert((GenArray *)&(%sarray), (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)), ",
			  name, name, name, name);
		}
		else {
		  output2(incfile, "IDLArrayOrderedInsert((GenArray *)&(%sarray), (int)a%s, ",
			     name, name);
		}
		output0(incfile, "cmpfn);}\n");
	    }
	    else {
	      if ((typeof(component)==KClass) &&
		  (IsClassType(component.VClass)) &&
		  (! component.VClass->rep_enumerated)) {
		output4(incfile, "IDLArrayOrderedInsertUnion((GenArray *)&(%sarray), (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)),",
			name, name, name, name);
	      }
	      else {
		output2(incfile, "IDLArrayOrderedInsert((GenArray *)&(%sarray), (int)a%s,",
			   name, name);
	      }
	      output0(incfile, "cmpfn)\n");
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "retrievefirstSEQ")) {
	    output3(incfile, "# define retrievefirstSEQ%s(%sarray, a%s) ",
		name, name, name);
	    output1(incfile, "\ta%s = ", name);
	    output1(incfile, "IDLArrayRetrieveFirst(%sarray)\n",
		name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "retrievelastSEQ")) {
	    output3(incfile, "# define retrievelastSEQ%s(%sarray, a%s) ",
		name, name, name);
	    output1(incfile, "\t\ta%s = ", name);
	    output1(incfile, "IDLArrayRetrieveLast(%sarray)\n",
		name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "ithinSEQ")) {
	    output3(incfile, "# define ithinSEQ%s(%sarray,index,a%s) ",
		name, name, name);
	    output1(incfile, "\ta%s = ", name);
	    output1(incfile, "IthInArray(%sarray, index)\n", 
		name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "removefirstSEQ")) {
	    output2(incfile, "# define removefirstSEQ%s(%sarray) ",
		name, name);
	    output1(incfile, "IDLArrayRemoveFirstElem((GenArray *)&(%sarray))\n",
		name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "removeithinSEQ")) {
	    output2(incfile, "# define removeithinSEQ%s(%sarray, index) ",
		name, name);
	    output1(incfile, "IDLArrayRemoveIthElem((GenArray *)&(%sarray), index)\n",
		name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "removeSEQ")) {
	    output3(incfile, "# define removeSEQ%s(%sarray, a%s) ",
		name, name, name);
	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)) {
	      output4(incfile, "IDLArrayRemoveElem((GenArray *)&(%sarray), (*(int *)(IDL%stempvalue=(a%s),&IDL%stempvalue)))\n",
		      name, name, name, name);
	    }
	    else {
	      output2(incfile, "IDLArrayRemoveElem((GenArray *)&(%sarray), (int)a%s)\n",
			 name, name);
	    }
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "removelastSEQ")) {
	    output2(incfile, "# define removelastSEQ%s(%sarray) ",
		name, name);
	    output1(incfile, "IDLArrayRemoveLast(%sarray)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "emptySEQ")) {
	    output2(incfile, "# define emptySEQ%s(%sarray) ",
		name, name);
	    output1(incfile, "IDLEmptyArray(%sarray)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "lengthSEQ")) {
	    output2(incfile, "# define lengthSEQ%s(%sarray) ",
		name, name);
	    output1(incfile, "IDLLengthArray(%sarray)\n", name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "copySEQ")) {
	    output2(incfile, "# define copySEQ%s(%sarray) ",
		name, name);
	    output2(incfile, "*(SEQ%s *)(IDLGenArraytemp = IDLArrayCopy(%sarray),&IDLGenArraytemp)\n", 
		name, name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "tailSEQ")) {
	    output2(incfile, "# define tailSEQ%s(%sarray) ",
		name, name);
	    output2(incfile, "*(SEQ%s *)(IDLGenArraytemp = IDLArrayTail(%sarray),&IDLGenArraytemp)\n", 
		name, name);
	}
	if (DefineOperation(SeqOfToTypeEntity(aseq), "sortSEQ")) {
	    output2(incfile, "# define sortSEQ%s(%sarray, cmpfn) ",
		name, name);
   	    if ((typeof(component)==KClass) &&
		(IsClassType(component.VClass)) &&
		(! component.VClass->rep_enumerated)){
	      output3(incfile, "%sarray = *(SEQ%s *)(IDLGenArraytemp = IDLArraySortUnion(%sarray, cmpfn),&IDLGenArraytemp)\n",
		name, name, name);
	    }
	    else {	      
	      output3(incfile, "%sarray = *(SEQ%s *)(IDLGenArraytemp = IDLArraySort(%sarray, cmpfn),&IDLGenArraytemp)\n", 
		name, name, name);
	    }
	  }
	if (DefineOperation(SeqOfToTypeEntity(aseq), "foreachinSEQ")) {
	    output2(incfile, "# define foreachinSEQ%s(%sarray, ",
		name, name);
	    output3(incfile, "S%s, A%s) foreachinArray(%sarray, ",
		name, name, name);
	    output2(incfile, "S%s, A%s)\n", name, name);
	}
    }
}

PrintSetBitArrayOperations(incfile, flagset, aset, component)
FILE *incfile;
SETflag flagset;
SetOf aset;
NamedType component;
{
	String name;

	Assume((IsSetOf(aset)&&IsNamedType(component)),
		"PrintSetBitArrayOperations");

	name = component.IDLclassCommon->rep_name;
	if (inSETflag(flagset, KIBSET)) {
	    output2(incfile, "#define MAXSIZESET%s %d\n",
			name, aset->rep_size);
	    if (DefineOperation(SetOfToTypeEntity(aset), "inSET")) {
		output1(incfile, "#define inSET%s(s,v) inSETBitArray(s,v)\n",
			name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "initializeSET")) {
		output1(incfile, "#define initializeSET%s(s) initializeSETBitArray(s)\n",
			name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "addSET")) {
		output1(incfile, "#define addSET%s(s,v) addSETBitArray(s,v)\n",
			name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "removeSET")) {
		output1(incfile, "#define removeSET%s(s,v) removeSETBitArray(s,v)\n",
			name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "emptySET")) {
		output1(incfile, "#define emptySET%s(s) emptySETBitArray(s)\n",
			name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "copySET")) {
		output1(incfile, "#define copySET%s(s) copySETBitArray(s)\n",
			StringToChar(name));
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "sizeSET")) {
		output1(incfile, "#define sizeSET%s(s) sizeSETBitArray(s)\n",
			name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "foreachinSET")) {
		output1(incfile, "#define foreachinSET%s(s, t, v) ",
			name);
		output1(incfile, "foreachinSETBitArray(s, t, v, MAXSIZESET%s)\n",
			name);
	    }
	}
}

AddSetSeqDeclarations(st, component, cfile)
     StructureEntity st;
     NamedType component;
     FILE *cfile;
{
     SETflag flagset;        /* flag set of the nonterminal */
     String name;            /* name of the component */
     SetOf aset;
     SeqOf aseq;
     Boolean hasset = FALSE;
     Boolean hasseq = FALSE;
     Boolean DefineOperation();

     Assume((IsStructureEntity(st)&&IsNamedType(component)&&(cfile!=NULL)), 
	    "AddSetSeqOperations");

     if (FindSet(st, component, &aset) ==FOUND) {
       hasset = TRUE;
     }
     if (FindSeq(st, component, &aseq) ==FOUND) {
       hasseq = TRUE;
     }
     if (!(hasset || hasseq))
       return;

     name = component.IDLclassCommon->rep_name;
     flagset = component.IDLclassCommon->inv_flags;

     if (inSETflag(flagset, KIASET) || inSETflag(flagset, KIASEQ)) {
       output0(cfile, "GenArray IDLGenArraytemp;\n");
     }
     
     if (inSETflag(flagset, KILSET) || inSETflag(flagset, KILSEQ) ||
	 inSETflag(flagset, KIASET) || inSETflag(flagset, KIASEQ)) { 
       if ((typeof(component)==KClass) &&
	   (IsClassType(component.VClass)) &&
	   (! component.VClass->rep_enumerated)) {
	 output2(cfile, "%s IDL%stempvalue;\n", name, name);
       }
     }
}
      
