/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/class.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon and Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Routines concerned with classes of the structure		*
*									*
*	     IsDescendantClass PropogateDescendantsUp 			*
*	     PropogateDescendants  IsDescendant  			*
*	     SetEmptyClasses GetAllClasses				*
*									*
\* ******************************************************************* */

#ifndef lint
   static char rcsid[] = "$Header: /r/zep/usr/rts/p/personal/hkaram/tech/src/idlc/backend/RCS/class.c,v 4.2 90/08/20 16:09:32 hkaram Release42 Locker: hkaram $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	class.c,v $
 * Revision 4.2  90/08/20  16:09:32  hkaram
 * @
 * 
 * Revision 1.1  89/07/05  16:35:16  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:18:01  cheung
 * class.c  Ver 4.0
 * 
 * Revision 3.9  89/04/07  23:20:29  cheung
 * class.c  Ver 3.9
 * 
 * Revision 3.9  89/03/30  14:09:32  cheung
 * class.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:23:19  cheung
 * class.c  Ver 3.9
 * 
 * Revision 3.2  87/11/30  14:57:49  rajan
 * *** empty log message ***
 * 
 * Revision 1.1  87/04/18  11:59:08  shannon
 * Initial revision
 * 
 * Revision 1.1  86/06/06  14:55:37  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:20:51  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.6  86/01/22  07:08:15  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.5  85/07/25  12:37:05  shannon
 * changed message for invalid class hierarchy
 * 
 * Revision 1.4  85/07/25  10:32:24  shannon
 * checks for cycles and sharing in class hierarchy
 * changed code for new null and empty class rep
 * 
 * Revision 1.3  85/07/18  19:43:02  shannon
 * deleted unused variables
 * 
 * Revision 1.2  85/07/04  14:54:52  shannon
  changed set of symbols to sequence
 * 
 * Revision 1.1  85/06/11  10:15:22  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */
 
#include "Backend.h"
#include "macros.h"
#include <stdio.h>

/***********************************************************************
 *
 * Function IsDescendantClass
 *
 * Purpose: check if c2 is a descendant of cl
 *
 * Return Value: TRUE if c2 is a descendant of c1 else FALSE
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
Boolean IsDescendantClass(c1, c2)
Class c1, c2;
{
	Assume((IsClass(c1)&&IsClass(c2)), "IsDescendantClass");

	return(inSETClass(c1->inv_alldescendants, c2));
}

	

/***********************************************************************
 *
 * Procedure PropogateDescendantsUp
 *
 * Purpose: For each class in 'st' propogate up descendants to ancestor
 *	    classes.
 *
 * Algorithm: For each class in 'st', call PropogateDescendants
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: no cycles in class hierarchy
 *
 **********************************************************************/

PropogateDescendantsUp(st)
StructureEntity st;
{

	SETTypeEntity SType;
	TypeEntity AType;

	Assume((IsStructureEntity(st)), "PropogateDescendantsUp");

	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if (typeof(AType) == KClass)
		PropogateDescendants(AType.VClass);
	}
}



/***********************************************************************
 *
 * Procedure PropogateDescendants
 *
 * Purpose: Propogate up the descendants of the descendants of 'c' into 'c'
 *
 * Algorithm: Apply the procedure to the descendants of 'c' before applying
 *	      to 'c'.
 *	      Add descendants to ancestor class 'alldescendants'. Add
 *	      ancestor class to descendant 'allancestors'
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

PropogateDescendants(c)
Class c;		/* the ancestor class */
{

	SEQClass SClass;
	Class AClass;
	SEQClass SClass2;
	Class AClass2;
	
	Assume((IsClass(c)), "PropogateDescendants");

	foreachinSETClass(c->sem_subclasses, SClass, AClass) {
	    PropogateDescendants(AClass);
	    foreachinSETClass(AClass->inv_alldescendants, SClass2, AClass2) {
		addSETClass(c->inv_alldescendants, AClass2);
	    }
	    addSETClass(c->inv_alldescendants, AClass);
	}
}


/***********************************************************************
 *
 * Function GetAllClasses
 *
 * Purpose: Get the set of classes in a structure
 *
 * Return Value: the set of classes
 *
 * Algorithm: Search for the classes in the types set 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
 SETClass GetAllClasses(st)
 StructureEntity st;
 {
     SETClass allclasses;	/* the classes */
     SETTypeEntity SType;	/* set traversal and value */
     TypeEntity AType;

     initializeSETClass(allclasses);
     foreachinSETTypeEntity(st->sem_types, SType, AType) {
	 if (typeof(AType) == KClass)
	     addSETClass(allclasses, AType.VClass);
     }
     return(allclasses);
}



/***********************************************************************
 *
 * Function IsSubclass
 *
 * Purpose: Check if class2 is a direct or indirect subclass of class1
 *
 * Return Value: TRUE if class2 is a subclass else FALSE
 *
 * Algorithm: See if class2 can be reached through class1 subclasses
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
Boolean IsSubclass(class1, class2)
Class class1, class2;
{
	SETClass SClass;	/* set traversal and values */
	Class AClass;
	Boolean found = FALSE;	/* indicator if class2 is found as a subclass */

	Assume((IsClass(class1)&&IsClass(class2)), "IsSubclass");

	if (inSETClass(class1->sem_subclasses, class2))
	    found = TRUE;
	else foreachinSETClass(class1->sem_subclasses, SClass, AClass) {
	    found = IsSubclass(AClass, class2);
	    if (found) 
		break;
	}
	return(found);
}

