/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlbrowse/windows.h 
*				 					* 
*   Copyright (C) 1991 Marco Chierotti
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 


/*
 *
 *  Description: module to  get the commands from the keyboard and displays
 *               the corresponding output to the multiple window screen
 *               It is used by the Command Module.
 *
 */

/**************************************************************************/
/*
 * enumerated type for commands
 */
typedef int command_type;
/*
 * values assumed by the above type
 */
#define  UP        1
#define  DOWN      2
#define  SCR_UP    3
#define  SCR_DOWN  4
#define  RIGHT     5
#define  LEFT      6
#define  HELP      8
#define  C_FILE    9
#define  F_NAME   10
#define  SETUP    11
#define  ESCAPE   12
#define  VERBOSE  14
#define  NOTKNOWN  15
#define  QUIT     16
/*
 * enumerated type to recognize windows
 */
typedef int w_number_type;
/*
 * values assumed by the above type
 */
#define LEFT_W   0
#define CENTER_W 1
#define RIGHT_W  2
#define BOTTOM_W 3
#define WRONG_W  -1
/*
 * functions exported
 */


/*
 *  Routine: init_w_system
 *
 *  Description: it sets curses routines to set its operation mode
 *
 *  Arguments: none
 *
 *  Return Value: none
 *
 *  Side Effects: none
 *
 */
void init_w_system();

/*
 *  Routine: init_browse
 *
 *  Description: it sets the virtual screen and its windows along
 *               with the curse screen and its subwindows. It sets
 *               the current window to the left window.
 *
 *  Arguments: none
 *
 *  Return Value:  FALSE if the terminal has an insufficient number of
 *                 rows or columns, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean init_browse();

/*
 *  Routine: get_command()
 *
 *  Description: it gets a command from the keyboard and interprets
 *               it to give an abstract command_type result
 *
 *  Arguments: none
 *
 *  Return Value: code for the command
 *
 *  Side Effects: none
 *
 */
command_type get_command();


/*
 *  Routine: select_prev_item
 *
 *  Description: it selects the previous item in the list of current
 *               window, drawing it in reverse. Current item is
 *               disselected
 *
 *  Arguments: none
 *
 *  Return Value: TRUE if movement was possible, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean select_prev_item();


/*
 *  Routine: select_next_item
 *
 *  Description: it selects the next item in the list of current
 *               window, drawing it in reverse. Current item is
 *               disselected
 *
 *  Arguments: none
 *
 *  Return Value: TRUE if movement was possible, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean select_next_item();


/*
 *  Routine: select_top_element
 *
 *  Description: it selects the top item in the list of given 
 *               window, drawing it in reverse. Current item is
 *               disselected
 *
 *  Arguments:  window -- (IN) window to consider
 *
 *  Return Value: TRUE if window empty or wrong window, otherwise FALSE
 *
 *  Side Effects: it changes the top_row and curr_row for the given window
 */
boolean select_top_element(/*window*/);
 /* w_number_type window; */


/*
 *  Routine: select_prev_scroll
 *
 *  Description: it scrolls back the current window. Current item can be
 *               disselected if it goes out of the window. If so,
 *               another one at the limit of the window is selected.
 *
 *  Arguments: none
 *
 *  Return Value: TRUE if movement was possible, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean select_prev_scroll();


/*
 *  Routine: select_next_scroll
 *
 *  Description: it scrolls forward the current window. Current item can be
 *               disselected if it goes out of the window. If so,
 *               another one at the limit of the window is selected.
 *
 *  Arguments: none
 *
 *  Return Value: TRUE if movement was possible, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean select_next_scroll();


/*
 *  Routine: clear_window
 *
 *  Description: it clears the given window
 *
 *  Arguments: window -- (IN) window to consider
 *
 *  Return Value: none
 *
 *  Side Effects: it resets the corresponding virtual window to empty 
 */
void clear_window(/*window*/);
 /*   w_number_type window; */


/*
 *  Routine: move_to_next_window
 *
 *  Description: it advances the current window of one position,
 *               no other action is taken. 
 *
 *  Arguments:  none
 *
 *  Return Value: TRUE if the move is permitted, FALSE if
 *                the move is not allowed.
 *
 *  Side Effects: it changes the current window paramater 
 */
boolean move_to_next_window();


/*
 *  Routine: move_to_prev_window
 *
 *  Description: it moves to the previously selected element of the
 *               previous window and disselects the current item
 *
 *  Arguments: window -- (IN) window to consider
 *
 *  Return Value: TRUE if the previous window exists, FALSE if
 *                the move is not allowed
 *
 *  Side Effects: none
 */
boolean move_to_prev_window(/*window*/);
 /*   w_number_type;  */


/*
 *  Routine: current_window
 *
 *  Description: it gives the current window number
 *
 *  Arguments: none
 *
 *  Return Value: window number
 *
 *  Side Effects: none
 */
w_number_type current_window();


/*
 *  Routine: next_window
 *
 *  Description: it gives the next window of the given window
 *
 *  Arguments: window -- (IN) window to refer to
 *
 *  Return Value:  next window number
 *
 *  Side Effects: none
 */
w_number_type next_window(/*window*/);
 /*   w_number_type window; */


/*
 *  Routine: prev_window
 *
 *  Description: it gives the previous  window of the given window
 *
 *  Arguments: window -- (IN) window to refer to
 *
 *  Return Value:  prievious window number
 *
 *  Side Effects: none
 */
w_number_type prev_window(/*window*/);
 /*   w_number_type window; */


/*
 *  Routine: give_selected_item
 *
 *  Description: given a window, it returns the name and the row
 *               number for the selected iten in that window
 *
 *  Arguments: item_name -- (OUT) item name to return
 *             window -- (IN) window to consider
 *
 *  Return Value: the number of row in which the item is in the virtual
 *                window, -1 if item not found 
 *
 *  Side Effects: none
 *
 */
int give_selected_item(/*item_name, window*/);
 /* char item_name[];
    w_number_type window; */

/*
 *  Routine: selected_item_is_defaultprocessinvariant
 *
 *  Description: it checks if the selected item is a default process 
 *               invariant, looking for a leading "I " in the name
 *
 *  Arguments: item_name -- (IN) name to test
 *
 *  Return Value: TRUE if an invariant structure , otherwise FALSE
 *
 *  Side Effects: none
 */
boolean selected_item_is_defaultprocessinvariant(/*item_name*/);
 /*   char item_name[]; */


/*
 *  Routine: selected_item_is_structure
 *
 *  Description: it checks if the selected item is a structure, looking
 *               for a leading "S " in the name
 *
 *  Arguments: item_name -- (IN) name to test
 *
 *  Return Value: TRUE if a structure, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean selected_item_is_structure(/*item_name*/);
 /*   char item_name[]; */


/*
 *  Routine: write_list_to_window
 *
 *  Description: it writes a list into the given window and it redraws it
 *
 *  Arguments: list -- (IN) list to write
 *             window -- (IN) window to consider
 *
boolean selected_item_is_structure();

/*
 *  Routine: selected_item_is_process
 *
 *  Description: it checks if the selected item is a process, looking
 *               for a leading "P " in the name
 *
 *  Arguments: item_name -- (IN) name to test
 *
 *  Return Value: TRUE if a process, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean selected_item_is_process(/*item_name*/);
 /*   char item_name[]; */


/*
 *  Routine: write_list_to_window
 *
 *  Description: it writes a list into the given window and it redraws it
 *
 *  Arguments: list -- (IN) list to write
 *             window -- (IN) window to consider
 *
 *  Return Value: none
 *
 *  Side Effects: none
 *
 */
void write_list_to_window(/*list, window*/);
 /*   list_type *list;
    w_number_type window; */



/*
 *  Routine: restore_browse
 *
 *  Description: it restores the browse windows after the help call
 *
 *  Arguments: none
 *
 *  Return Value: none
 *
 *  Side Effects: none
 *
 */
void restore_browse();



/*
 *  Routine: ask_file_name
 *
 *  Description: it prompts in the bottom line of the screen for
 *               a file name and it returns it. It checks and eliminates
 *               leading and trailing blanks in the name. The name must
 *               be a single string
 *
 *  Arguments: file_name -- (OUT) file name to read in
 *
 *  Return Value: TRUE if successful in reading, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean ask_file_name(/*file_name*/);
 /*   char file_name[]; */


/*
 *  Routine: send_file_message
 *
 *  Description: it sends to the bottom line a message corresponding
 *               to the idl reader failure
 *
 *  Arguments: error_message -- (IN) message to print in bottom line 
 *
 *  Return Value: none
 *
 *  Side Effects: none
 */
void send_file_message(/* error_message */);
  /* char error_message[]; */


/*
 *  Routine: display_file_name
 *
 *  Description: it writes in the bottom line the given file name
 *
 *  Arguments: file_name -- (IN) file name to display
 *
 *  Return Value: none
 *
 *  Side Effects: none
 *
 */
void display_file_name(/*file_name*/);
 /*   char file_name[]; */


/*
 *  Routine: display_menu_line
 *
 *  Description: it writes the menu line at the buttom of the screen
 *               in the browse screen
 *
 *  Arguments: none
 *
 *  Return Value: none
 *
 *  Side Effects: none
 */
void display_menu_line();


/*
 *  Routine: ask_new_setup
 *
 *  Description: it prompts for new window dimensions and sets the
 *               corresponding variables.
 *
 *  Arguments: col1 -- (OUT) new value for left/center window boundary
 *             col2 -- (OUT) new value for center/right window boundary
 *             line --(OUT) new value for top/bottom windows boundary 
 *
 *  Return Value: TRUE if new parameters correct, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean ask_new_setup(/* col1,col2,line */);
 /* int *col1;
    int *col2;
    int *line; */


/*
 *  Routine: setup
 *
 *  Description: it reshapes the screen with new windows. To be
 *               called after ask_new_setup
 *
 *  Arguments: col1 -- (IN) new value for left/center window boundary
 *             col2 -- (IN) new value for center/right window boundary
 *             line -- (IN) new value for top/bottom windows boundary 
 *
 *  Return Value: none
 *
 *  Side Effects: it modifies the setup of window variables
 */
void setup(/*col1,col2,line */);
 /* int col1;
    int col2;
    int line; */


/*
 *  Routine: refresh_screen
 *
 *  Description: it refreshes the screen for browse. Needed when the IDL
 *               reader dumps its messages onto the terminal. 
 *
 *  Arguments: none
 *
 *  Return Value: none
 *
 *  Side Effects: none
 */
void refresh_screen();

/*
 *  Routine: quit
 *
 *  Description: it exits the curse mode and restores the previous
 *               terminal setup
 *
 *  Arguments: none
 *
 *  Return Value: none
 *
 *  Side Effects: none
 *
 */
void quit();


/*
 *  Routine: error_message
 *
 *  Description: it sends a bell char to the terminal
 *
 *  Arguments: none
 *
 *  Return Value: none
 *
 *  Side Effects: none
 */
void error_message();


