/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlbrowse/signal.c 
*				 					* 
*   Copyright (C) 1991 Marco Chierotti
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include <signal.h>

#include "global.h"
#include "command.h"
#include "windows.h"
#include "candle.h"
#include "help.h"

boolean move_down(),move_right();


void home();

/* Two different versions of signals are used in different UNIX implementations
      int  (*signal)();
   and
      void (*signal)();
   The sequent and vax use the 1st defn. Suns and mips use the 2nd defn.
   If you have problems please change the defines below for your purpose.
*/
#ifdef sequent
#define TYPEOFSIGNAL int
#endif
#ifdef vax
#define TYPEOFSIGNAL int
#endif
/* for suns, mips */
#ifndef TYPEOFSIGNAL
#define TYPEOFSIGNAL void
#endif

void init_signal()
{
 void sig_handler();
 (void)signal(SIGUSR1, (TYPEOFSIGNAL(*)()) sig_handler);
}


void sig_handler()
{
 FILE *fptr,*fopen();
 char filename[101];
 line_type error_message_line;
 list_type pr_str_list;
 list_type item_list;
 line_type processname,nodename,attributename,invstructname;
 line_type scratchstring,scratchstring2;
 int i,j, index;
 reader_status_type reader_status;

 fptr = fopen (IDLBROWSEFILE,"r");
 if(fptr == NULL) {
   send_file_message("Signal from idlview, But could not open common file");
   return;
 }
 (void)fscanf(fptr,"%s", filename);
 (void)fscanf(fptr,"%s", processname);
 (void)fscanf(fptr,"%s", nodename);
 (void)fscanf(fptr,"%s", attributename);
 (void)fclose(fptr);
 
 (void)sprintf(scratchstring,"Signal from idlview - Loading new file %s",filename);
 send_file_message(scratchstring);
 reader_status = load_candle_instance(filename, error_message_line);
 if (reader_status == NO_ERROR) {
   (void)find_proc_and_struct(&pr_str_list);
   if ( ! empty_list(&pr_str_list) ) {
     home();
     write_list_to_window(&pr_str_list, current_window());
     (void)select_top_element(current_window());
     send_file_message("New file loaded");
     (void)sprintf(invstructname,"I %s",processname);
     index = index_in_list(invstructname,&pr_str_list);
     if (index == -1) { 
       (void)sprintf(scratchstring,"Default Invariant for Process %s not found",processname);
       send_file_message(scratchstring);
       return;
     }
     for (j = 0;j < index; j++)
       (void)move_down();      
     (void)move_right();
   }
   else {
     (void)sprintf(scratchstring,"Empty Structure and Process List");
     send_file_message(scratchstring);     
     return;
   }
 }
 else if (reader_status == OPEN_ERROR) {
   (void)sprintf(scratchstring,"Error in opening %s",filename);
   send_file_message(scratchstring);
   return;
 }
 else {
   (void)sprintf(scratchstring,"IDL Error in %s",filename);
   send_file_message(scratchstring);
   return;
 }


   
 
 /* go to nodes section */
 (void)find_struct_properties(invstructname, &item_list);
 if ( ! empty_list(&item_list) ) {
   index = index_in_list("Nodes", &item_list);
   if (index == -1) { 
     (void)sprintf(scratchstring,"Node %s not found",nodename);
     send_file_message(scratchstring);
     return;
   }
   for (i=0; i < index; i++)
     (void)move_down();
 }
 else {
   (void)sprintf(scratchstring,"Empty Structure and Process List");
   send_file_message(scratchstring);     
   return;
 }
 
 (void)move_right();
 
 (void)find_nodes(invstructname, &item_list);
 if ( ! empty_list(&item_list) ) {
   index = index_in_list(nodename, &item_list);
   if (index == -1) { 
     (void)sprintf(scratchstring,"Node %s not found",nodename);
     send_file_message(scratchstring);
     return;
   }
   for (i=0; i < index; i++)
     (void)move_down();
 }
 else {
   (void)sprintf(scratchstring,"Empty Property List");
   send_file_message(scratchstring);        
   return;
 }
 
 (void)move_right();
 (void)find_node_info(invstructname, nodename, &item_list);
 if ( ! empty_list(&item_list) ) {
   (void)sprintf(scratchstring2,"%s:",attributename);
   index = -1;
   for (j=0; j <= item_list.last_row; j++) {
     (void)sscanf(item_list.body[j],"%s", scratchstring);
     if (!strcmp(scratchstring,scratchstring2)) {
       index = j;
       break;
     }
   }
   if (index == -1) {
     (void)sprintf(scratchstring,"Attribute %s not found",attributename);
     send_file_message(scratchstring);
     return;
   }
   for (i=0; i < index; i++)
     (void)move_down();
 }
 else {
   (void)sprintf(scratchstring,"Empty Attribute List");
   send_file_message(scratchstring);        
   return;
 }
 
}
