/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlbrowse/main.c 
*				 					* 
*   Copyright (C) 1991 Marco Chierotti
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *
 *  Description: this is the main file for the idlbrowse program
 *               It interprets the command line, then calls the command
 *               module to interact with the user.
 *
 *  Diagnostics: if the command line is wrong, or if an error occurs in
 *              reading the input file, or if the terminal cannot 
 *              support the program, it prints a message and exits with
 *              a value of -1, otherwise  it returns 0.
 *
 */

/***** INCLUDE FILES *****/

#include <stdio.h>            
#include "global.h"
#include "candle.h"          
#include "help.h"
#include "command.h"



boolean init_browse();
void init_w_system();
void init_signal();
boolean init_help();
void exit();
void revision_number(), usage();

char *this_program_name = NULL;


/***** FUNCTION PROTOTYPES *****/

/***** CODE *****/

/*
 *  Routine: main
 *
 *  Description: it reads the command line, it parses it. If correct,
 *               it loads the Candle file and calls the command interpreter
 *               to interact with the user. 
 *
 *  Arguments: argc -- (IN) number of args in command line
 *             argv -- (IN) array of string arguments
 *
 *  Return Value: -1 if the command line is wrong or the file cannot
 *                be successfully read, otherwise 0
 *
 *  Side Effects: none
 *
 */
main(argc, argv)
    int argc;       /* number of args in command line */
    char *argv[];   /* array of pointers to args in command line */
    {
    reader_status_type reader_status;
    line_type dummy_error_message;
    this_program_name = argv[0];

    init_signal();

    /*
     * check the number of arguments in command line
     */
    if ( argc != 2 ) {
	usage(argv[0]);
	exit(-1);
	}

    if (! strcmp(argv[1], "-V")) {
        revision_number(argv[0]);
        exit(0);
        }
      
    /*
     * parse the command line and check for errors
     */
    init_candle();
    /*
     * read the Candle instance from input port, and check for errors
     */
    reader_status = load_candle_instance(argv[1],dummy_error_message); 
    if ( (reader_status == IDL_ERROR) || (reader_status == OPEN_ERROR) ) {
        (void)fprintf(stderr,"idlbrowse: File %s cannot be opened for reading.\n",
                              argv[1]);
        exit(-1);
        }

    /*
     * initialize screen data structures
     */
    init_w_system();
    /*
     * if terminal does have enough rows or columns, abort
     */
    if ( ! init_browse()) {
        (void)fprintf(stderr,"idlbrowse: insufficient terminal cols or rows\n");
        exit (-1);
        }

    (void)init_help();

    /*
     *  call the command interpreter
     */
    command_interpreter();

    return(0);

    } /* main */


void usage(name)
char *name;
{
 (void)fprintf(stderr,"usage: %s [-V] Candlefile\n",name);
}

void get_revision_number(str)
char *str;
{
 (void)sscanf("$Revision: 5.0 $","%*s %s",str);
}

void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)get_revision_number(revision_str);
 (void)printf("%s: Screen oriented browser for a Candle instance Version %s\n",name,revision_str);
 usage(name);
}

