/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlbrowse/help.h 
*				 					* 
*   Copyright (C) 1991 Marco Chierotti
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 *
 *  Description: module to  provide help for the user. It reads a text file
 *               with help info and it allows to scroll it up and down on
 *               the screen. Exiting the help restores the normal operation
 *               mode. It does not make use of any other module. It needs
 *               the support of the Curse package.
 *
 */


/*****************************************************************************/

/*
 *  Routine: init_help
 *
 *  Description: it initialize the global structures in the module and
 *      loads the help file if available
 *
 *  Arguments: none
 *
 *  Return Value: TRUE if the initialization is succesful
 *
 *  Side Effects: not direct, but from underlying fuctions
 */
boolean init_help();

/*
 *  Routine: help
 *
 *  Description: it shows the help window and interprets the user commands
 *      scrolling the screen up and down. When exiting, needs some external
 *      action to restore the browse screen.
 *
 *  Arguments: none
 *
 *  Return Value: none
 *
 *  Side Effects: not direct, but from underlying functions
 */
void help();

