/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlbrowse/global.h 
*				 					* 
*   Copyright (C) 1991 Marco Chierotti
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 *
 *  Description: module to define data types available to all the other
 *               modules. It contains also functions to deal with the
 *               above data types. It does not make use of any other module.
 */



/*****************************************************************************/

/*
 * boolean type made available to all modules
 */
typedef char  boolean;
/*
 * definition of boolean variables if not defined yet
 */
#ifndef TRUE
#define TRUE  1
#endif
#ifndef FALSE
#define FALSE 0
#endif
/*
 * definitions to deal with lines and lists of lines
 */
#define MAX_COL   250     /* max cols for a line */
#define MAX_LINE  100     /* max lines for arrays of lines */

typedef char line_type[MAX_COL +1];      /* single line string */
/*
 * definition of a list as an array of lines 
 */
typedef struct {
    int last_row;              /* last row not empty */
    line_type body[MAX_LINE];  /* array of lines */
    } list_type;
/*
 * functions exported
 */


/*
 *  Routine: init_list
 *
 *  Description: it initializes the given list to empty
 *
 *  Arguments: list -- (OUT) list to be initialized
 *
 *  Return Value: none
 *
 *  Side Effects: none
 */
 void init_list(/*list*/);
  /* list_type *list; */

/*
 *  Routine: empty_list
 *
 *  Description: it checks if the given list is empty
 *
 *  Arguments: list -- (IN) list to test
 *
 *  Return Value: TRUE if empty, else FALSE
 *
 *  Side Effects: none
 */
boolean empty_list(/*list*/);
 /*   list_type *list; */


/*
 *  Routine: full_list
 *
 *  Description: it checks if the given list is full
 *
 *  Arguments: list -- (IN) list to test
 *
 *  Return Value: TRUE if full, else FALSE
 *
 *  Side Effects: none
 */
boolean full_list(/*list*/);
 /*   list_type *list; */

 /*
 *  Routine: append_line
 *
 *  Description: given a non full list, it appends a line to  its bottom
 *
 *  Arguments: line -- (IN) line to append
 *             list -- (IN/OUT) list to append to
 *
 *  Return Value: TRUE if insertion possible, FALSE if not
 *
 *  Side Effects: none
 */
boolean append_line(/*line, list*/);
 /* line_type line;
    list_type *list; */


/*
 *  Routine: is_in_list
 *
 *  Description: it check if a line is already inside the given list
 *
 *  Arguments: line -- (IN) line to test 
 *             list -- (IN/OUT) list to look inside
 *
 *  Return Value:  TRUE if line is present, FALSE if not
 *
 *  Side Effects: none
 */
boolean is_in_list( /*line, list*/);
 /* line_type line;
    list_type *list; */

/*
 *  Routine: index_in_list
 *
 *  Description: Returns index of the line in the list else -1
 *
 *  Arguments: line -- (IN) line to test
 *             list -- (IN/OUT) list to look inside
 *
 *  Return Value:  -1 if not found, else index (0...)
 *
 *  Side Effects: none
 */
int index_in_list( /*line, list*/);
 /* line_type line;
    list_type *list; */



/*
 *  Routine: string_copy
 *
 *  Description: it copies source string into dest string up to max
 *               characters. If length of source is <= max, it copies
 *               all the string, if not it copies max characters. The
 *               dest string is null terminated.
 *
 *  Arguments: dest -- (OUT) string to be copied into
 *             source -- (IN) string to be copied
 *             max -- (IN) max number of chars to be copied
 *
 *  Return Value: none
 *
 *  Side Effects: none
 */
void string_copy(/*dest, source, max*/);
 /* char *dest;
    char *source; */


/*
 *  Routine: string_concat
 *
 *  Description: it concatenates two strings copying them in a third string.
 *               the resulting string is truncated if exceeds the max 
 *               given length
 *
 *  Arguments: dest -- (OUT) resulting string
 *             source1 -- (IN) string to be first in the concatenation
 *             source2 -- (IN) string to be second (to be appended)
 *             max -- (IN) max number of chars allowed
 *
 *  Return Value: none
 *
 *  Side Effects: none
 */
void string_concat(/*dest, source1, source2, max*/);
 /* line_tye dest;
    line_type source1;
    line_type source2;
    int max; */

