/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlbrowse/global.c 
*				 					* 
*   Copyright (C) 1991 Marco Chierotti
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *
 *  Description: module to support general data types and ADT. 
 *               For more details refer to the header of its 
 *               corresponding .h file.
 *
 */


/*****************************************************************************/


/***** INCLUDE FILES *****/

#include "global.h"

/***** CODE *****/


/*****************************************************************************/
 void init_list(list)
     list_type *list;
     {

     (*list).last_row = -1;

     } /* init_list */


/*****************************************************************************/
boolean empty_list(list)
    list_type *list;
    {
    if ( (*list).last_row < 0 )
	return(TRUE);
    else
	return(FALSE);

    } /* empty_list */


/*****************************************************************************/
boolean full_list(list)
    list_type *list;
    {
    if ( (*list).last_row >= (MAX_LINE - 1) )
	return(TRUE);
    else
	return(FALSE);

    } /* full_list */


/*****************************************************************************/
boolean append_line(line, list)
    line_type line;
    list_type *list;
    {
    if ( full_list(list) )
	return(FALSE);

    if ( empty_list(list) )
	(*list).last_row = 0;
    else
	(*list).last_row++;

    string_copy( (*list).body[(*list).last_row], line, MAX_COL);

    return(TRUE);

    } /* append_line */



/*****************************************************************************/
boolean is_in_list(line,list)
    line_type line;
    list_type *list;
    {
    int i;

    if (empty_list(list))
        return(FALSE);

    for (i=0; i<=(*list).last_row; i++) {
        if (strcmp(line,(*list).body[i]) == 0)
            return(TRUE);
        }

    return(FALSE);

    } /* is_in_list */

int index_in_list(line,list)
    line_type line;
    list_type *list;
    {
    int i;

    if (empty_list(list))
        return(-1);

    for (i=0; i<=(*list).last_row; i++) {
        if (strcmp(line,(*list).body[i]) == 0)
            return(i);
        }

    return(-1);

    } /* index_in_list */



/*****************************************************************************/
void string_copy(dest, source, max)
    char *dest;
    char *source;
    int max;
    {
    int len, i;

    len = strlen(source);
    if (len > max )
	len = max;
    for (i = 0; i < len; i++)
	dest[i] = source[i];
    dest[len] = '\0';

    } /* string_copy */



/*****************************************************************************/
void string_concat(dest, source1, source2, max)
    line_type dest;
    line_type source1;
    line_type source2;
    int max;
    {
    int len1;

    /*
     * if the first is too long, copy it truncating
     */
    string_copy(dest, source1, max);
    if ( (len1 = strlen(source1)) >= max) {
        return;
        }
    /*
     * catenate the second string
     */
     string_copy(dest + len1, source2, max - len1);

    } /* string_concat */
