/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlbrowse/candle.h 
*				 					* 
*   Copyright (C) 1991 Marco Chierotti
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 


/*
 *
 *  Description: It allows the loading of a Candle structure and its
 *               successive browsing when called by the Command Module.
 *               It does not call any othe module, but it needs the support
 *               of the IDL generate code.
 */


/*****************************************************************************/
/*
 * type definition for the error code messages IDL reader
 */
typedef int reader_status_type;
/*
 * values assumed by above type
 */
#define NO_ERROR   0
#define OPEN_ERROR 1
#define IDL_ERROR -1


/*****************************************************************************/
/*
 *  Routine: init_candle
 *
 *  Description: it sets the internal structures for the module. To be
 *               called before any further action
 *  Arguments: none
 *
 *  Return Value: none
 *
 *  Side Effects: it sets the candle instance and the corresponding file name
 */
void init_candle();



/*
 *  Routine: load_candle_instance
 *
 *  Description: it opens a file with the given file name and
 *               reads a Candle instance. If some error occurs,
 *               the old candle structure is kept (if any)
 *
 *  Arguments: file_name -- (IN) file to read from
 *             error_message -- (OUT) string esplaining the error occurred
 *
 *  Return Value: NO_ERROR if Candle instance succesfully loaded 
 *                OPEN_ERROR if error in opening the file (e.g. doesn't exist)
 *                IDL_ERROR if error detected by IDL port
 *
 *  Side Effects: it loads the candle structure and memorizes the
 *                file name if there are no errors.
 */
reader_status_type load_candle_instance(/*file_name,error_message*/);
 /*   line_type file_name;
      line_type error_message */


/*
 *  Routine: find_proc_and_struct
 *
 *  Description:
 *
 *  Arguments: pr_str_list -- (OUT) list of processes and structures
 *             present in the candle instance
 *
 *  Return Value: TRUE if succesful
 *
 *  Side Effects: none
 */
boolean find_proc_and_struct(/*pr_str_list*/);
 /*   list_type *pr_str_list; */



/*
 *  Routine: find_struct_properties
 *
 *  Description: given a structure name, it returns a list of
 *               properties (Derived From, Classes, Nodes, etc.)
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             struct_prop_list -- (OUT) list of properties
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */ 
boolean find_struct_properties(/*struct_name, struct_prop_list*/);
 /*   line_type struct_name;
    list_type *struct_prop_list; */


/*
 *  Routine: find_refined_struct
 *
 *  Description: finds the structure the given structure is refined from
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             refined_list -- (OUT) structure refined from
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_refined_struct(/*struct_name, refined_list*/);
 /*   line_type struct_name;
    list_type *refined_list; */



/*
 *  Routine: find_root
 *
 *  Description: given a structure name, it returns the name of is
 *               root, if any.
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             root_list -- (IN) name of the root
 *
 *  Return Value: TRUE if succesful 
 *
 *  Side Effects: none
 */
boolean find_root(/*struct_name, root_list*/);
 /*   line_type struct_name;
    list_type *root_list; */



/*
 *  Routine: find_assert_struct
 *
 *  Description: finds the assertion names for a structure
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             assert_list -- (OUT) assertion list
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_assert_struct(/*struct_name, assert_list */);
 /*   line_type struct_name;
    list_type *assert_list; */



/*
 *  Routine: find_classes
 *
 *  Description: finds the classes the given structure contains
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             class_list -- (OUT) list of classes
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_classes(/*struct_name, class_list*/);
 /*   line_type struct_name;
    list_type *class_list; */



/*
 *  Routine: find_nodes
 *
 *  Description: finds the nodes the given structure contains
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             node_list -- (OUT) list of nodes
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_nodes(/*struct_name, node_list*/);
 /*   line_type struct_name;
    list_type *node_list; */



/*
 *  Routine: find_priv_types
 *
 *  Description: finds the private types the given structure contains
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             priv_types_list -- (OUT) list of private types
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_priv_types(/*struct_name, priv_types_list*/);
 /*   line_type struct_name;
    list_type *priv_types_list; */

/*
 *  Routine: find_basic_types
 *
 *  Description: finds the basic types the given structure contains
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             basic_types_list -- (OUT) list of basic types
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_basic_types(/*struct_name, basic_types_list*/);
 /*   line_type struct_name;
    list_type *basic_types_list; */



/*
 *  Routine: find_struct_unnamed_assert
 *
 *  Description: finds the unnamed assertions the given structure contains
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             struct_unnamed_assert_list -- (OUT) list assertions
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_struct_unnamed_assert(/*struct_name, struct_unnamed_assert_list*/);
 /*   line_type struct_name;
    list_type *struct_unnamed_assert_list; */



/*
 *  Routine: find_struct_assert_body
 *
 *  Description: finds the assertion body for the given structure and the
 *               given assertion
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             assert_name -- (IN)  assertion name
 *             assertion_body_list -- (OUT) assertion body
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_struct_assert_body(/*struct_name, assert_name
                               , assertion_body_list*/);
 /*   line_type struct_name;
    line_type assert_name;
    list_type *assertion_body_list; */



/*
 *  Routine: find_class_info
 *
 *  Description: finds atttributes, superclasses and subclasses for
 *               the given structure and the given class
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             class_name -- (IN)  class name
 *             class_info_list -- (OUT) list of info
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_class_info(/*struct_name, class_name, class_info_list*/);
 /*   line_type struct_name;
    line_type class_name;
    list_type *class_info_list;  */


/*
 *  Routine: find_node_info
 *
 *  Description: finds attributes, and subclasses for
 *               the given structure and the given node
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             node_name -- (IN)  node name
 *             node_info_list -- (OUT) list of info
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_node_info(/*struct_name, node_name, node_info_list*/);
 /*   line_type struct_name;
    line_type node_name;
    list_type *node_info_list; */

/*
 *  Routine: find_priv_type_info
 *
 *  Description: finds info for the given structure and the given
 *               private type
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             priv_type_name -- (IN)  private type name
 *             priv_type_info_list -- (OUT) list of info
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_priv_type_info(/*struct_name, priv_type_name,
                             priv_type_info_list*/);
 /*   line_type struct_name;
    line_type priv_type_name;
    list_type *priv_type_info_list; */

/*
 *  Routine: find_basic_type_occurrence
 *
 *  Description: finds info for the given structure and the given
 *               basic type
 *
 *  Arguments: struct_name -- (IN) name of the structure to consider
 *             basic_type_name -- (IN)  basic type name
 *             basic_type_info_list -- (OUT) list of info
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_basic_type_occurrence(/*struct_name, basic_type_name,
                                     basic_type_info_list*/);
 /*   line_type struct_name;
    line_type basic_type_name;
    list_type *basic_type_info_list; */

/*
 *  Routine: find_process_properties
 *
 *  Description: given a process name, it returns a list of
 *               properties (Refined From, Pre Ports, etc.)
 *
 *  Arguments: process_name -- (IN) name of the process to consider
 *             proc_prop_list -- (OUT) list of properties
 *
 *  Return Value: none
 *
 *  Side Effects: TRUE if successful
 *
 */
boolean find_process_properties(/*process_name, proc_prop_list*/);
 /*   line_type process_name;
    list_type *proc_prop_list; */


/*
 *  Routine: find_refined_proc
 *
 *  Description: finds the process the given process is refined from
 *
 *  Arguments: proc_name -- (IN) name of the process to consider
 *             refined_name -- (OUT) process name list
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_refined_proc(/*proc_name, refined_name*/);
 /*   line_type proc_name;
    list_type *refined_name; */



/*
 *  Routine: find_assert_proc
 *
 *  Description: finds the assertion names for a process
 *
 *  Arguments: proc_name -- (IN) name of the process to consider
 *             assert_list -- (OUT) assertion list
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_assert_proc(/*proc_name, assert_list */);
 /*   line_type proc_name;
    list_type *assert_list; */


/*
 *  Routine: find_invariant
 *
 *  Description: finds the invariant for the given structure 
 *
 *  Arguments: proc_name -- (IN) name of the process to consider
 *             invariant_name -- (OUT) invariant name
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_invariant(/*proc_name, invariant_name*/);
 /*   line_type proc_name;
    list_type *invariant_name; */


/*
 *  Routine: find_pre_ports
 *
 *  Description: finds the pre ports names for a process
 *
 *  Arguments: proc_name -- (IN) name of the process to consider
 *             pre_ports_list -- (OUT) pre port list
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_pre_ports(/*proc_name, pre_ports_list */);
  /*  line_type proc_name;
    list_type *pre_ports_list; */

/*
 *  Routine: find_post_ports
 *
 *  Description: finds the post ports names for a process
 *
 *  Arguments: proc_name -- (IN) name of the process to consider
 *             post_ports_list -- (OUT) post port list
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_post_ports(/*proc_name, post_ports_list */);
 /*    line_type proc_name;
    list_type *post_ports_list; */



/*
 *  Routine: find_proc_unnamed_assert
 *
 *  Description: finds the unnamed assertions the given process contains
 *
 *  Arguments: proc_name -- (IN) name of the process to consider
 *             proc_unnamed_assert_list -- (OUT) list assertions
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_proc_unnamed_assert(/*proc_name, proc_unnamed_assert_list*/);
 /*   line_type proc_name;
    list_type *proc_unnamed_assert_list; */



/*
 *  Routine: find_proc_assert_body
 *
 *  Description: finds the assertion body for the given process and the
 *               given assertion
 *
 *  Arguments: proc_name -- (IN) name of the process to consider
 *             assert_name -- (IN)  assertion name
 *             assertion_body_list -- (OUT) assertion body
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_proc_assert_body(/*proc_name, assert_name, assertion_body_list*/);
 /*   line_type proc_name;
    line_type assert_name;
    list_type *assertion_body_list; */



/*
 *  Routine: find_port_structure
 *
 *  Description: finds the structure associated to a given port of
 *               a given process and representation statements for 
 *               the port.
 *
 *  Arguments: proc_name -- (IN) name of the process to consider
 *             port_name -- (IN)  port name
 *             struct_and_repr_stat_list -- (OUT) structure name  and
 *                     representation statements
 *
 *  Return Value: TRUE if successful
 *
 *  Side Effects: none
 */
boolean find_port_structure(/*proc_name, port_name, 
                      struct_and_repr_stat_list*/);
 /*   line_type proc_name;
    line_type port_name;
    list_type *struct_and_repr_stat_list; */


/*
 *  Routine: find_target_info
 *
 *  Description: it finds if the target specifications (and which) are
 *               present inside a process.  It returns the found significant
 *               entries.
 *
 *  Arguments: proc_name -- (IN) name of the process to investigate
 *             target_info_list -- (OUT) list of found entries
 *
 *  Return Value: TRUE if the process exists, otherwise FALSE
 *
 *  Side Effects: none
 */
boolean find_target_info(/*proc_name, target_info_list*/);
 /* line_type proc_name;
    list_type *target_info_list; */
