/***********************************************************************\ 
*									* 
*   File: scorpion/src/gentransitions/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: generate a transition structure                           *
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

 /* ******************************************************************* *\
 *   Revision Log:                                                       *
 *       $Log:	main.c,v $
 * Revision 4.0  89/04/12  07:22:11  cheung
 * main.c  Ver 4.0
 * 
 * Revision 3.9  89/04/02  13:35:25  cheung
 * main.c  Ver 3.9
 * 
 *                                                                       *
 *   Edit Log:                                                           *
 *     Jan 9 1985 (shannon) Created.                                     *
 *                                                                       *
 \* ******************************************************************* */

#include "gentransitions.h"
#include <stdio.h>
#include <string.h>

#define CopyName(nname, oname)	(void) strcpy((nname = (char *)GetHeap(strlen(oname)+1)) , oname)
#define LINESIZE 1024

void revision_number(), usage();
void exit();

main(argc,argv)
int argc;
char *argv[];
{
    register int charcount;
    int linenumber;
    char buf[LINESIZE+1];
    char filename[LINESIZE+1];
    transitions allfiles;
    filetransition AFile;

    allfiles = Ntransitions;
    charcount = 0;

    if(argc == 2 && !strcmp(argv[1],"-V")) {
       revision_number(argv[0]);
       exit(0);
    }
    else if (argc != 1) {
      usage(argv[0]);
      exit (1);
    }

    while (fgets(buf, LINESIZE, stdin) != NULL) {
	charcount += strlen(buf);
	if (buf[0] == '#') {
	    if (sscanf(&buf[1], "%d %s", &linenumber, filename) == 2) {
		AFile = Nfiletransition;

		/* strip "s off filename */
		filename[strlen(filename)-1] = '\0';
		CopyName(AFile->filename, &filename[1]);

		AFile->charoffset = charcount+1;
		AFile->filelinenumber = linenumber;
		appendrearSEQfiletransition(allfiles->transitions, AFile);
	    }
	}
    }
    OUTTransitions(stdout, allfiles, TWOPASS);
    return 0 ;
}

void usage(name)
char *name;
{
 (void)fprintf(stderr,"usage: %s [-V]\n",name);
}


void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)sscanf("$Revision: 5.0 $","%*s %s",revision_str);
 (void)printf("%s: File transition data structure generator Version %s\n",name,revision_str);
 usage(name);
}

