/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/setlevel.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"


SEQinfo setlevel(level,errorinfoseq)
char *level;
SEQinfo errorinfoseq;
{
   SEQinfo Sinfo, Tinfo;
   info Ainfo;
   int ilevel;

   initializeSEQinfo(Tinfo);

   if (strequal(level,"all")) {
	return(errorinfoseq);
   }

   if (strcmp(level,"fatal") == 0) ilevel = Kfatal;
   if (strcmp(level,"severe") == 0) ilevel = Ksevere;
   if (strcmp(level,"recoverable") == 0) ilevel = Krecoverable;
   if (strcmp(level,"extension") == 0) ilevel = Kextension;
   if (strcmp(level,"warning") == 0) ilevel = Kwarning;
   if (strcmp(level,"comment") == 0) ilevel = Kcomment;

   foreachinSEQinfo(errorinfoseq,Sinfo,Ainfo) {
	if (ilevel == typeof(Ainfo->itype)) 
   	   appendrearSEQinfo(Tinfo,Ainfo); 
   }
   return(Tinfo);
}
	
    	   
   


