/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/oneof.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include <string.h>
#define MAXLINESIZE 100
char *strarg();

/********************************************************************************\
 * Routine: oneof                                                               *
 *   Input:                                                                     *
 *         arg      from ci or a routine using ci.                              *
 *                  This is the string to be used for parsing input             *
 *         strings  a string that contains a list of words seperated by a space *
 *         prompt   this is the prompt the routine should use to ask for input  *
 *         default  the default that should be used in input query.             *
 *                  Should be one of the words in strings                       *
 *   Output:                                                                    *
 *         Returns ptr to one of the strings in the list as chosen by the user  *
 *         If ^D is typed NULL is returned                                      *
 *         buf      Should be the address of an array of char where the returned*
 *                  string is to be stored                                      *
 *   Restrictions:                                                              *
 *         "strings" should not be longer than 999 chars                        *
 *         Input typed in by user should not exceed 100 chars per newline       *
 *         The var "impossible"  should not be in "strings"                     *
 *                                                                              *           
\********************************************************************************/


char *oneof(arg, strings,prompt,defalt,buf)
char **arg, *strings, *prompt, *defalt, buf[];

{
  char input[MAXLINESIZE];  /* This will be the string typed in by the user */
  char list[MAXLINESIZE];/* This will hold the list of words sent in as input */
  int index1, index2;    /* indexes into strings */
  char substr[101];      /* used in searching for substrings */
  int i,j;               /* loop counters */
  char impossible[4];    /* Used to detect fact that strarg does no work after ^D typed */

  /* This value should not be in "strings" */
  (void) strcpy(impossible,"999");

  /* For parsing */

  
  /* Force a blank at the front of the list */
  (void) strcpy(list," ");
  (void) strcat(list,strings);


  /* Get input, if ^D was input return NULL, else check for uniqueness of input */
  (void) strcpy(input,impossible);
  (void) strarg(arg," \n", prompt, defalt, input);
  if (!strcmp(input,impossible))   return NULL;  

  while (1) {
    /* Find leftindex of input */
    (void) strcpy(substr," ");
    (void) strcat(substr,input);
    index1 = firsdex(substr,list);
  
    /* Find rightindex of input */
    index2 = lasdex(substr,list);

    /* Check uniqueness of input */
    if (index1==-1) {
      /* Not a prefix to a valid string */
      (void) printf("%s is not a prefix to a valid choice.  Choose one of the following: \n",input);
      (void) printf("%s\n\n",list);
      (void) strcpy(input,impossible);
      (void) strarg(arg," \n", prompt, defalt, input);
      if (!strcmp(input,impossible)) 	return NULL;
    }
    else if (index1 != index2) {
      /* Matches more than one choice */
      (void) printf("%s is a non-unique prefix.  Choose one of the following: \n",input);
      (void) printf("%s\n\n",list);
      (void) strcpy(input,impossible);
      (void) strarg(arg," \n", prompt, defalt, input);
      if (!strcmp(input,impossible)) 	return NULL;
    }
    else { 
      /* input was unique, return it */
      
      /* Copy the complete word into buf, and return ptr. to buf */
      for (j=0,i=index1+1; ((list[i]!= ' ') && (list[i]!=(char)NULL)); j++,i++) {
	buf[j] = list[i];
      }
      buf[j] = (char)NULL;
      return(buf);
	
      /* rv was deleted, if use the following code, declare rv again */
      /* Allocate enough space for the string being returned 
      rv = (char *) calloc(num+1,sizeof(char));
      for (i=0; i<num; i++) 	rv[i] = list[index1+1+i];
      rv[i] = (char)NULL;
      return(rv);
      */
    }
  }
}
