/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/display.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"

void display(fp, Ainfo)
FILE *fp;
info Ainfo;
{

  /* print out the error structure */
  (void) fprintf(fp,"\n\tError number:\t\t%d",Ainfo->number);

  switch (typeof(Ainfo->itype)) {      
     case Kfatal:       { (void) fprintf(fp,"\n\ttype:\t\t\tfatal\n");
                          break;}
     case Ksevere:      { (void) fprintf(fp,"\n\ttype:\t\t\tsevere\n");   
                          break;}
     case Krecoverable: { (void) fprintf(fp,"\n\ttype:\t\t\trecoverable\n");
                          break;}
     case Kwarning:     { (void) fprintf(fp,"\n\ttype:\t\t\twarning\n");
                          break;}
     case Kextension:   { (void) fprintf(fp,"\n\ttype:\t\t\textension\n");
                          break;}
     case Kcomment:     { (void) fprintf(fp,"\n\ttype:\t\t\tcomment\n");
                          break;}
   }

  switch (typeof(Ainfo->position)) {      
     case Kcharposition:   {(void) fprintf(fp,"\tposition:\t\tcharposition\n",
                               Ainfo->itype);
                            break;}
     case Klineposition:   {(void) fprintf(fp,"\tposition:\t\tlineposition\n",
                               Ainfo->itype);
                            break;}
     case Kendposition:    {(void) fprintf(fp,"\tposition:\t\tendposition\n",
                               Ainfo->itype);
                            break;}
     case Kstderrposition: {(void) fprintf(fp,
                               "\tposition:\t\tstderrposition\n",Ainfo->itype);
                            break;}
   }

  (void) fprintf(fp,"\tmessage:\t\t%s\n",Ainfo->message);
  (void) fprintf(fp,"\tdescription:\t\t%s\n",Ainfo->description);
  (void) fprintf(fp,"\trecovery:\t\t%s\n",Ainfo->compiler_recovery);
  (void) fprintf(fp,"\tuser correction:\t%s\n\n",Ainfo->user_correction);

  
  return;
  
}

