/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/del.h 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*  del  --  interrupt handling macros
 *
 *  HISTORY
 */

#include <signal.h>

extern int del();
extern int _del_;

#define ENABLEDEL {if (signal(SIGINT,SIG_IGN)!=SIG_IGN) {_del_=0; signal(SIGINT,del);}}
#define DISABLEDEL {if (signal(SIGINT,SIG_IGN)!=SIG_IGN) {signal(SIGINT,SIG_DFL); _del_=0;}}
#define IGNOREDEL {signal(SIGINT,SIG_IGN); _del_=0;}

#define _DELNOTE_	_del_=0; (void) printf ("  Break!\n");
#define DELBREAK	if (_del_) {_DELNOTE_ break;}
#define DELRETURN	if (_del_) {_DELNOTE_ return;}
#define DELRETN(x)	if (_del_) {_DELNOTE_ return (x);}
#define DELLONGJMP(e,x)	if (_del_) {_DELNOTE_ longjmp (e,x);}
#define DELCLEAR	if (_del_) {_del_=0; (void) printf ("Break ignored.\n");}
