/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/checkbd.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"


#define PERSIGN	"%"
#define VALIDREP "ABCDEFGIMNPQRSTVWXY"

void copyAchar();

void checkbd(Aformat)
format Aformat;
{
  extern errorinfo ErrorInstance;
  int lindex, sign, i;
  char letter;
  char letterstr[2];
  boolean found;
  char *thisbackdrop;

  letterstr[1] = '\0';
  found = FALSE;

  thisbackdrop = StringToChar(Aformat->backdrop);
  
  while (((lindex = firsdex(PERSIGN,thisbackdrop)) != -1) && !found) {	

	   /* change the percent sign to other character */
           thisbackdrop[lindex] = '.';

	   /* save position for the uparrow */
           sign = lindex + 1;

	   /* allow %%, but disallow %<width>% */
 	   ++lindex;
	   copyAchar(Aformat->backdrop,&letter,lindex);
	   letterstr[0] = letter;
           if (!strcmp(letterstr,"%")) {
	      thisbackdrop[lindex] = '.';
	      continue;
	   }

	   while (lindex <= strlen(Aformat->backdrop)){ 
		copyAchar(Aformat->backdrop,&letter,lindex);
		letterstr[0] = letter;
	        	

	 	/* Checking for a possible width argument */
		if (firsdex(letterstr,NUMBERS) == -1) 
		{
		  /* character is not a valid integer, check for */
		  /* function types */
	          if (firsdex(letterstr,VALIDREP) == -1) {
		     (void) printf("Error in backdrop for ");
		     switch (typeof(Aformat->ftype)) {
                       case Klistingheader: 
		         (void) printf("the listing header at ^.\n");
      	 	         break;
      		       case Kstderrnewfile: 
		         (void) printf("the stderr new file header at ^.\n");
		         break;
      		       case Kstderrheader:  
		         (void) printf("the stderror header at ^.\n");
		         break;
      	               case Kfatal:        
		         (void) printf("fatal errors at ^.\n");
		         break;
      		       case Ksevere:     
		         (void) printf("severe errors at ^.\n");
		         break;
      		       case Krecoverable:
		         (void) printf("recoverable errors at ^.\n");
		         break;
      		       case Kwarning:    
		         (void) printf("warnings at ^.\n");
		         break;
      		       case Kextension:  
		         (void) printf("extensions at ^.\n");
		         break;
      		       case Kcomment:     
		         (void) printf("comments at ^.\n");
		         break;
                     }
		     (void) printf("\t%s\n",Aformat->backdrop);

		     (void) printf("\t");
		     i = 0;
 		     while (i < sign-1) { 
		         (void) printf(" ");
			 i++;
		     }
                     (void) printf("^\n");

		     found = TRUE;	
		     break;
                 }      
		 else break;
              }
	   ++lindex;
         }
  }
 
}

void copyAchar(string,letterpt,position)
char string[]; 
char* letterpt;
int position;
{

   *letterpt = string[position];
   return;

}
