/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBtype.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <string.h>
#include "EDB.h"
#include <sys/stat.h>

void EDBtype(arg)
char *arg;
{
  extern errorinfo ErrorInstance;
  extern int errno;
  SEQinfo Sinfo, SETinfo;
  info Ainfo;
  char *p,*rv;
  char farg[MAXLINESIZE], outfile[MAXLINESIZE];
  char temp1[MAXLINESIZE], temp2[MAXLINESIZE];
  struct stat buf;
  FILE *fp;


  /* Use p instead of arg for parsing as the actual pointer is advanced */
  p = arg;

  if(lengthSEQinfo(ErrorInstance->errinfo) == 0) {
	(void) printf("There are no errors to type!\n");
	return;
  }

  rv = oneof(&p,"all fatal severe recoverable warning extension comment","Set?","all",farg);
  if (rv==NULL) return;
  SETinfo = setlevel(farg,ErrorInstance->errinfo);
       
   if (emptySEQinfo(SETinfo)) {
	(void) printf("Empty set.  No errors to type.\n");
	return;
   }


  /* getting output file */
  rv = strarg(&p, " \n","Type to?",". for terminal",outfile);
  if (rv == NULL) return;

  fp = stderr;

  if (!strequal(outfile,".") && !strequal(outfile,". for terminal")) {
  /* See if the file already exists */
  if (stat(outfile, &buf) == -1) {
    /* An error was found in checking outfile */
    if (errno != ENOENT) {
      /* Error was not "no such file" */
      perror(outfile);
      (void) printf("Type command ignored.\n");
      return;
     }
    else {
      /* Error was no such file, go ahead and open it */
      fp = fopen(outfile, "w");
      if (fp == NULL) {
        perror(outfile);
        (void) printf("Type command ignored.\n");
        return;
      }
    }
  }
  else {
    /* No error asking for status of file, must already exist */
    (void) strcpy(temp1,outfile);
    (void) strcat(temp1, " already exists. Overwrite (y/n)?");
    rv =  strarg(&p," \n", temp1, "no",temp2);
    if ( (temp2[0] == 'y') || (temp2[0] == 'Y') ) {
      /* Go ahead and overwrite */
      fp = fopen(outfile, "w");
      if (fp == NULL) {
        perror(outfile);
        (void) printf("Type command ignored.\n");
        return;
      }
    }
    else {
        /* Don't overwrite, ignore write command */
      (void) printf("Type command ignored.\n");
      return;
      }
  }} /* checking outfile is not stderr */


  /* Print out each structure in the set */
  foreachinSEQinfo(SETinfo,Sinfo,Ainfo) {
      /* print out the new error structure */
       display(fp, Ainfo);
  }
  (void) fprintf(fp,"\n");

  if (!strequal(outfile,".") && !strequal(outfile,". for terminal")) {
     (void) printf("%s written.\n",outfile);
     (void) fclose(fp);
  }

}
