/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBrestore.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"

Boolean infocompare();

void EDBrestore(arg)
char *arg;
{
  extern errorinfo ErrorInstance;
  extern int MinErrorNum,MaxErrorNum;
  extern SEQinfo DelSeq;
  extern modified;
  
  SEQinfo Sinfo;
  info Ainfo, Binfo;
  char *p, *rv, buffer[MAXLINESIZE];
  int num, minerror, maxerror;
  Boolean (*cfptr)();

  /* Use p not arg for parsing as actual ptr is advanced */
  p = arg;

  if (lengthSEQinfo(DelSeq) == 0) {
    (void) printf("There are no errors to restore!\n");
    return;
  }

  retrievefirstSEQinfo(DelSeq,Ainfo);
  minerror = Ainfo->number;
  retrievelastSEQinfo(DelSeq,Ainfo);
  maxerror = Ainfo->number;
  num = intarg(&p," \n","Enter number of error to restore: ",minerror,maxerror,0);

  if (minerror > num) {
    (void) printf("%d is less than the lowest numbered error (%d) \n",
       num,minerror);
    return;
  }

  if (maxerror < num) {
    (void) printf("%d is greater than the highest numbered error (%d) \n",
       num,maxerror);
    return;
  }

  foreachinSEQinfo(DelSeq,Sinfo,Ainfo) {
    if (Ainfo->number == num) break;
    else if (Ainfo->number > num) {
      (void) printf("%d does not exist!\n",num);
      return;
    }
  }

  foreachinSEQinfo(ErrorInstance->errinfo,Sinfo,Binfo) {
    if (Binfo->number == num) {
       (void) printf("An error with the same number (%d) already exists.\n",
          num);
       (void) printf("Change error number.  Command ignored. \n");
       return;
    }
    else if (Binfo->number > num) 
       break;
  }
  
  /* print out the new error structure */
  display(stderr,Ainfo);

  while (1) {
    rv = (strarg(&p," \n","Really restore? (yes/no)","yes",buffer));
    if (rv==NULL) return;
    if (!strcmp(rv,"yes")) break;
    else if (!strcmp(rv,"no")) return;
    else (void) printf("Please answer with yes or no\n");
  }
  
  cfptr = infocompare;
  orderedinsertSEQinfo(ErrorInstance->errinfo,Ainfo,cfptr);

  removeSEQinfo(DelSeq,Ainfo);

  if (Ainfo->number < MinErrorNum) {
	MinErrorNum = Ainfo->number;
  } else if (Ainfo->number > MaxErrorNum) {
	MaxErrorNum = Ainfo->number;
  }

  /* Structure has been modified.  Turn on swicth */
  modified = 1;
  
}


