/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBread.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <string.h>
#include "EDB.h"
char *strarg();
extern char *EDBDefault;

void EDBread(arg)
char *arg;
{
extern Boolean ReaderOK;
extern char dfile[];
extern errorinfo ErrorInstance;
extern int MinErrorNum, MaxErrorNum, modified;
info Ainfo;
format Aformat;
SEQformat Sformat;
errorinfo tempInstance;
char fname[MAXLINESIZE];
char temp1[MAXLINESIZE], *p, outfile[MAXLINESIZE];
FILE *fp;


/* Use p for parsing as the actual pointer is advanced */
   p = arg;

  (void) strcpy(fname,dfile);
  (void) strcat(fname,".aer");
  (void) strarg(&p," \n","File to read from?", fname ,outfile);
  fp = fopen(outfile, "r");
  if (fp == NULL) {
    perror(outfile);
    (void) printf("Read command ignored.\n");
    return;
  }
  else {
   (void) printf("Reading in a new structure will overwrite the current structure.\n");
   (void) printf("If you want to save it, use the Write command first.\n");
   (void) strarg(&p," \n", "Read anyway (y,n) ?" , "yes",temp1);

   if ( (temp1[0] == 'y') || (temp1[0] == 'Y') ) {
     /* Go ahead and read anyway */
     tempInstance = ErrorInstance;
     ErrorInstance = input(fp);
     (void) fclose(fp);

     if(!ReaderOK) {
        (void) fprintf(stderr,
           "IDL reader error in reading \"%s\" \nRead command ignored.\n",
           outfile);
        ErrorInstance = tempInstance;
        return;
     }

     (void) strcpy(fname,outfile);
     (void) strcpy(dfile,outfile);
     if (strequal(outfile,EDBDefault)) 
	(void) strcpy(dfile,FILENAME);
     else 
        stripsuffix(dfile);

     /* check for duplicate errors and wrong formats */
     check();
     foreachinSEQformat(ErrorInstance->formats,Sformat,Aformat) 
	checkbd(Aformat);

     if (emptySEQinfo(ErrorInstance->errinfo)) {
  	MinErrorNum = 0;
	MaxErrorNum = 0; 
     } else {
     retrievefirstSEQinfo(ErrorInstance->errinfo,Ainfo);
     MinErrorNum = Ainfo->number;
     retrievelastSEQinfo(ErrorInstance->errinfo,Ainfo);
     MaxErrorNum = Ainfo->number;
     }

     modified = 0;
     (void) printf("Read command successful.\n");
     return;
   }
   else {
      /* Don't read, ignore read command */
      (void) printf("Read command ignored.\n");
     return;
   }
  }
}
