/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBprint.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

/* function macros */
Boolean ShouldSwap1();
#define SortByLevel(infoseq) infoseq = (SEQinfo)IDLListSort(infoseq,ShouldSwap1)

/* error writing macros */

void EDBprint(arg)
char *arg;
{
  extern char dfile[];
  extern errorinfo ErrorInstance;
  extern int errno;

  char *p, outfile[MAXLINESIZE], temp1[MAXLINESIZE], temp2[MAXLINESIZE];
  char fname[MAXLINESIZE]; 
  SEQinfo Sinfo;		/* traversal of info sequence */
  info Ainfo;		/* an information instance in seq */
  FILE *fp;
  struct stat buf;

  /* Use p for parsing as the actual pointer is advanced */
  p = arg;
	
  /* What file should we print the current structure to? */
  (void)strcpy(fname,dfile);
  if (strcmp(ErrorInstance->formatter,"rof") == 0) {
   	(void)strcat(fname,".rof");
  }
  else {
	(void)strcat(fname,".tex");
  }
  (void)strarg(&p," \n","Write to?", fname, outfile);

  /* See if the file already exists */
  if (stat(outfile, &buf) == -1) {
    /* An error was found in checking outfile */
    if (errno != ENOENT) {
      /* Error was not "no such file" */
      perror(outfile);
      (void)printf("Print command ignored.\n");
      return;
     }
    else {
      /* Error was no such file, go ahead and open it */
      fp = fopen(outfile, "w");
      if (fp == NULL) {
        perror(outfile);
        (void)printf("Print command ignored.\n");
        return;
      }
    }
  }
  else {
    /* No error asking for status of file, must already exist */
    (void)strcpy(temp1,outfile);
    (void)strcat(temp1, " already exists. Overwrite (y/n)?");
    (void)strarg(&p," \n", temp1, "no",temp2);
    if ( (temp2[0] == 'y') || (temp2[0] == 'Y') ) {
      /* Go ahead and overwrite */
      fp = fopen(outfile, "w");
      if (fp == NULL) {
        perror(outfile);
        (void)printf("Print command ignored.\n");
        return;
      }
    }
    else {
        /* Don't overwrite, ignore print command */
      (void)printf("Print command ignored.\n");
      return;
      }
  }

/* If we reach here, fp should be a pointer to the file to write to */
/* Go ahead and write */

	/* if sortorder = level, sort by level starting at lowest level */
	if (strcmp(ErrorInstance->sortorder,"level") == 0)  {
	    SortByLevel(ErrorInstance->errinfo);
	}

	/* print out each error type */
        if (strcmp(ErrorInstance->formatter,"rof") == 0) {
	foreachinSEQinfo(ErrorInstance->errinfo, Sinfo, Ainfo) {
	    switch (typeof(Ainfo->itype)) {

		case Kfatal: 
		    (void)fprintf(fp, ".ER F ");
		    break;

		case Ksevere: 
		    (void)fprintf(fp, ".ER S ");
		    break;

		case Krecoverable: 
		    (void)fprintf(fp, ".ER R ");
		    break;

		case Kwarning: 
		    (void)fprintf(fp, ".ER W ");
		    break;

		case Kextension: 
		    (void)fprintf(fp, ".ER E ");
		    break;

		case Kcomment: 
		    (void)fprintf(fp, ".ER C ");
		    break;

		default:
		    (void)fprintf(stderr, "Unknown information type ignored.\n");
		    continue;
	    }
	    (void)fprintf(fp, "%d ", Ainfo->number);
	    PrintMessage(fp, Ainfo);
	    (void)fprintf(fp, " \"%s\" \"%s\" \"%s\"\n",
		Ainfo->description, 
		Ainfo->compiler_recovery, 
		Ainfo->user_correction);
	}
        } else {
           (void)fprintf(fp, "\\begin{list}{}{\\setlength{\\leftmargin}{0.5in}}\n");
	   foreachinSEQinfo(ErrorInstance->errinfo, Sinfo, Ainfo) {
/*             (void)fprintf(fp, "{ \\samepage \n");
*/
             (void)fprintf(fp, "\\item[\\bf %d] ",Ainfo->number);
	     PrintMessageTex(fp, Ainfo);
	     switch (typeof(Ainfo->itype)) {

		case Kfatal: 
		    (void)fprintf(fp, "{\\bf Fatal.} ");
		    break;

		case Ksevere: 
		    (void)fprintf(fp, "{\\bf Severe.} ");
		    break;

		case Krecoverable: 
		    (void)fprintf(fp, "{\\bf Recoverable.} ");
		    break;

		case Kwarning: 
		    (void)fprintf(fp, "{\\bf Warning.} ");
		    break;

   		case Kextension:
		    (void)fprintf(fp, "{\\bf Extension.} ");
		    break;
		
		case Kcomment:
		    (void)fprintf(fp, "{\\bf Comment.} ");
		    break;

		default:
		    (void)fprintf(stderr, "Unknown information type ignored.\n");
		    continue;
	     }
	     (void)fprintf(fp, "%s \\\\[1ex] \n",Ainfo->description);
	     (void)fprintf(fp, "{\\it Recovery Action}\\/: %s \\\\[1ex] \n", Ainfo->compiler_recovery);
	     (void)fprintf(fp, "{\\it To correct the error}\\/: %s \\\\[1ex] \n",Ainfo->user_correction);
/*             (void)fprintf(fp, "} \n");
*/
	    }
	   (void)fprintf(fp, "\\end{list} \n");
	}
  (void)printf("%s written.\n",outfile); 
  (void)fclose(fp);
	
  /* sort by error number */
  SortByNumber(ErrorInstance->errinfo);
  return;
}


/* determine if two information instances should be swapped */
/* the instances are sorted starting with the lowest level  */
/* returns TRUE if info2 should be before info1 in seq      */
Boolean ShouldSwap1(info1, info2)
info info1, info2;
{
	if (typeof(info1->itype) == typeof(info2->itype)) {
	    if (info2->number < info1->number)
		return(TRUE);
	    else return(FALSE);
	}

	if (typeof(info2->itype) == Kcomment)
	    return(TRUE);
	
	if ((typeof(info2->itype) == Kextension) && (typeof(info1->itype) != Kcomment))
	    return(TRUE);

	if ((typeof(info2->itype) == Kwarning) && 
	    (!((typeof(info1->itype) == Kcomment) || (typeof(info1->itype) == Kextension))))
	    return(TRUE);

	if ((typeof(info2->itype) == Krecoverable) &&
	    (!((typeof(info1->itype) == Kcomment) || 
	      (typeof(info1->itype) == Kextension) ||
	      (typeof(info1->itype) == Kwarning))))
	    return(TRUE);

	if ((typeof(info2->itype) == Ksevere) && (typeof(info1->itype) == Kfatal))
	    return(TRUE);

	else return(FALSE);
}

PrintMessage(fp, Ainfo)
FILE *fp;
info Ainfo;
{
	int mlen;	/* message length */
	int i;
	String msg;
        char letterstr[2];

	msg = Ainfo->message;
	mlen = strlen(msg);
	(void)fprintf(fp, "\"");
	for (i=0; i<mlen; i++) {
	    if (msg[i] == '%') {
		letterstr[1] = '\0';
		if (i >= mlen-1)
		    (void)fprintf(fp, "\\fR<\\fI?\\fR>\\fB");
	        else {
		    do {
			letterstr[0] = msg[++i]; }
		    while ((i<mlen-1) && (firsdex(letterstr,NUMBERS)!=-1));
	            PrintArgType(fp, msg[i]);
		}
	    }
	    else (void)fprintf(fp, "%c", msg[i]);
	}
	(void)fprintf(fp, "\"");
}
PrintArgType(fp, type)
FILE *fp;
char type;
{
	if (type == '%') {
		(void)fprintf(fp, "%%");
		return;
	}

	(void)fprintf(fp, "\\fR<\\fI");
	switch (type) {
		case 'I':
		    (void)fprintf(fp, "integer");
		    break;
		case 'S':
		    (void)fprintf(fp, "name");
		    break;
		case 'A':
		case 'Q':
		case 'R':
		    (void)fprintf(fp, "line number");
		    break;
		case 'N':
		    (void)fprintf(fp, "filename");
		    break;
		case 'C':
		case 'B':
		    (void)fprintf(fp, "column");
		    break;
		case 'D':
		    (void)fprintf(fp, "date");
		    break;
		case 'E':
		    (void)fprintf(fp, "error number");
		    break;
		case 'W':
		    (void)fprintf(fp, "count in line");
		    break;
		case 'X':
		    (void)fprintf(fp, "count in file");
		    break;
		case 'P':
		    (void)fprintf(fp, "page number");
		    break;
		case 'V':
		    (void)fprintf(fp, "version number");
		    break;
		case 'F':
		    (void)fprintf(fp, "file creation date");
		    break;
		case 'G':
		    (void)fprintf(fp, "file creation time");
		    break;
		case 'T':
		    (void)fprintf(fp, "time");
		    break;
		case 'Y':
		    (void)fprintf(fp, "count of error");
                    break;
		case 'M':
		    (void)fprintf(fp, "message");
		    break;
		default:
		    (void)fprintf(fp, "?");
		    break;
	}
	(void)fprintf(fp, "\\fR>\\fB");
}


PrintMessageTex(fp, Ainfo)
FILE *fp;
info Ainfo;
{
	int mlen;	/* message length */
	int i;
	String msg;
        char letterstr[2];

        (void)fprintf(fp," {\\bf  ");
	msg = Ainfo->message;
	mlen = strlen(msg);
	for (i=0; i<mlen; i++) {
	    if (msg[i] == '%') {
		letterstr[1] = '\0';
		if (i >= mlen-1)
		    (void)fprintf(fp, "{\\it $<$?$>$}");
	        else {
		    do {
			letterstr[0] = msg[++i]; }
		    while ((i<mlen-1) && (firsdex(letterstr,NUMBERS)!=-1));
		    PrintArgTypeTex(fp, msg[i]);
		}
	    }
	    else (void)fprintf(fp, "%c", msg[i]);
	}
	(void)fprintf(fp, "} \\\\[1ex] \n");
}

PrintArgTypeTex(fp, type)
FILE *fp;
char type;
{
	switch (type) {
		case 'I':
		    (void)fprintf(fp, "{\\it $<$integer$>$}");
		    break;
		case 'S':
		    (void)fprintf(fp, "{\\it $<$name$>$}");
		    break;
		case 'A':
		case 'Q':
		case 'R':
		    (void)fprintf(fp, "{\\it $<$line number$>$}");
		    break;
		case 'N':
		    (void)fprintf(fp, "{\\it $<$filename$>$}");
		    break;
		case 'C':
		case 'B':
		    (void)fprintf(fp, "{\\it $<$column$>$}");
		    break;
		case 'D':
		    (void)fprintf(fp, "{\\it $<$date$>$}");
		    break;
		case 'E':
		    (void)fprintf(fp, "{\\it $<$error number$>$}");
		    break;
		case 'W':
		    (void)fprintf(fp, "{\\it $<$count in line$>$}");
		    break;
		case 'X':
		    (void)fprintf(fp, "{\\it $<$count in file$>$}");
		    break;
		case 'P':
		    (void)fprintf(fp, "{\\it $<$page number$>$}");
		    break;
		case 'V':
		    (void)fprintf(fp, "{\\it $<$version number$>$}");
		    break;
		case 'F':
		    (void)fprintf(fp, "{\\it $<$file creation date$>$}");
		    break;
		case 'G':
		    (void)fprintf(fp, "{\\it $<$file creation time$>$}");
		    break;
		case 'T':
		    (void)fprintf(fp, "{\\it $<$time$>$}");
		    break;
		case 'Y':
		    (void)fprintf(fp, "{\\it $<$count of error$>$}");
                    break;
		case 'M':
		    (void)fprintf(fp, "{\\it $<$message$>$}");
		    break;
		case '%':
		    (void)fprintf(fp, "\\%%");
		    break;
		default:
		    (void)fprintf(fp, "{\\it $<$?$>$}");
		    break;
	}
}
