/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBnlist.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <string.h>
#include "EDB.h"
#include <sys/stat.h>

#define LSTLEN	40

void EDBnlist(arg)
char *arg;
{
  extern errorinfo ErrorInstance;
  extern int MaxErrorNum, MinErrorNum;
  extern int errno;
  SEQinfo Sinfo, SETinfo;
  info Ainfo;
  char *p, *rv;
  int i, min, max;
  int mindef, maxdef;
  char outfile[MAXLINESIZE];
  char temp1[MAXLINESIZE], temp2[MAXLINESIZE];
  struct stat buf;
  FILE *fp;


  /* Use p instead of arg for parsing as the actual pointer is advanced */
  p = arg;

  if(lengthSEQinfo(ErrorInstance->errinfo) == 0) {
	(void) printf("There are no errors to list!\n");
	return;
  }


  retrievefirstSEQinfo(ErrorInstance->errinfo,Ainfo);
  mindef = Ainfo->number;
  min = intarg(&p," \n","Enter lowest number error: ",MinErrorNum,MaxErrorNum,mindef);
  if (mindef > min) {
      (void) printf("%d is less than the lowest numbered error (%d) \n",
          min, Ainfo->number);
      return;
   }

  retrievelastSEQinfo(ErrorInstance->errinfo,Ainfo);
  maxdef = Ainfo->number;
  max = intarg(&p," \n","Enter highest number error: ",MinErrorNum,MaxErrorNum,maxdef);
	
  if (maxdef < max) {
     (void) printf("%d is greater than the highest numbered error (%d) \n",
         max, Ainfo->number);
     max = maxdef;
        }

  if (min > max) {
	(void) printf("Range error. Command ignored.\n");
	return;
   }

   SETinfo = setnum(min,max,ErrorInstance->errinfo);

   if (emptySEQinfo(SETinfo)) {
	(void) printf("Empty set.  No errors to list.\n");
	return;
   }

  /* getting output file */
  rv = strarg(&p, "\n","List to?",". for terminal",outfile);
  if (rv == NULL) return;

  fp = stderr;

  if (!strequal(outfile,".") && !strequal(outfile,". for terminal")) {
  /* See if the file already exists */
  if (stat(outfile, &buf) == -1) {
    /* An error was found in checking outfile */
    if (errno != ENOENT) {
      /* Error was not "no such file" */
      perror(outfile);
      (void) printf("List command ignored.\n");
      return;
     }
    else {
      /* Error was no such file, go ahead and open it */
      fp = fopen(outfile, "w");
      if (fp == NULL) {
        perror(outfile);
        (void) printf("List command ignored.\n");
        return;
      }
    }
  }
  else {
    /* No error asking for status of file, must already exist */
    (void) strcpy(temp1,outfile);
    (void) strcat(temp1, " already exists. Overwrite (y/n)?");
    rv =  strarg(&p," \n", temp1, "no",temp2);
    if ( (temp2[0] == 'y') || (temp2[0] == 'Y') ) {
      /* Go ahead and overwrite */
      fp = fopen(outfile, "w");
      if (fp == NULL) {
        perror(outfile);
        (void) printf("List command ignored.\n");
        return;
      }
    }
    else {
        /* Don't overwrite, ignore write command */
      (void) printf("List command ignored.\n");
      return;
      }
  }} /* checking outfile is not stderr */


  (void) fprintf(fp,"\n");
  /* Print out each structure in the error number range */
  foreachinSEQinfo(SETinfo,Sinfo,Ainfo) {
      /* print out the new error structure */
      
       (void) fprintf(fp, "\t%d",Ainfo->number);

       switch (typeof(Ainfo->itype)) {      
         case Kfatal:       { (void) fprintf(fp,"\tfatal");       break;}
         case Ksevere:      { (void) fprintf(fp,"\tsevere");      break;}
         case Krecoverable: { (void) fprintf(fp,"\trecoverable"); break;}
         case Kwarning:     { (void) fprintf(fp,"\twarning");     break;}
         case Kextension:   { (void) fprintf(fp,"\textension");   break;}
         case Kcomment:     { (void) fprintf(fp,"\tcomment");     break;}
       }

       switch (typeof(Ainfo->position)) {      
         case Kcharposition:   { (void) fprintf(fp,"\tcharposition");   break;}
         case Klineposition:   { (void) fprintf(fp,"\tlineposition");   break;}
         case Kendposition:    { (void) fprintf(fp,"\tendposition");    break;}
         case Kstderrposition: { (void) fprintf(fp,"\tstderrposition"); break;}
       }

	if (strlen(Ainfo->message) > LSTLEN) {
	   i = 0;
	   (void) fprintf(fp,"\t");
	   while ((i < LSTLEN - 4) && (Ainfo->message[i] != '\0')) 
		(void) fprintf(fp,"%c",Ainfo->message[i++]);
	   (void) fprintf(fp,"...\n");
	}
	else
         (void) fprintf(fp,"\t%s\n",Ainfo->message);
  }
  (void) fprintf(fp,"\n");

  if (!strequal(outfile,".") && !strequal(outfile,". for terminal")) {
     (void) printf("%s written.\n",outfile);
     (void) fclose(fp);
  }
}
