/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBmain1.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <string.h>
#include "EDB.h"
  
/* this is to include the declarations of all the procedures used by the ci */
#include "CIproc.h"
extern char *EDBDefault, *EDBHelpDir;

/* Ci variables, must be global for the ci routine */
CIENTRY list[] =
{
  CIPROC("version",EDBversion),
  CIPROC("comment",EDBcomment),
  CIPROC("time",EDBtime),
  CIPROC("date",EDBdate),
  CIPROC("formatter",EDBformatter),
  CIPROC("sortorder",EDBsortorder),
  CICMD("quit",EDBquit),
  CICMD("write",EDBwrite),
  CICMD("read",EDBread),
  CICMD("create",EDBcreate),
  CICMD("list",EDBlist),
  CICMD("nlist",EDBnlist),
  CICMD("edit",EDBedit),
  CICMD("delete",EDBdelete),
  CICMD("formats",EDBformats),
  CICMD("change",EDBchange),
  CICMD("print",EDBprint),
  CICMD("extract",EDBextract),
  CICMD("type",EDBtype),
  CICMD("ntype",EDBntype),
  CICMD("append",EDBappend),
  CICMD("restore",EDBrestore),
  CICMD("howmany",EDBhowmany),
  CIEND 
};


/* This will be the errorinfo structure modified by the procedures */
errorinfo ErrorInstance; 
SEQinfo DelSeq;
int MaxErrorNum=0, MinErrorNum=0;
int modified=0;
char dfile[];

void exit();
void usage(), revision_number();
extern void ci();
extern Boolean ReaderOK;

main1(argc, argv) 
int argc;
char *argv[];
{
info Ainfo;
format Aformat;
SEQformat Sformat;

FILE *inputfp; 

/* initiliaze list of deleted errors */
initializeSEQinfo(DelSeq);


switch (argc) {
 case 1:
  /* No file name given as input param. */
  (void) fprintf(stderr,
     "\n\t*** ErrorDB Version 1.0 Copyright 1988 UNC-CH ***\n\n");
  (void) fprintf(stderr,"No input file, using %s\n",EDBDefault);
  (void) fprintf(stderr,"Type ? for help, ?commands for command list, ?variables for variable list\n");
  (void) strcpy(dfile, FILENAME);
  inputfp = fopen(EDBDefault,"r");
  if (inputfp == NULL) {
    perror(EDBDefault);
    exit(-1);
  }
  ErrorInstance = input(inputfp);
  if (!ReaderOK) {
    (void) fprintf(stderr,
       "IDL reader error in reading \"%s\".\nAborting program.\n", EDBDefault);
    exit(-1);
  }
  break;
 case 2:
  if (!strcmp(argv[1], "-V")) {
	revision_number(argv[0]);
	exit(0);
  }
  (void) fprintf(stderr,
     "\n\t*** ErrorDB Version 1.0 Copyright 1988 UNC-CH ***\n\n");
  (void) strcpy(dfile,argv[1]);
  inputfp = fopen(argv[1],"r");
  if (inputfp == NULL) {
    perror(argv[1]);
    exit(-1);
  }
  ErrorInstance = input(inputfp);
  stripsuffix(dfile);
  if (!ReaderOK) {
    (void) fprintf(stderr,
       "IDL reader error in reading \"%s\" \nAborting program.\n",argv[1]);
    exit(-1);
  }
  (void) fprintf(stderr,"Input file: %s. Read.\n",argv[1]);
  (void) fprintf(stderr, "Type ? for help, ?commands for command list, ?variables for variable list\n");

  /* check or duplicate error numbers and wrong formats */
  check(); 
  foreachinSEQformat(ErrorInstance->formats,Sformat,Aformat) 
      checkbd(Aformat);

  if (! emptySEQinfo(ErrorInstance->errinfo)){
	retrievefirstSEQinfo(ErrorInstance->errinfo,Ainfo);
	MinErrorNum = Ainfo->number;
	retrievelastSEQinfo(ErrorInstance->errinfo,Ainfo);
	MaxErrorNum = Ainfo->number;
  }

  break;
 case 3:
 default:
  (void) fprintf(stderr,"Usage: errordb [filename.aer] \n",argv[0]);
  exit(-1);
}
(void) fclose(inputfp);

(void) printf("\n\t Comment = \t%s\n",ErrorInstance->comment);
(void) printf("\t Version = \t%s\n\n",ErrorInstance->version);

initializeSEQinfo(DelSeq);

/* Send control off to interpreter */
ci(EDBPROMPT,(FILE *)NULL,0,list,EDBHelpDir,(char *)NULL);

/* If structure has been modified grab ^D or quit command */

(void) printf("Good bye\n");
}


void usage(name)
char *name;
{
 (void)fprintf(stderr,"usage: %s [sourcefile]\n",name);
}


void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)sscanf("$Revision: 5.0 $","%*s %s",revision_str);
 (void)printf("%s: Error database manager Version %s\n",name,revision_str);
 usage(name);
}


