/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBformatter.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"

void EDBformatter(mode,arg)
CIMODE mode;
char *arg;
{
extern errorinfo ErrorInstance;
extern int modified;
char str[MAXLINESIZE], c;
int i;

switch(mode) {
 case CISET:
  if (strlen(arg) != 0 ) {
    if ((strcmp(arg,"rof")==0) || (strcmp(arg,"latex")==0)) {
    	ErrorInstance->formatter = NewString(arg);
	modified = 1;
    }
    else {
	(void) printf("Only rof and latex implemented.  Statement ignored.\n");
    }
  }
  else {
    (void) printf("Enter name of formatter: ");
  
    i=0;
    while ((c = getchar()) != '\n') {
      str[i++] = c;
    }
    str[i] = '\0';
    if ((strcmp(arg,"rof")==0) || (strcmp(arg,"latex")==0)) {
    	ErrorInstance->formatter = NewString(str);
	modified = 1;
    }
    else {
	(void) printf("Only rof and latex implemented.  Statement ignored.\n");
    }
  }
 case CISHOW:
 case CIPEEK:
  (void) printf("Formatter: \"%s\"\n",ErrorInstance->formatter);
}
}  

