/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBformats.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"

/*ARGSUSED*/
void EDBformats(arg)
char *arg;
{
  extern errorinfo ErrorInstance;
  format Aformat;
  SEQformat Sformat;
  
  (void) printf("\nHEADER FORMATS:\n");
  foreachinSEQformat(ErrorInstance->formats,Sformat,Aformat) {
/* if (typeof(Aformat->ftype) == Kheader_type) */
    switch (typeof(Aformat->ftype)) {
      case Klistingheader: (void) printf("\tListing header\n\t\t\"%s\"\n",
                             Aformat->backdrop);   
                           break;
      case Kstderrnewfile: (void) printf("\tNew stderrorfile\n\t\t\"%s\"\n",
                             Aformat->backdrop); 
                           break;
      case Kstderrheader:  (void) printf("\tStderror header\n\t\t\"%s\"\n",
                             Aformat->backdrop);  
                           break;
      case Kfatal:        
      case Ksevere:     
      case Krecoverable:
      case Kwarning:    
      case Kextension:  
      case Kcomment:      break;
   }
  }

  (void) printf("ERROR FORMATS:\n");
  foreachinSEQformat(ErrorInstance->formats,Sformat,Aformat) {
    switch (typeof(Aformat->ftype.Verror_type)) {
      case Kfatal:        (void) printf("\tFatal:\n\t\t\"%s\"\n",
                            Aformat->backdrop);        
                          break;
      case Ksevere:       (void) printf("\tSevere:\n\t\t\"%s\"\n",
                            Aformat->backdrop); 
                          break;
      case Krecoverable:  (void) printf("\tRecoverable:\n\t\t\"%s\"\n",
                            Aformat->backdrop);  
                          break;
      case Kwarning:      (void) printf("\tWarning:\n\t\t\"%s\"\n",
                            Aformat->backdrop); 
                          break;
      case Kextension:    (void) printf("\tExtension:\n\t\t\"%s\"\n",
                            Aformat->backdrop); 
                          break;
      case Kcomment:      (void) printf("\tComment:\n\t\t\"%s\"\n",
                            Aformat->backdrop);
                          break;
      case Klistingheader: 
      case Kstderrnewfile: 
      case Kstderrheader:  break;
    }
  }
}
