/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBextract.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>

void EDBextract(arg)
char *arg;
{
  extern char dfile[];
  extern errorinfo ErrorInstance;
  extern int errno;

  char *p;
  char outfile[MAXLINESIZE];
  char fname[MAXLINESIZE], temp1[MAXLINESIZE], temp2[MAXLINESIZE];
  struct stat buf;
  FILE *fp;

  /* Use p for parsing as the actual pointer is advanced */
  p = arg;
	
  /* What file should we extract the current structure to? */
  (void) strcpy(fname,dfile);
  (void) strcat(fname,".eis");
  (void) strarg(&p," \n","Write to?", fname, outfile);

  /* See if the file already exists */
  if (stat(outfile, &buf) == -1) {
    /* An error was found in checking outfile */
    if (errno != ENOENT) {
      /* Error was not "no such file" */
      perror(outfile);
      (void) printf("Extract command ignored.\n");
      return;
     }
    else {
      /* Error was no such file, go ahead and open it */
      fp = fopen(outfile, "w");
      if (fp == NULL) {
        perror(outfile);
        (void) printf("Extract command ignored.\n");
        return;
      }
    }
  }
  else {
    /* No error asking for status of file, must already exist */
    (void) strcpy(temp1,outfile);
    (void) strcat(temp1, " already exists. Overwrite (y/n)?");
    (void) strarg(&p," \n", temp1, "no",temp2);
    if ( (temp2[0] == 'y') || (temp2[0] == 'Y') ) {
      /* Go ahead and overwrite */
      fp = fopen(outfile, "w");
      if (fp == NULL) {
        perror(outfile);
        (void) printf("Extract command ignored.\n");
        return;
      }
    }
    else {
        /* Don't overwrite, ignore write command */
      (void) printf("Extract command ignored.\n");
      return;
      }
  }

/* If we reach here, fp should be a pointer to the file to write to */
/* Go ahead and write */

  OUTerrinfo(fp, ErrorInstance, TWOPASS);
  (void) printf("%s written.\n",outfile);
  (void) fclose(fp);
  return;

}



