/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBedit.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <string.h>
#include "EDB.h"

Boolean infocompare();

void EDBedit(arg)
char *arg;
{
  extern errorinfo ErrorInstance;
  extern int MinErrorNum,MaxErrorNum;
  extern modified;
  Boolean (*cfptr)();
  SEQinfo Sinfo;
  info Ainfo, Binfo;
  static int num = 0;
  char position[MAXLINESIZE];
  char type[MAXLINESIZE], buffer[MAXLINESIZE];
  char *p, *rv;
  boolean valid;

  /* Use p not arg for parsing as ptr is advanced. */
  p = arg;

  if (lengthSEQinfo(ErrorInstance->errinfo) == 0) {
	(void) printf("There are no errors to edit!\n");
	return;
  }

  
  num = intarg(&p," \n","Enter number of error to edit: ",MinErrorNum,MaxErrorNum,num);
  retrievefirstSEQinfo(ErrorInstance->errinfo,Ainfo);
  if (Ainfo->number > num) {
    (void) printf("%d is less than the lowest numbered error (%d) \n",
      num, Ainfo->number);
    return;
  }
  retrievelastSEQinfo(ErrorInstance->errinfo,Ainfo);
  if (Ainfo->number < num) {
    (void) printf("%d is greater than the highest numbered error (%d) \n",
      num, Ainfo->number);
    return;
  }


  foreachinSEQinfo(ErrorInstance->errinfo,Sinfo,Ainfo) {
    if (Ainfo->number == num) break;
    else if (Ainfo->number > num) {
      (void) printf("%d does not exist!\n",num);
      return;
    }
  }


  num = intarg(&p," \n","Error number",MINERRORNUM,MAXERRORNUM,Ainfo->number);
  if (Ainfo->number!=num) {
    /* Set to something other than 'o' . See if stmt following do loop */
    buffer[0] = 'n';
    do {
      valid = TRUE;
      /* Make sure that the number is not already in the sequence */
      foreachinSEQinfo(ErrorInstance->errinfo,Sinfo,Binfo) {
	/* If we went past the number we are o.k., break out of for loop(==>break from do) */
	if (Binfo->number > num) break;
	
	/* elseif The number already exists. */
	else if (Binfo->number== num) {
	  (void) printf("An error already exists with this number.\n");
	  rv = oneof(&p,"overwrite abort newnumber",
		     "Overwrite anyway, Abort newerror, or Newnumber?","overwrite",buffer);
	  if (rv==NULL)  return;
	  switch (buffer[0]) {
	  case 'o': 
	    /* Add anyway so break do loop with valid. */
	    
	    valid = TRUE; 
	    break;
	  case 'a': 
	    /* Stop the newerror routine, so return */
	    return;
	  case 'n': 
	    /* Else get the next try for an error number, don't break do */
	    num = intarg(&p," \n","number?",MINERRORNUM,MAXERRORNUM,MaxErrorNum+1);
	    valid = FALSE;
	  }
	  /* Since equal, break from for loop no matter what user chose. */
	  break;
	}
	
	/* else keep looping until we pass or find the current error number */
      }
    } while(!(valid));

    if (buffer[0] == 'o') {
      /* Not allowed to remove or insert inside foreachinSEQ loop, so do it here */
      removeSEQinfo(ErrorInstance->errinfo,Binfo);
    }

    /* Now num is the right number to put in the number field */
    removeSEQinfo(ErrorInstance->errinfo,Ainfo);
    Ainfo->number = num;
    cfptr = infocompare;
    orderedinsertSEQinfo(ErrorInstance->errinfo,Ainfo,cfptr);
  }
 
  /* Now get the type */
  switch (typeof(Ainfo->itype)) {
      case Kfatal:        (void) strcpy(type,"fatal");       break;
      case Ksevere:       (void) strcpy(type,"severe");      break;
      case Krecoverable:  (void) strcpy(type,"recoverable"); break;
      case Kwarning:      (void) strcpy(type,"warning");     break;
      case Kextension:    (void) strcpy(type,"extension");   break;
      case Kcomment:      (void) strcpy(type,"comment");     break;
  }
  rv = oneof(&p,"fatal severe recoverable warning extension comment",
		 "Error type?",type,buffer);
  if (rv==NULL) return;
  switch (buffer[0]) {
     case 'f':   Ainfo->itype.Vfatal = Nfatal;             break;
     case 's':   Ainfo->itype.Vsevere = Nsevere;           break;
     case 'r':   Ainfo->itype.Vrecoverable = Nrecoverable; break;
     case 'w':   Ainfo->itype.Vwarning = Nwarning;         break;
     case 'e':   Ainfo->itype.Vextension = Nextension;     break;
     case 'c':   Ainfo->itype.Vcomment = Ncomment;         break;
  }  
 
  /* Now the position */
  switch (typeof(Ainfo->position)) {
    case Kcharposition:   (void) strcpy(position,"charposition");   break;
    case Klineposition:   (void) strcpy(position,"lineposition");   break;
    case Kendposition:    (void) strcpy(position,"endposition");    break;
    case Kstderrposition: (void) strcpy(position,"stderrposition"); break;
  }
  rv = oneof(&p,"charposition lineposition endposition stderrposition",
		 "Error position",position,buffer);
  if (rv==NULL)  return;
  switch (buffer[0]) {
    case 'c':   Ainfo->position.Vcharposition = Ncharposition;      break;
    case 'l':   Ainfo->position.Vlineposition = Nlineposition;      break;
    case 'e':   Ainfo->position.Vendposition = Nendposition;        break;
    case 's':   Ainfo->position.Vstderrposition = Nstderrposition;  break;
  }


  /* Get message, description, compiler_recovery, user_correction */
  rv = (strarg(&p," \n","Message?",Ainfo->message,buffer));
  if (rv==NULL) return;
  else Ainfo->message = NewString(rv);
  rv = (strarg(&p," \n","Description?",Ainfo->description,buffer));
  if (rv==NULL) return;
  else Ainfo->description = NewString(rv);
  rv = (strarg(&p," \n","Recovery?",Ainfo->compiler_recovery,buffer));
  if (rv==NULL) return;
  else  Ainfo->compiler_recovery = NewString(rv);
  rv = (strarg(&p," \n","User correction?",Ainfo->user_correction,buffer));
  if (rv==NULL) return;
  else  Ainfo->user_correction = NewString(rv);

  /* Display edited error */
  (void) printf("\nThe edited error looks now like this:\n");
  display(stderr,Ainfo);

  if (Ainfo->number > MaxErrorNum) 
	MaxErrorNum = Ainfo->number;
  else if (Ainfo->number < MinErrorNum) 
	MinErrorNum = Ainfo->number;
 
  modified = 1;

}


