/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBdelete.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"

Boolean infocompare();

void EDBdelete(arg)
char *arg;
{
  extern errorinfo ErrorInstance;
  extern int MinErrorNum,MaxErrorNum;
  extern SEQinfo DelSeq;
  extern int modified;
  SEQinfo Sinfo, SinfoDS;
  info Ainfo, Binfo;
  char *p, *rv, buffer[MAXLINESIZE];
  int num;
  Boolean (*cfptr)();

  /* Use p not arg for parsing as actual ptr is advanced */
  p = arg;

  if (lengthSEQinfo(ErrorInstance->errinfo) == 0) {
    (void) printf("There are no errors to delete!\n");
    return;
  }

  num = intarg(&p," \n","Enter number of error to delete: ",MinErrorNum,MaxErrorNum,MaxErrorNum);

  retrievefirstSEQinfo(ErrorInstance->errinfo,Ainfo);
  if (Ainfo->number > num) {
    (void) printf("%d is less than the lowest numbered error (%d) \n",
      num,Ainfo->number);
    return;
  }

  retrievelastSEQinfo(ErrorInstance->errinfo,Ainfo);
  if (Ainfo->number < num) {
    (void) printf("%d is greater than the highest numbered error (%d) \n",
      num,Ainfo->number);
    return;
  }

  foreachinSEQinfo(ErrorInstance->errinfo,Sinfo,Ainfo) {
    if (Ainfo->number == num) break;
    else if (Ainfo->number > num) {
      (void) printf("%d does not exist!\n",num);
      return;
    }
  }

  /* print out the error structure */
  display(stderr,Ainfo);

  while (1) {
    rv = (strarg(&p," \n","Really delete? (yes/no)","yes",buffer));
    if (rv==NULL) return;
    if (!strcmp(rv,"yes")) break;
    else if (!strcmp(rv,"no")) return;
    else (void) printf("Please answer with yes or no\n");
  }
  
  if (!(emptySEQinfo(DelSeq))) {
  
      foreachinSEQinfo(DelSeq,SinfoDS,Binfo) {
         if (Binfo->number == num)  
          break; 
      else if (Binfo->number > num) 
         break;
      }

      if (Binfo->number == num)
         removeSEQinfo(DelSeq,Binfo);
  }

  cfptr = infocompare; 
  orderedinsertSEQinfo(DelSeq,Ainfo,cfptr);

  removeSEQinfo(ErrorInstance->errinfo,Ainfo);

  if (!(emptySEQinfo(ErrorInstance->errinfo))) {
  if (Ainfo->number == MinErrorNum) {
	retrievefirstSEQinfo(ErrorInstance->errinfo,Binfo);
	MinErrorNum = Binfo->number;
  } else if (Ainfo->number == MaxErrorNum) {
	retrievelastSEQinfo(ErrorInstance->errinfo,Binfo);
	MaxErrorNum = Binfo->number;
  }
  else {
       MinErrorNum = 0;
       MaxErrorNum = 0;}
  }
  /* structure has been modified.  Turn switch on */
  modified = 1;

}


