/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBcreate.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"

Boolean infocompare();

void EDBcreate(arg)
char *arg;
{
  extern errorinfo ErrorInstance;
  extern int MaxErrorNum, MinErrorNum;
  extern modified;
  int num; 
  Boolean (*cfptr)();
  info thisinfo, Ainfo;
  SEQinfo Sinfo;
  boolean valid;
  char *p, *rv;
  char type[MAXLINESIZE], position[MAXLINESIZE], buffer[MAXLINESIZE];
  
  /* Use p instead of arg for parsing as the actual pointer is advanced */
  p = arg;
  
  thisinfo = Ninfo;

  num = 0;
  if(lengthSEQinfo(ErrorInstance->errinfo) != 0) {
     retrievelastSEQinfo(ErrorInstance->errinfo, Ainfo);
     num = (Ainfo->number) + 1;
  }

  /* Get the number of the error */
  thisinfo->number = intarg(&p," \n","Error number?",MINERRORNUM,MAXERRORNUM,num);
  do {
    valid = TRUE;
    /* Make sure that the number is not already in the sequence */
    foreachinSEQinfo(ErrorInstance->errinfo,Sinfo,Ainfo) {
      /* If we went past the number we are o.k., break out of for loop(==>break from do) */
      if (Ainfo->number > thisinfo->number) break;

      /* elseif The number already exists. */
      else if (Ainfo->number==thisinfo->number) {
	(void) printf("An error already exists with this number.\n");
	rv = oneof(&p,"overwrite stop newnumber",
		   "Overwrite anyway, Stop command, or Newnumber?","overwrite",buffer);
	if (rv==NULL)  return;
	switch (buffer[0]) {
	  case 'o': 
	    /* Add anyway so break do loop with valid. */
	    valid = TRUE; 
	    break;
	  case 's': 
	    /* Stop the newerror routine, so return */
	    return;
	  case 'n': 
	    /* Else get the next try for an error number, don't break do */
	    thisinfo->number = intarg(&p," \n","number?",MINERRORNUM,MAXERRORNUM,MaxErrorNum+1);
	    valid = FALSE;
        }
	/* Since equal, break from for loop no matter what user chose. */
	break;
      }

      /* else keep looping until we pass or find the current error number */
    }
  } while(!(valid));

  if (buffer[0] == 'o') {
    /* Not allowed to remove or insert inside foreachinSEQ loop, so do it here */
    removeSEQinfo(ErrorInstance->errinfo,Ainfo);
  }
  
  /* Get the type of the error */
  rv = oneof(&p,"fatal severe recoverable warning extension comment",
	     "Type of error?","fatal",type);
  if (rv==NULL)  return;
  /* Set the itype field of the current errorinstance to the input type */
  switch (type[0]) {
  case 'f':   thisinfo->itype.Vfatal = Nfatal;             break;
  case 's':   thisinfo->itype.Vsevere = Nsevere;           break;
  case 'r':   thisinfo->itype.Vrecoverable = Nrecoverable; break;
  case 'w':   thisinfo->itype.Vwarning = Nwarning;         break;
  case 'e':   thisinfo->itype.Vextension = Nextension;     break;
  case 'c':   thisinfo->itype.Vcomment = Ncomment;         break;
  }
  

  /* Get the positiontype of the error */
  rv = oneof(&p,"charposition lineposition endposition stderrposition",
	     "Position of error?","charposition",position);
  if (rv==NULL)   return;
  switch (position[0]) {
  case 'c':   thisinfo->position.Vcharposition = Ncharposition;      break;
  case 'l':   thisinfo->position.Vlineposition = Nlineposition;      break;
  case 'e':   thisinfo->position.Vendposition = Nendposition;        break;
  case 's':   thisinfo->position.Vstderrposition = Nstderrposition;  break;
  }
  



  /* Get message, description, compiler_recovery, user_correction */
  rv = (strarg(&p," \n","Message?","None",buffer));
  if (rv==NULL) return;
  else thisinfo->message = NewString(rv);
  rv = (strarg(&p," \n","Description?","None",buffer));
  if (rv==NULL) return;
  else thisinfo->description = NewString(rv);
  rv = (strarg(&p," \n","Recovery?","None",buffer));
  if (rv==NULL) return;
  else  thisinfo->compiler_recovery = NewString(rv);
  rv = (strarg(&p," \n","User correction?","None",buffer));
  if (rv==NULL) return;
  else thisinfo->user_correction = NewString(rv);
  
  /* print out the new error structure */
  (void) printf("This is the new error: \n\n");
  display(stderr,thisinfo);

  if (thisinfo->number > MaxErrorNum)
	MaxErrorNum = thisinfo->number;
  else if (thisinfo->number < MinErrorNum)
	   MinErrorNum = thisinfo->number;

  
  /* Add to sequence of errors */
  cfptr = infocompare;
  orderedinsertSEQinfo(ErrorInstance->errinfo,thisinfo,cfptr);
  modified = 1;
}

