/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBchange.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "EDB.h"

Boolean formatcompare();

void EDBchange(arg)
char *arg;

{
  extern errorinfo ErrorInstance;
  extern int modified;
  char *p, *rv, buffer[MAXLINESIZE];
  int field;
  Boolean (*cfptr)();
  format Aformat, thisformat;
  SEQformat Sformat;

  /* use p not arg for parsing as actual prt is advanced */
  p = arg;

  rv = oneof(&p,"header error","Change header or error?","error",buffer);
  if (rv==NULL) return;

  if (buffer[0]=='h') {
    rv = oneof(&p,"listingheader stderrnewfile stderrheader",
	       "Change what kind of header?","listingheader",buffer);
    if (rv==NULL) return;
    thisformat = Nformat;
    switch (buffer[6]) {
    case 'g': 
      (void) printf("Enter new backdrop for listingheaders\n");
      thisformat->ftype.Vlistingheader = Nlistingheader;
      field = Klistingheader;
      break;
    case 'n':
      (void) printf("Enter new backdrop for stderrnewfile\n");
      thisformat->ftype.Vstderrnewfile = Nstderrnewfile;
      field = Kstderrnewfile;
      break;
    case 'h':
      (void) printf("Enter new backdrop for stderrheader\n");
      thisformat->ftype.Vstderrheader = Nstderrheader;
      field = Kstderrheader;
      break;
    }
  }
  else {
    rv = oneof(&p,"fatal severe recoverable warning extension comment",
	       "Change what kind of error message?","fatal",buffer);
    if (rv==NULL) return;
    thisformat = Nformat;
    switch (buffer[0]) {
    case 'f': 
      (void) printf("Enter new backdrop for fatal errors\n");
      thisformat->ftype.Vfatal = Nfatal;
      field = Kfatal;
      break;
    case 's':
      (void) printf("Enter new backdrop for severe errors\n");
      thisformat->ftype.Vsevere = Nsevere;
      field = Ksevere;
      break;
    case 'r':
      (void) printf("Enter new backdrop for recoverable errors\n");
      thisformat->ftype.Vrecoverable = Nrecoverable;
      field = Krecoverable;
      break;
    case 'w':
      (void) printf("Enter new backdrop for warning errors\n");
      thisformat->ftype.Vwarning = Nwarning;
      field = Kwarning;
      break;
    case 'e':
      (void) printf("Enter new backdrop for extension errors\n");
      thisformat->ftype.Vextension = Nextension;
      field = Kextension;
      break;
    case 'c':
      (void) printf("Enter new backdrop for comment errors\n");
      thisformat->ftype.Vcomment = Ncomment;
      field = Kcomment;
      break;
    }
  }

  
  /* Find the node that is being replaced */
  foreachinSEQformat(ErrorInstance->formats,Sformat,Aformat) {
    if (typeof(Aformat->ftype)==field) break;
  }

  /* Default backdrop is the one in the node being replaced */
  rv = strarg(&p," \n","Backdrop?",Aformat->backdrop,buffer);  
  if (rv==NULL) return;
  thisformat->backdrop = NewString(rv);

  removeSEQformat(ErrorInstance->formats,Aformat);
  cfptr = formatcompare;
  orderedinsertSEQformat(ErrorInstance->formats,thisformat,cfptr);

  /* check for wrong formats */
  checkbd(thisformat); 

  modified = 1;
}    
