/***********************************************************************\ 
*									* 
*   File: scorpion/src/errordb/EDBappend.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <string.h>
#include "EDB.h"

Boolean infocompare();

void EDBappend(arg)
char *arg;
{
extern char dfile[];
extern errorinfo ErrorInstance;
extern Boolean ReaderOK;
extern int MinErrorNum, MaxErrorNum;
extern int modified;
errorinfo NewErrors;
SEQinfo Sinfo, SinfoNEW, SETinfo;
info Ainfo, AinfoNEW;
char fname[MAXLINESIZE], temp1[MAXLINESIZE], *p, *rv;
char outfile[MAXLINESIZE], farg[MAXLINESIZE];
FILE *fp;
Boolean (*cfptr)();
int min, max, maxerror;


/* Use p for parsing as the actual pointer is advanced */
   p = arg;

  (void) strcpy(fname,dfile);
  (void) strcat(fname,".aer");
  rv = strarg(&p," \n","File to append from?", fname ,outfile);
  fp = fopen(outfile, "r");
  if (fp == NULL) {
    perror(outfile);
    (void) printf("Append command ignored.\n");
    return;
  }
  else {
   (void) printf("Appending from a file will alter the current structure.\n");
   (void) printf("If you want to save it, use the Write command first.\n");
   rv =  strarg(&p," \n", "Append anyway (y,n) ?" , "yes",temp1);

   if ( (temp1[0] == 'y') || (temp1[0] == 'Y') ) {
     /* Go ahead and read anyway */
     NewErrors = input(fp);
     (void) fclose(fp);

     if(!ReaderOK) {
        (void) fprintf(stderr,
           "IDL reader error in reading \"%s\" \nAppend command ignored.\n",
           outfile);
        return;
     }
     /* Sort newly read structure */
     SortByNumber(NewErrors->errinfo);

     rv = strarg(&p,"\n","Enter Set Definition or Error Number?","all",farg);
     if (rv==NULL) return;

     if (strcmp(farg,"all") == 0) {
        SETinfo = NewErrors->errinfo;}
     else if (aredigits(farg))  {
        (void) printf("\n");
	min = atoi(farg);
  	retrievefirstSEQinfo(NewErrors->errinfo,Ainfo);
  	if (Ainfo->number > min) {
    	   (void) printf("%d is less than the lowest numbered error (%d) \n",
              min,Ainfo->number);
    	   return;
        }
	retrievelastSEQinfo(NewErrors->errinfo,Ainfo);
	maxerror = Ainfo->number;

  	max = intarg(&p," \n","Enter highest number error: ",min,maxerror,min);
	
  	if (maxerror < max) {
    	   (void) printf("%d is greater than the highest numbered error (%d) \n",max,Ainfo->number);
	   max = Ainfo->number;
        }
  	(void) printf("\n");

  	if (min > max) {
		(void) printf("Range error. Command ignored.\n");
		return;
	}

	SETinfo = setnum(min,max,NewErrors->errinfo);
	}
      else if ((strcmp(farg,"fatal")==0) || (strcmp(farg,"severe")==0) ||
   	(strcmp(farg,"recoverable")==0) || (strcmp(farg,"extension")==0) ||
   	(strcmp(farg,"comment")==0) || (strcmp(farg,"warning")==0)) {
		SETinfo = setlevel(farg,NewErrors->errinfo);
        }
      else {
         (void) printf("Incorrect argument in command line.\n");
         return;
      }
       
      if (emptySEQinfo(SETinfo)) {
	(void) printf("Empty set.  No errors to append.\n");
	return;
      }


     foreachinSEQinfo(SETinfo,SinfoNEW,AinfoNEW) {
	foreachinSEQinfo(ErrorInstance->errinfo,Sinfo,Ainfo) {
	   if (Ainfo->number == AinfoNEW->number){
		(void) fprintf(stderr,"Duplicate error number %d (ignored).\n",
                   Ainfo->number);
                break;
	   }
	   else if (Ainfo->number >  AinfoNEW->number) break;
	}

     if (Ainfo->number != AinfoNEW->number) {	
	cfptr = infocompare;
	orderedinsertSEQinfo(ErrorInstance->errinfo,AinfoNEW,cfptr);
	}
     }

     retrievefirstSEQinfo(ErrorInstance->errinfo,Ainfo);
     MinErrorNum = Ainfo->number;
     retrievelastSEQinfo(ErrorInstance->errinfo,Ainfo);
     MaxErrorNum = Ainfo->number;

     modified = 1;
     (void) printf("Append command successful.\n");
     return;
   }
   else {
      /* Don't read, ignore read command */
      (void) printf("Append command ignored.\n");
     return;
   }
  }
}
