/***********************************************************************\ 
*									* 
*   File: scorpion/src/candlewalk/rmlastchar.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson, Karen Shannon, Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*************************************************************\
* Function: rm1char('c',str);                                *
* Purpose:  Remove first occurence of 'c' from str           *
* Input:    'c', the char to remove.                         *
*           str, the string to modify                        *
* Output:   The modified str.                                *
*                                                            *
* Author:   R. Snodgrass, Lex Nelson			     *
\*************************************************************/

#include <string.h>

char* rmlastchar(c,str)
char c;
char str[];
{
  char temp[10000], *t, *position, *initial;

  initial = str;
  position = 0;

  for (t = str; *t != '\0'; t++) {
    if (*t == c) position = t;
  }

  if (position==0) return(initial);	/* character not in string */
  
  t = temp;

  while (str < position) {
    *t = *str;
    str++;
    t++;
  }

  str++;				/* skip character to be removed */

  while((*t = *str) != '\0') {
    str++;
    t++;
  }

  (void) strcpy(initial,temp);
  return(initial);
}

/*
main()
{
char str[100];

strcpy(str,";\nWithout\n;");

rmlastchar(';',str);
printf(">>%s<<\n",str);

rm1char('\n',str);
printf(">>%s<<\n",str);
}

*/
