/***********************************************************************\ 
*									* 
*   File: scorpion/src/candlewalk/rm1char.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson, Karen Shannon, Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*************************************************************\
* Function: rm1char('c',str);                                *
* Purpose:  Remove first occurence of 'c' from str           *
* Input:    'c', the char to remove.                         *
*           str, the string to modify                        *
* Output:   The modified str.                                *
*                                                            *
* Author:   C. Alexander Nelson                              *
\*************************************************************/
#include <string.h>

char* rm1char(c,str)
char c;
char str[];
{
  char temp[10000], *t, *initial;

  initial = str;

  t = temp;
  while ((*t = *str) != c) {
    if (*str == '\0') return(initial);
    t++;
    str++;
  }
  
  if (*str==c) str++;

  while((*t = *str) != '\0') {
    str++;
    t++;
  }

  (void) strcpy(initial,temp);
  return(initial);
}

/*
main()
{
char str[100];

strcpy(str,";\nWithout");

rm1char(';',str);
printf(">>%s<<\n",str);

rm1char('\n',str);
printf(">>%s<<\n",str);
}

*/
