/***********************************************************************\ 
*									* 
*   File: scorpion/src/candlewalk/firsdex.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson, Karen Shannon, Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/******************************************************************\
 * Purpose: Find leftindex of a substring in a string.             *
 * Input:   str, substr  the str to be searched for the substr     *
 * Output:  return the first position in str where substr begins   *
 *                 else return -1                                  *    
 *                                                                 *
 * Author:  C. Alexander Nelson                                    *
 *                                                                 *
\*******************************************************************/

#ifndef Boolean
#define Boolean int
#endif

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif


int firsdex(substr,str)
char substr[], str[];
{
  int i,j;                          /* i,j loop counters */
  int len1, len2;                   /* len1 = strlen(substr), len2 = strlen(str) */
  Boolean badmatch;                 /* True if we couldn't match the current substrings */


  len1 = strlen(substr);
  len2 = strlen(str);

  /* If substr is longer than str, can't be a substr */
  if (len1 > len2)  return(-1);

  /* Loop for each char in str, see is we can match substr from that point */
  for (i=0; i<len2; i++) {
      if (str[i] == substr[0]) {
	/* Loop for length of substr, but not more than len of str */
	badmatch = FALSE;
	for (j = 1; (j <len1) && (j<len2); j++) {
	  if (substr[j] != str[i+j] ) {
	    badmatch = TRUE;
	    break;
	  }
	}
	if (!badmatch) return(i);
      }
    }
  /* If the loops didn't return a value then substr was not a substr */
  return(-1);
}
