/***********************************************************************\ 
*									* 
*   File: scorpion/src/candlewalk/TexIdlTabs.c 
*				 					* 
*   Copyright (C) 1991 C. Alexander Nelson, Karen Shannon, Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/***********************************************************************\
* Function TexIdlTabs                                                   *
* Purpose:  Determine longest LHS of both node and subclass productions *
*           (except for those which have no RHS.)                       *
*           Determine longest attribute in the node productions         *
*           But make RHS at least one space long.                       * 
* Used by:  PrintTexSpec                                                *
* Input:    The IDL structure (StructEntity) to determine tabs for.     *
* Output:   The global variables lhs and rhs are set subject to above   *
*           restrictions.                                               *
* Author:   C. Alexander Nelson                                         *
\***********************************************************************/

#include "candlewalk.h"
#include <stdio.h>
#include <string.h>
extern Boolean debugswitch;

#define MAX(s,current) if (strlen(s) < strlen(current)) (void)strcpy(current,s);

extern char lhs[], rhs[];

TexIdlTabs(StructEntity)
StructureEntity StructEntity;
{

  SEQstructureStatement Sstate;
  structureStatement Astate;
  subclassProduction sp;
  attributeProduction ap;

  SEQAttribute Sat;
  Attribute Aat;

  (void) strcpy(lhs,"");
  (void) strcpy(rhs," ");

  foreachinSEQstructureStatement(StructEntity->syn_body,Sstate, Astate) {
    
    /* If Statement is a class statement */
    if (typeof(Astate)==KsubclassProduction)  {
      sp = Astate.VsubclassProduction;
      /* If has subclasses, compare current max w/ name of class. */
      if (lengthSEQNamedTypeRef(sp->syn_subclasses)) {
	if (debugswitch) {
	  (void) fprintf(stderr,
            "A subclass in TexIdlTabs: \"%s\"\n", sp->syn_class->lex_name);
	}
	if (strlen(sp->syn_class->lex_name) >strlen(lhs)) {
	  (void) strcpy(lhs,sp->syn_class->lex_name);
	}
      }
    }
    
    /* else if Statement is a node production statement */
    else
      if (typeof(Astate)==KattributeProduction) {
	ap = Astate.VattributeProduction;
	if (debugswitch) {
	  (void) fprintf(stderr, "A node production in TexIdlTabs: \"%s\"\n",
		  ap->syn_class->lex_name);
	}
	if (strlen(ap->syn_class->lex_name) > strlen(lhs)) {
	  (void) strcpy(lhs,ap->syn_class->lex_name);
	}
	foreachinSEQAttribute(ap->syn_attributes, Sat, Aat) {
	  if (debugswitch) {
	    (void) fprintf(stderr, "An attribute in TexIdlTabs: \"%s\"\n",
		    Aat->lex_name);
	  }
	  if (strlen(Aat->lex_name) > strlen(rhs)) {
	    (void) strcpy(rhs,Aat->lex_name);
	  }
	}
      }
  }
}
