/***********************************************************************\ 
*									* 
*   File: scorpion/src/candlewalk/TexIdlComm.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon, C. Alexander Nelson, Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*********************************************************************\
 * Purpose: This routine will change IDL comments of the form         *
 *             -- string '\n'                 to                      *
 *             -- \IDLcf string \IDLpf'\n'                                  *
 *          It will also change keywords outside of comments to       *
 *             {\IDLkf keyword }
 * Warning:  If there is no carriage at the end of the input then     *
 *           the comment macro is closed off at the end of the input  *
 *           and a  carriage return is not added.                     *
 *                                                                    *
 * Input:  oldinfo the string (LexInfo) that might contain a comment  *
 * Output: return the input string with above formatting applied      *
 * Used by: PrintTexSpec                                              *
 * Author:  C. Alexander Nelson                                       *
\*********************************************************************/

#include "candlewalk.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>

extern Boolean debugswitch;

TexIdlComm(oldinfo)
char oldinfo[];
{
  char newinfo[30000], word[1000], c[2], temp;
  int i, len, wordptr;

  /* Set-up all comments for the comment tex macro */
  /*     Copy from oldinfo to newinfo replacing -- w/ \comm { and the */
  /*     next new line w/ } newline. */

  c[1] = '\0';
  (void) strcpy(newinfo,"");
  len = strlen(oldinfo);

  if (debugswitch) {
    (void) fprintf(stderr,"The input to TexIdlComm was >>%s<< \n",oldinfo);
    (void) fflush(stderr);
  }

  for (i=0; i<len; i++) {
    if ( (oldinfo[i]=='-') && ((i+1) < len) && (oldinfo[i+1]=='-') ) {
      /* We have found a comment */
/*      (void) strcat(newinfo,"\\comm{"); */
      (void) strcat(newinfo, "--\\IDLcf{}");
	i+=2;  /* skip over the "--" */


      /* Copy from oldinfo to newinfo until the end of the comment, (a <cr> )        */
      c[1] = '\0';
      while ( (i<len) && (oldinfo[i]!='\n') ) {
	temp = oldinfo[i++];
	if (temp=='{') (void) strcat(newinfo, "\\/{\\IDLpf\\char'173}");
	else if (temp=='}') (void) strcat(newinfo, "\\/{\\IDLpf\\char'175}");
	else if (temp=='<') (void) strcat(newinfo, "\\/{\\IDLpf\\char'74}");
	else if (temp=='>') (void) strcat(newinfo, "\\/{\\IDLpf\\char'76}");
	else if (temp=='|') (void) strcat(newinfo, "\\/{\\IDLpf\\char'174}");
	else if (temp=='\t') (void) strcat(newinfo, "\t\\IDLcf{}");	/* tabs turn off italics */
	else {c[0] = temp; (void) strcat(newinfo,c);}
      }

      /* Now i points to the first <cr>  in newinfo or i is the len of newinfo */
      /*  either way close off the comment macro                             */
      if ( (i<len) && (oldinfo[i] == '\n') )
/*	(void) strcat(newinfo,"}\n"); */
	(void) strcat(newinfo, "\\IDLpf\n");
/*      else strcat(newinfo,"}"); */
      else (void) strcat(newinfo, "\\IDLpf ");
    }
    else if ((isalpha(oldinfo[i])) || (oldinfo[i]=='_')) {
      /* Not inside a comment, look for a keyword */
      wordptr = 0;
      while ((isalpha(oldinfo[i])) || (oldinfo[i]=='_'))
	     word[wordptr++] = oldinfo[i++];
      i--;			/* back up one */
      word[wordptr] = '\0';
      if (CheckIdlKeyWord(word)) {
	(void) strcat(newinfo, "{\\IDLkf{}");
	(void) strcat(newinfo, word);
	(void) strcat(newinfo, "}");
      }
      else (void) strcat(newinfo, word);
    }
    else {
      /* Not inside a comment, just copy from newinfo to newinfo */
      c[0]=oldinfo[i];
      (void) strcat(newinfo,c);
    }
  }
  if (debugswitch) {
    (void) fprintf(stderr, "Returning >>%s<< from TexIdlComm. \n",newinfo); 
    (void) fflush(stderr);
  }
  (void) strcpy(oldinfo,newinfo);
}
