/***********************************************************************\ 
*									* 
*   File: scorpion/src/candlewalk/PrintTexString.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon, C. Alexander Nelson, Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

 /***************************************************************\
 * Filename: PrintTexString.c                                    *
 * Function: PrintTexString                                      *
 * Authors:  C. Alexander Nelson, Karen Shannon, Rick Snodgrass  *
 * Purpose:  Fix and output the string so that Tex will print it *
 *             as it looks and not do funky things with special  *
 *             characters.                                       *
 * Used by:  PrintTexSpec                                        *
 \***************************************************************/

#include <stdio.h>
#include <string.h>
#include "candlewalk.h"
extern char lhs[], rhs[];
extern Boolean debugswitch;
extern int currentkillmode, linenumber, pagenumber;

/* tabbing = TRUE: honor tabs after \n */
/*         = FALSE: ignore tabs and spaces after last \n */
void PrintTexString(outfp, str, tabbing, killingoption) 
FILE *outfp;
char *str;
int tabbing;
int killingoption;
{
  int len, i;
  char Astring[10000];
  int firstCRpos, lastCRpos;

  if (debugswitch) {
    (void) fprintf(stderr, 
      "PrintTexString: tabbing=%d, killingoption=%d\nstr=\"%s\"\n",
      tabbing, killingoption, str);
    (void) fflush(stderr);
  }
  (void) strcpy(Astring,str);
  TexIdlComm(Astring);
  len = strlen(Astring);
  if (debugswitch) {
    (void) fprintf(stderr,"return from TexIdlComm with length=%d, str=\"%s\"\n",      len, Astring);
    (void) fflush(stderr);
  }
  firstCRpos = -1;
  lastCRpos = len + 1;/* so that i will always < lastCRpos if there is no cr */
  for (i=0; i<len; i++)
    if (Astring[i] == '\n') {
      if (firstCRpos == -1) firstCRpos = i;
      lastCRpos = i;
    };
  for (i=0; i<len; i++) {
    if (Astring[i] == '\n') {
      (void) fprintf(outfp,"\\SPB{%d}{%d}\\\\\n", pagenumber, linenumber);
      linenumber++;
      if ( (i==firstCRpos) && (i < lastCRpos) ) { /* special handling for multi-line comments */
	if (currentkillmode == 1) {
	  (void) fprintf(outfp,  "\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\ \\ \\ \\=\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\kill\n");
	  currentkillmode = 2;
	}
      };
      /* Now make sure the currentkillmode is consistent with what is desired */
      if (i==lastCRpos) {
	if ( (currentkillmode==2) && (killingoption==1) ) {
	  /* use lhs, and rhs to set up tabs for this structure */
	  (void) fprintf(outfp,"\\ \\ \\ \\ \\=%s \\=\\tis\\ \\=%s{\\verb.:.} ",
            lhs,rhs);
          (void) fprintf(outfp, 
            "\\=\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=");
	  (void) fprintf(outfp, "\\kill\n");
	  currentkillmode = 1;
	}
	else if ( (currentkillmode==1) && (killingoption==2) ) {
	  (void) fprintf(outfp,"\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=");
	  (void) fprintf(outfp,"\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=");
	  (void) fprintf(outfp, "\\ \\ \\ \\ \\=\\ \\ \\ \\ \\=\\kill\n");
	  currentkillmode = 2;
	}
      }
      (void) fprintf(outfp,"\\SPA{%d}{%d}", pagenumber, linenumber);
      if ((i==lastCRpos) && (currentkillmode == 1)) (void) fprintf(outfp,"\\>");
    }
    else if (Astring[i] == '_') (void) fprintf(outfp,"{\\ul }");
    else if (Astring[i] == ':') (void) fprintf(outfp,"{\\verb.:.}");
    else if (Astring[i] == '|') (void) fprintf(outfp,"{\\char'174}");
    else if (Astring[i] == '~') (void) fprintf(outfp,"{\\char'176}");
    else if (Astring[i] == '^') (void) fprintf(outfp,"{\\char'136}");
    else if (Astring[i] == '$') (void) fprintf(outfp,"\\$");
    else if (Astring[i] == '%') (void) fprintf(outfp,"{\\%}");
    else if (Astring[i] == '#') (void) fprintf(outfp,"\\#");
    else if (Astring[i] == '&') (void) fprintf(outfp,"\\&");
    else if (Astring[i] == '[') (void) fprintf(outfp,"{\\char'133}");
    else if (Astring[i] == ']') (void) fprintf(outfp,"{\\char'135}");
    else if (Astring[i] == '<') (void) fprintf(outfp,"{\\char'074}");
    else if (Astring[i] == '=') (void) fprintf(outfp,"{\\char'75}");
    else if (Astring[i] == '\t') {
      if ( tabbing || (i<lastCRpos) ) (void) fprintf(outfp,"\\>");
    }
    else if (Astring[i] == ' ') {
      if ( tabbing || (i<lastCRpos) ) (void) fprintf(outfp,"\\ ");
    }
    else if (Astring[i] == '\f') {
      (void) fprintf(outfp,"\\SPB{%d}{%d}\\\\[7in]\n", pagenumber, linenumber);
      pagenumber++; linenumber = 1;
      (void) fprintf(outfp,"\\SPA{%d}{%d}", pagenumber, linenumber);
    }
    else if (Astring[i] == '>')  (void) fprintf(outfp,"{\\char'76}");
/* The following are not included because they are TeX commands inserted */
/* by TexIdlComm */
/*    else if (Astring[i] == '{')  (void) fprintf(outfp,"{\\char'173}"); */
/*    else if (Astring[i] == '}')  (void) fprintf(outfp,"{\\char'175}"); */
    else    (void) fputc(Astring[i],outfp);
  }
}

