/***********************************************************************\ 
*									* 
*   File: scorpion/src/candlewalk/FormatString.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon, C. Alexander Nelson, Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
* Purpose:  Fix and output the string so that things are tabbed		*
*		correctly.					 	*
* Used by:  ProcessCompUnit                                     	*
*									*
*   Revision Log:							* 
*   Revision Log:							*
*	$Log:	FormatString.c,v $
* Revision 4.0  89/04/12  06:21:12  cheung
* FormatString.c  Ver 4.0
* 
* Revision 3.9  89/04/02  13:46:38  cheung
* FormatString.c  Ver 3.9
* 
* Revision 3.9  89/03/26  16:04:00  cheung
* FormatString.c  Ver 3.9
* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint
    static char rcsid[] = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/candlewalk/RCS/FormatString.c,v 4.0 89/04/12 06:21:12 cheung Exp Locker: cheung $";
#endif

#include <stdio.h>
#include <string.h>
#include "candlewalk.h"

extern char lhs[], rhs[];
extern Boolean debugswitch;
extern int tabsetting;
extern int currentkillmode;

int charwithinline = 0;
char BString[10000];
int Bpos,
  numtabs = 0;			/* number of logical tabs */

char *malloc();

void FormatTab()
{
  int desiredpos, i;

  if (currentkillmode==1) {	/* in special attribute/subclass production */
    if (numtabs==0)
      desiredpos = tabsetting;
    else if (numtabs==1)
      desiredpos = strlen(lhs);
    else if (numtabs==2)
      desiredpos = strlen(lhs) + 5; /* for space : : = space */
    else if (numtabs==3)
      desiredpos = strlen(lhs) + 5 + strlen(rhs) + 2; /* for : space */
    else {
      desiredpos = strlen(lhs) + 5 + strlen(rhs) + 2;
      desiredpos = ((desiredpos % tabsetting) + numtabs - 3) * tabsetting;
    }
  }
  else desiredpos = ((charwithinline % tabsetting) + 1) * tabsetting;

  for (i=1; i<(desiredpos - (charwithinline % 8) * 8) % 8; i++)
    BString[Bpos++] = '\t';
  
  for (i=1; i<desiredpos - (desiredpos % 8) * 8; i++)
    BString[Bpos++] = ' ';

  numtabs++;
  charwithinline = desiredpos;
}

/* tabbing = TRUE: honor tabs after \n */
/*         = FALSE: ignore tabs and spaces after last \n */
String FormatString(str, tabbing, killingoption) 
char *str;
int tabbing;
int killingoption;
{
  int len, i;
  char Astring[10000];
  int firstCRpos, lastCRpos;
  char *returnstring;

  if (debugswitch) {
    (void) fprintf(stderr, 
      "FormatString: tabbing=%d, killingoption=%d\nstr=\"%s\"\n",
      tabbing, killingoption, str);
    (void) fflush(stderr);
  }
  (void) strcpy(Astring,str);
  len = strlen(Astring);
  firstCRpos = -1;
  lastCRpos = len + 1;		/* so that i will always < lastCRpos if there is no cr */
  for (i=0; i<len; i++)
    if (Astring[i] == '\n') {
      if (firstCRpos == -1) firstCRpos = i;
      lastCRpos = i;
    };
  Bpos = 0;
  for (i=0; i<len; i++) {
    if (Astring[i] == '\n') {
      BString[Bpos++] = '\n';
      charwithinline = 0;
      numtabs = 0;
      if ( (i==firstCRpos) && (i < lastCRpos) ) { /* special handling for multi-line comments */
	if (currentkillmode == 1)
	  currentkillmode = 2;
      };
      if (i==lastCRpos) {
	currentkillmode = killingoption;
	if (currentkillmode == 1) FormatTab();
      }
    }
    else if (Astring[i] == '\t') {
      if ( tabbing || (i<lastCRpos) ) FormatTab();
    }
    else if (Astring[i] == ' ') {
      if ( tabbing || (i<lastCRpos) ) {
	BString[Bpos++] = '\\'; BString[Bpos++] = ' ';
	charwithinline++;
      }
    }
    else if (Astring[i] == '\f') {
      BString[Bpos++] = '\f';
      charwithinline = 0;
      numtabs = 0;
    }
    else  {
      BString[Bpos++] = Astring[i];
      charwithinline++;
    }
  }
  returnstring = (char *) malloc((unsigned) (Bpos + 1));
  BString[Bpos] = '\0';
  (void) sscanf(returnstring, "%s", BString);
    return(returnstring); 
}
