/***********************************************************************\ 
*									* 
*   File: scorpion/src/candlewalk/CheckIdlKeyWord.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon, Alex Nelson, and Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

 /*********************************************************************\
 *                                                                     *
 * Function:  CheckIdlKeyWord                                          *
 * Purpose:   Determine if input was an IDLkeyword                     *
 * Return Value: TRUE if input string was a IDLkeyword, else FALSE     *
 *                                                                     *
 * Algorithm: Change format of input to all lower case & store in buf. *
 *		See if it  matches (using binary search)               *
 *		any keywords in hash table. If so return TRUE.         *
 *                                                                     *
 *                                                                     *
 * Assumptions/Limitations: none                                       *
 * Author:  Outline of code from idlc frontend (Karen Shannon)         *
 *          Modified by C. Alexander Nelson                            *
 * Used by: PrintTexSpec                                               *
 *                                                                     *
 \*********************************************************************/

#include <ctype.h>
#include <string.h>

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* the keyword structure */
typedef struct {
    char *characters;	/* actual characters in keyword */
    char *lowercase;	/* characters in all lowercase */
} keyword;


int num_IDLkeywords = 70;
keyword IDLkeywords[] =
{   {  "And", "and"},
    {  "ASCII", "ascii"},
    {  "Assert", "assert"},
    {  "Bits", "bits"},
    {  "Bytes", "bytes"},
    {  "Boolean", "boolean"},
    {  "C", "c"},
    {  "Case", "case"},
    {  "Cyclic", "cyclic"},
    {  "Define", "define"},
    {  "Do", "do"},
    {  "Else", "else"},
    {  "Empty", "empty"},
    {  "End", "end"},
    {  "Exists", "exists"},
    {  "External", "external"},
    {  "False", "false"},
    {  "Fi", "fi"},
    {  "For", "for"},
    {  "ForAll", "forall"},
    {  "From", "from"},
    {  "If", "if"},
    {  "Import", "import"},
    {  "In", "in"},
    {  "Integer", "integer"},
    {  "Internal", "internal"},
    {  "Intersect", "intersect"},
    {  "Inv", "inv"},
    {  "Is", "is"},
    {  "Language", "language"},
    {  "Machine", "machine"},
    {  "Mark", "mark"},
    {  "Not", "not"},
    {  "Name", "name"},
    {  "Od", "od"},
    {  "Of", "of"},
    {  "Or", "or"},
    {  "OrIf", "orif"},
    {  "Otherwise", "otherwise"},
    {  "Package", "package"},
    {  "Pascal", "pascal"},
    {  "Post", "post"},
    {  "Pre", "pre"},
    {  "Process", "process"},
    {  "Psub", "psub"},
    {  "Rational", "rational"},
    {  "Refines", "refines"},
    {  "Representation", "representation"},
    {  "Restrict", "restrict"},
    {  "Returns", "returns"},
    {  "Root", "root"},
    {  "Runtime", "runtime"},
    {  "Same", "same"},
    {  "Seq", "seq"},
    {  "Set", "set"},
    {  "Size", "size"},
    {  "String", "string"},
    {  "Structure", "structure"},
    {  "Sub", "sub"},
    {  "System", "system"},
    {  "Target", "target"},
    {  "Then", "then"},
    {  "To", "to"},
    {  "True", "true"},
    {  "Type", "type"},
    {  "Union", "union"},
    {  "Unmark", "unmark"},
    {  "Use", "use"},
    {  "Version", "version"},
    {  "Without", "without"}
};

char *malloc();

int CheckIdlKeyWord(input)
char *input;

{
    register keyword *kwdptr;
    register char *cptr;
    register int ctr;
    register char *buf;
    int front, back, mid, len;
    int cmpresult;

    /* Copy input to buf and lowercase buf */
    len = strlen(input);
    buf = (char *) malloc((unsigned) ((len+1)*sizeof(char)));
    (void) strcpy(buf, input);
    cptr = buf;
    for (ctr=0; ctr<len; ctr++, cptr++) {
	if (isupper(*cptr)) {
	    *cptr = tolower(*cptr);
	}
      }


    /* Begin binary search on IDLkeywords */
    front = 0;
    back = num_IDLkeywords-1;
    while (front <= back) {
	mid = (front + back)/2;
	kwdptr = IDLkeywords + mid;
	cmpresult = strcmp(buf, kwdptr->lowercase);
	if (cmpresult == 0) {
	  return(TRUE);
	}
	else if (cmpresult < 0) {
	    back = mid -1;
	}
	else {
	    front = mid +1;
	}
    }
    /* if this point is reached, name is not an IDL keyword */
    return (FALSE);
}


/*
main()

{
printf("Is <ForAll> a keyword? ");
if (CheckIdlKeyWord("ForAll") )  printf("Yes it is. \n");
else printf("No! \n");


printf("Is <Cynthia> a keyword? ");
if (CheckIdlKeyWord("Cynthia") )  printf("Yes it is! \n");
else printf("No, it is not. \n");

}

*/
