/***********************************************************************\ 
*									* 
*   File: scorpion/src/candleexpand/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "candleexpand.h"
#include <stdio.h>

#define MAXTYPELENGTH 150
#define GetAttTypeName(tref) \
	tref.IDLclassCommon->sem_entity.VTypeEntity.IDLclassCommon->sem_name
#define GetRootName(tref) \
	tref.IDLclassCommon->sem_entity.VTypeEntity.IDLclassCommon->sem_name

TypeEntity IDLTypeEntity;

#define ClassToTypeEntity(IDLClass) (IDLTypeEntity.VClass = IDLClass, IDLTypeEntity)
#define AtomicToTypeEntity(IDLAtomic) (IDLTypeEntity.VAtomic = IDLAtomic, IDLTypeEntity)
#define SetOfToTypeEntity(IDLSetOf) (IDLTypeEntity.VSetOf = IDLSetOf, IDLTypeEntity)
#define SeqOfToTypeEntity(IDLSeqOf) (IDLTypeEntity.VSeqOf = IDLSeqOf, IDLTypeEntity)

#define PrintSpaces(fptr, n)	{int i; for (i=0; i<n; i++) (void) fprintf(fptr, " ");}

#define error0(str)	ErrHandler(stderr, str, "\0")
#define error1(str,a)	ErrHandler(stderr, str, a)

/*
 *   Forward references
 */
void     PrintStructure();
void     PrintProcess();
void     PrintRestrictions();
void     PrintReps();
void     PrintAncestors();
void     PrintPortRep();
Boolean  IsPropogated();
Boolean  FindDeclaration();
void     exit();
void revision_number();

main(argc, argv)
int argc;
char *argv[];
{

	FILE *outfp;			/* output file pointer */
	FILE *infp;			/* input file pointer */
	SEQDeclaration SDecl;    	/* traversal of declarations */
	Declaration ADecl;		/* a decl in seq */
	SEQString SStr;			/* traversal of string seqs */
	String AStr;			/* a string in the seq */
	StructureEntity invst;		/* invariant structure of process */
	compilationUnit compUnit;	/* compilation Unit */
	int i;				/* index */
	SEQString stnames;		/* names of the structure declarations 
					   to be expanded */
	SEQString prnames;		/* names of the process declarations 
					   to be expanded */
	SEQDeclaration expand_decls;	/* the declarations to be expanded */
	Boolean has_error = FALSE;
	Declaration found_decl;


	initializeSEQString(stnames);
	initializeSEQString(prnames);
	initializeSEQDeclaration(expand_decls);
	outfp = stdout;
	infp = stdin;
	for (i=1; i<argc; i++) {
	    /* two argument commands */
	    if (!strcmp(argv[i], "-V")) {
		revision_number(argv[0]);
		exit(0);
	    }
	    else if (!strcmp(argv[i], "-f")) {
		if ((i+1 < argc) && (argv[i+1][0] != '-')) {
		    if ((outfp=fopen(argv[i+1], "w")) == NULL) {
			error1("Can't open file '%s' for writing\n", argv[i+1]);
			exit(1);
		    }
		    else {
			++i;
		    }
		}
		else {
		    error1("No file given after '%s' option\n", argv[i]);
		    exit(1);
		}
	    }
	    else if (!strcmp(argv[i], "-i")) {
		if ((i+1 < argc) && (argv[i+1][0] != '-')) {
		    if ((infp=fopen(argv[i+1], "r")) == NULL) {
			error1("Can't open file '%s' for reading\n", argv[i+1]);
			exit(1);
		    }
		    else {
			++i;
		    }
		}
		else {
		    error1("No file given after '%s' option\n", argv[i]);
		    exit(1);
		}
	    }
	    else if (!strcmp(argv[i], "-s")) {
		if ((i+1 < argc) && (argv[i+1][0] != '-')) {
		    ++i;
		    appendrearSEQString(stnames, NewString(argv[i]));
		}
		else {
		    error1("No name given after '%s' option\n", argv[i]);
		    exit(1);
		}
	    }
	    else if (!strcmp(argv[i], "-p")) {
		if ((i+1 < argc) && (argv[i+1][0] != '-')) {
		    ++i;
		    appendrearSEQString(prnames, NewString(argv[i]));
		}
		else {
		    error1("No name given after '%s' option\n", argv[i]);
		    exit(1);
		}
	    }
	    else {
		error1("Invalid option '%s' ignored\n", argv[i]);
	    }
	}


	/* read in the compilation Unit */
	if ((compUnit = INcompUnit(infp)) == NULL) {
	    error0("No compilation Unit\n");
	    exit(1);
	}

	/* if structure and process name lists are empty, 
	   expand all declarations */
	if (emptySEQString(stnames) && emptySEQString(prnames)) {
	    expand_decls = compUnit->syn_body;
	}

	/* else check for valid names */
	else {
	    foreachinSEQString(stnames, SStr, AStr) {
		if (!FindDeclaration(compUnit, AStr, 
				&found_decl, KStructureEntity)) {
		     error1("Structure '%s' is not found\n", AStr);
		     has_error = TRUE;
		}
		else appendrearSEQDeclaration(expand_decls, found_decl);
	    }
	    foreachinSEQString(prnames, SStr, AStr) {
		if (!FindDeclaration(compUnit, AStr, 
				&found_decl, KProcessEntity)) {
		     error1("Process '%s' is not found\n", AStr);
		     has_error = TRUE;
		}
		else appendrearSEQDeclaration(expand_decls, found_decl);
	    }
	    if (has_error)
		exit(-1);
	}

	(void) fprintf(outfp, "\n-- structure declarations\n");
	foreachinSEQDeclaration(expand_decls, SDecl, ADecl) {
	    if (typeof(ADecl) == KStructureEntity)
		PrintStructure(outfp, ADecl.VStructureEntity);
	    else if (typeof(ADecl)==KProcessEntity) {
		invst = ADecl.VProcessEntity->sem_invariant;
		(void) fprintf(outfp, "\n-- invariant structure of process %s",
			    ADecl.VProcessEntity->lex_name);
		PrintStructure(outfp, invst);
	    }
	}
	(void) fprintf(outfp, "\n-- process declaration\n");
	foreachinSEQDeclaration(expand_decls, SDecl, ADecl) {
	    if (typeof(ADecl) == KProcessEntity)
		PrintProcess(outfp, ADecl.VProcessEntity);
	}

	(void) fclose(outfp);
        return 0;
}


void  PrintStructure(fptr, st)
FILE *fptr;
StructureEntity st;
{

	SETTypeEntity SType;
	TypeEntity AType;
	Class AClass;
	Class ANode;
	Atomic AnAtomic;
	SetOf ASet;
	SeqOf ASeq;
	SETClass Ssubclass;
	Class Asubclass;
	SEQAttribute SAtt;
	Attribute AnAtt;
	int numspaces;
	int linelength;
	int lengthset, lengthseq;
	int dlen;
	Boolean IsPropogated();

	(void) fprintf(fptr, "\nStructure %s ", st->lex_name);
	if (typeof(st->syn_root) != KVoid) {
	    (void) fprintf(fptr, "Root %s ", 
                GetRootName(st->syn_root.VTypeRef));
	}
	(void) fprintf(fptr, "Is\n");
	
	/* print out the classes */
	(void) fprintf(fptr, "\n-- classes\n");
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if ((typeof(AType) == KClass) &&
		(!emptySETClass(AType.VClass->sem_subclasses)))
		AClass = AType.VClass;
	    else continue;
	    numspaces = strlen(AClass->sem_name) + 5;
	    linelength = numspaces + 8;
	    (void) fprintf(fptr, "\n\t%s ::= ", AClass->sem_name);
	    lengthset = sizeSETClass(AClass->sem_subclasses);
	    foreachinSETClass(AClass->sem_subclasses, Ssubclass, Asubclass) {
		dlen = strlen(Asubclass->sem_name);
		if ((linelength + dlen) > 80) {
		    (void) fprintf(fptr, "\n\t");
		    PrintSpaces(fptr, numspaces);
		    linelength = numspaces + 8;
		}
		(void) fprintf(fptr, "%s", Asubclass->sem_name);
		linelength += dlen;
/*		if (Ssubclass->next != NULL) { */
		if (--lengthset != 0){
		    if ((linelength + 3) > 80) {
			(void) fprintf(fptr, "\n\t");
			PrintSpaces(fptr, numspaces-1);
			linelength = numspaces + 8;
		    }
		    (void) fprintf(fptr, " | ");
		    linelength += 3;
		}
	    }
	    (void) fprintf(fptr, ";\n");
	    if (!emptySEQAttribute(AClass->sem_allattributes)) {
		(void) fprintf(fptr, "\t%s => ", AClass->sem_name);
		numspaces = strlen(AClass->sem_name) + 4;
		lengthseq = lengthSEQAttribute(AClass->sem_allattributes);
		foreachinSEQAttribute(AClass->sem_allattributes, SAtt, AnAtt) {
		    (void) fprintf(fptr, "%s : %s", AnAtt->lex_name,
				    GetAttTypeName(AnAtt->syn_type));
/*		    if (SAtt->next != NULL) { */
		    if (--lengthseq != 0){
			(void) fprintf(fptr, ", -- offset %d.", 
                            AnAtt->rep_descriptor->rep_offset);
			if (IsPropogated(AClass, AnAtt))
			    (void) fprintf(fptr, "  propagated\n\t");
			else (void) fprintf(fptr, "\n\t");
			PrintSpaces(fptr, numspaces);
		    }
		    else {
			(void) fprintf(fptr, "; -- offset %d.", 
                            AnAtt->rep_descriptor->rep_offset);
			if (IsPropogated(AClass, AnAtt))
			    (void) fprintf(fptr, "  propagated\n");
			else (void) fprintf(fptr, "\n");
		    }
		}
	    }
	    PrintRestrictions(fptr, ClassToTypeEntity(AClass));
	    PrintReps(fptr, ClassToTypeEntity(AClass));
	    PrintAncestors(fptr, AClass);
        }
	(void) fprintf(fptr, "\n-- nodes\n");
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if ((typeof(AType) == KClass) && 
		(emptySETClass(AType.VClass->sem_subclasses)))
		ANode = AType.VClass;
	    else continue;
	    (void) fprintf(fptr, "\n\t%s => ", ANode->sem_name);
	    numspaces = strlen(ANode->sem_name) + 4;
	    if (emptySEQAttribute(ANode->sem_allattributes)) 
		(void) fprintf(fptr, ";\n");
	    else {
	      lengthseq = lengthSEQAttribute(ANode->sem_allattributes);
              foreachinSEQAttribute(ANode->sem_allattributes, SAtt, AnAtt) {
		(void) fprintf(fptr, "%s : %s", AnAtt->lex_name,
			       GetAttTypeName(AnAtt->syn_type));
		/*		if (SAtt->next != NULL) {*/
		if (--lengthseq != 0) {
		  (void) fprintf(fptr, ", -- offset %d.", 
				 AnAtt->rep_descriptor->rep_offset);
		  if (IsPropogated(ANode, AnAtt))
		    (void) fprintf(fptr, "  propagated\n\t");
		  else (void) fprintf(fptr, "\n\t");
		  PrintSpaces(fptr, numspaces);
		}
		else {
		  (void) fprintf(fptr, "; -- offset %d.", 
				 AnAtt->rep_descriptor->rep_offset);
		  if (IsPropogated(ANode, AnAtt))
		    (void) fprintf(fptr, "  propagated\n");
		  else (void) fprintf(fptr, "\n");
		}
	      }
	    }
	    PrintRestrictions(fptr, ClassToTypeEntity(ANode));
	    PrintReps(fptr, ClassToTypeEntity(ANode));
	    PrintAncestors(fptr, ANode);
	  }
	(void) fprintf(fptr, "\n-- privates\n");
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if (typeof(AType) != KAtomic)
		continue;
	    else AnAtomic = AType.VAtomic;
	    (void) fprintf(fptr, "\n\tType %s;\n", AnAtomic->sem_name);
	    PrintRestrictions(fptr, AtomicToTypeEntity(AnAtomic));
	    PrintReps(fptr, AtomicToTypeEntity(AnAtomic));
	}
	(void) fprintf(fptr, "\n-- sets\n");
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if (typeof(AType) != KSetOf)
		continue;
	    else ASet = AType.VSetOf;
	    (void) fprintf(fptr, "\n\t-- %s\n", ASet->sem_name);
	    PrintRestrictions(fptr, SetOfToTypeEntity(ASet));
	    PrintReps(fptr, SetOfToTypeEntity(ASet));
	}
	(void) fprintf(fptr, "\n-- seqs\n");
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if (typeof(AType) != KSeqOf)
		continue;
	    else ASeq = AType.VSeqOf;
	    (void) fprintf(fptr, "\n\t-- %s\n", ASeq->sem_name);
	    PrintRestrictions(fptr, SeqOfToTypeEntity(ASeq));
	    PrintReps(fptr, SeqOfToTypeEntity(ASeq));
	}

	(void) fprintf(fptr, "End\n\n");
}

void  PrintProcess(fptr, pr)
FILE *fptr;
ProcessEntity pr;
{

	SETPort SPort;
	Port APort;
	SEQString SStr;
	String AStr;

	(void) fprintf(fptr, "\nProcess %s ", pr->lex_name);
	if (typeof(pr->syn_invariant) == KStructureRef)
	    (void) fprintf(fptr, "Inv %s ", 
                pr->syn_invariant.VStructureRef->lex_name);
	(void) fprintf(fptr, "Is\n");
	if (typeof(pr->sem_target) == KTargetEntity) {
	    (void) fprintf(fptr, "\n\tTarget");
	    foreachinSEQString(pr->sem_target.VTargetEntity->sem_id,
				SStr, AStr) {
		(void) fprintf(fptr, " %s", AStr); 
	    }
	    (void) fprintf(fptr, ";\n");
	}

	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) == KPrePort) {
		(void) fprintf(fptr, "\tPre %s: %s;\n", APort->lex_name,
			APort->syn_data->lex_name);
		PrintPortRep(fptr, APort);
	    }
	}
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) == KPostPort) {
		(void) fprintf(fptr, "\tPost %s: %s;\n", APort->lex_name,
			APort->syn_data->lex_name);
		PrintPortRep(fptr, APort);
	    }
	}

	(void) fprintf(fptr, "\nEnd\n\n");
}


void  PrintRestrictions(fptr, AType)
FILE *fptr;
TypeEntity AType;
{
 	int linelength;
	int numspaces;
	int oplen;
	int lengthset;
	Class AClass;
	Atomic AnAtomic;
	SetOf ASet;
	SeqOf ASeq;
	SETClassOperation SCOp;
	ClassOperation COp;
	SETAtomicOperation SAOp;
	AtomicOperation AOp;
	SETSetOperation SStOp;
	SetOperation StOp;
	SETSeqOperation SSqOp;
	SeqOperation SqOp;

	if (typeof(AType) == KClass) {
	    AClass = AType.VClass;
	    if (emptySETClassOperation(AClass->rep_allowedOps))
		return;
	}
	else if (typeof(AType) == KAtomic) {
	    AnAtomic = AType.VAtomic;
	    if (emptySETAtomicOperation(AnAtomic->rep_allowedOps))
		return;
	}
	else if (typeof(AType) == KSetOf) {
	    ASet = AType.VSetOf;
	    if (emptySETSetOperation(ASet->rep_allowedOps))
		return;
	}
	else if (typeof(AType) == KSeqOf) {
	    ASeq = AType.VSeqOf;
	    if (emptySETSeqOperation(ASeq->rep_allowedOps))
		return;
	}
	else return;

	numspaces = strlen(AType.IDLclassCommon->sem_name) + 12;
	linelength = numspaces + 8;
	(void) fprintf(fptr, "\tRestrict %s To", 
            AType.IDLclassCommon->sem_name);

	if (typeof(AType) == KClass) {
	  lengthset = sizeSETClassOperation(AClass->rep_allowedOps);
	  foreachinSETClassOperation(AClass->rep_allowedOps, SCOp, COp) {
	    oplen = strlen(COp->rep_name);
	    if ((linelength + oplen) > 80) {
	      (void) fprintf(fptr, "\n\t");
	      PrintSpaces(fptr, numspaces);
	      linelength = numspaces + 8;
	    }
	    (void) fprintf(fptr, " %s", COp->rep_name);
	    linelength += oplen+1;
	    /*		if (SCOp->next != NULL){*/
	    if (--lengthset != 0) {
	      (void) fprintf(fptr, ","); 
	      ++linelength;
	    }
	  }
	}
	else if (typeof(AType) == KAtomic) {
	    lengthset = sizeSETAtomicOperation(AnAtomic->rep_allowedOps);
	    foreachinSETAtomicOperation(AnAtomic->rep_allowedOps, SAOp, AOp) {
		oplen = strlen(AOp->rep_name);
		if ((linelength + oplen) > 80) {
		    (void) fprintf(fptr, "\n\t");
		    PrintSpaces(fptr, numspaces);
		    linelength = numspaces + 8;
		}
		(void) fprintf(fptr, " %s", AOp->rep_name);
		linelength += oplen+1;
/*		if (SAOp->next != NULL){ */
		if (--lengthset != 0){
		    (void) fprintf(fptr, ","); 
		    ++linelength;
		}
	    }
	}
	else if (typeof(AType) == KSetOf) {
	    lengthset = sizeSETSetOperation(ASet->rep_allowedOps);
	    foreachinSETSetOperation(ASet->rep_allowedOps, SStOp, StOp) {
		oplen = strlen(StOp->rep_name);
		if ((linelength + oplen) > 80) {
		    (void) fprintf(fptr, "\n\t");
		    PrintSpaces(fptr, numspaces);
		    linelength = numspaces + 8;
		}
		(void) fprintf(fptr, " %s", StOp->rep_name);
		linelength += oplen+1;
/*		if (SStOp->next != NULL){ */
		if (--lengthset != 0){
		    (void) fprintf(fptr, ","); 
		    ++linelength;
		}
	    }
	}
	else if (typeof(AType) == KSeqOf) {
	    lengthset = sizeSETSeqOperation(ASeq->rep_allowedOps);
	    foreachinSETSeqOperation(ASeq->rep_allowedOps, SSqOp, SqOp) { 
		oplen = strlen(SqOp->rep_name);
		if ((linelength + oplen) > 80) {
		    (void) fprintf(fptr, "\n\t");
		    PrintSpaces(fptr, numspaces);
		    linelength = numspaces + 8;
		}
		(void) fprintf(fptr, " %s", SqOp->rep_name);
		linelength += oplen+1;
/*		if (SSqOp->next != NULL){ */
		if (--lengthset != 0){
		    (void) fprintf(fptr, ","); 
		    ++linelength;
		}
	    }
	}
	(void) fprintf(fptr, ";\n");
}

void  PrintReps(fptr, AType)
FILE *fptr;
TypeEntity AType;
{
    if (typeof(AType)==KAtomic){
	Atomic a;
	a = AType.VAtomic;
	switch (typeof(a->rep_internalType)){
	    case KPackage:
		(void) fprintf(fptr, "\tFor %s Use Package %s;\n",
			a->sem_name, a->rep_internalType.VPackage->rep_name);
		break;
	    case KVoid:
		break;
	    default: /* type entity */
		(void) fprintf(fptr, "\tFor %s Use Internal %s;\n",
			a->sem_name, a->rep_internalType.VTypeEntity.
			IDLclassCommon->sem_name);
		break;
	}
	switch (typeof(a->rep_externalType)){
	    case KVoid:
	    case KPredefined:
		break;
	    default: /* type entity */
		(void) fprintf(fptr, "\tFor %s Use External %s;\n",
			a->sem_name, a->rep_externalType.VTypeEntity.
			IDLclassCommon->sem_name);
		break;
	}
	if (a->rep_size) {
	    (void) fprintf(fptr, "\tFor %s Use Size %d;\n", a->sem_name, 
                a->rep_size);
	}
    }
    else if (typeof(AType)==KClass) {
	if (AType.VClass->rep_enumerated) {
	    (void) fprintf(fptr, "\tFor %s Use Representation Enumerated;\n",
			AType.VClass->sem_name);
	}
    }
}


void  PrintAncestors(fptr, AClass)
FILE *fptr;
Class AClass;
{
	SETClass Sancclass;
	Class Aancclass;
	int linelength;
	int numspaces;
	int alen;

	numspaces = strlen(AClass->sem_name) + 17;
	linelength = numspaces + 8;
	(void) fprintf(fptr, "\t-- ancestors of %s: ", AClass->sem_name);
	foreachinSETClass(AClass->sem_ancestors, Sancclass, Aancclass) {
	    alen = strlen(Aancclass->sem_name);
	    if ((linelength + alen) > 80) {
		(void) fprintf(fptr, "\n\t");
		PrintSpaces(fptr, numspaces);
		linelength = numspaces + 8;
	    }
	    (void) fprintf(fptr, "%s ", Aancclass->sem_name);
	    linelength += alen+1;
	} 
	(void) fprintf(fptr, "\n");
}

/*ARGSUSED*/
/*  The body of the function is commented out */
void  PrintPortRep(fptr, APort)
FILE *fptr;
Port APort;
{
/*
	SEQportAssociation SpAssoc;
	portAssociation ApAssoc;
	SEQparameter Sparm;
	parameter Aparm;
	String pname;

	foreachinSEQportAssociation(APort->rep_concreteRep->ex_portAssociations,
				    SpAssoc, ApAssoc) {
	    (void) fprintf(fptr, "\tFor %s Use", APort->lex_name);
	    foreachinSEQparameter(ApAssoc->syn_rep->syn_id, Sparm, Aparm) {
		if (typeof(Aparm) == KnameToken)
		    pname = Aparm.VnameToken->lex_name;
		else pname = Aparm.VintegerToken->lex_externalform;
		(void) fprintf(fptr, " %s", pname);
	    }
	    (void) fprintf(fptr, ";\n");
	}
*/
}

Boolean IsPropogated(theclass, theatt)
Class theclass;
Attribute theatt;
{
	SETClass SClass;
	Class AClass;

	foreachinSETClass(theclass->sem_ancestors, SClass, AClass) {
	    if (inSEQAttribute(AClass->sem_allattributes, theatt))
		return(TRUE);
	}
	return(FALSE);
}


Boolean  FindDeclaration(compUnit, name, found_decl, type)
compilationUnit compUnit;
String name;
Declaration *found_decl;
int type;	/* KStructureEntity or KProcessEntity */
{
    SEQDeclaration SDecl;
    Declaration ADecl;
    SEQStructureRef SStRef;
    StructureRef AStRef;
    ProcessRef APrRef;
    Boolean found=FALSE; 

    foreachinSEQDeclaration(compUnit->syn_body, SDecl, ADecl) {
	if (typeof(ADecl) == type) {
	    if (ADecl.VStructureOrProcess.IDLclassCommon->lex_name == name) {
		*found_decl = ADecl;
		found = TRUE;
		break;
	    }
	    else if (type == KStructureEntity) {
		foreachinSEQStructureRef(ADecl.VStructureEntity->syn_from,
					 SStRef, AStRef) {
		    if (AStRef->lex_name == name) {
			if (typeof(AStRef->sem_entity)==KStructureEntity) {
			    found_decl->VStructureEntity = 
					AStRef->sem_entity.VStructureEntity;
			    found = TRUE;
			    break;
			}
		    }
		}
		if (typeof(ADecl.VStructureEntity->syn_refines)==KStructureRef)
		{
		    AStRef = ADecl.VStructureEntity->syn_refines.VStructureRef;
		    if (AStRef->lex_name == name) {
			if (typeof(AStRef->sem_entity)==KStructureEntity) {
			    found_decl->VStructureEntity = 
					AStRef->sem_entity.VStructureEntity;
			    found = TRUE;
			    break;
			}
		    }
		}
	    }
	    else { /* ProcessEntity */
		if (typeof(ADecl.VProcessEntity->syn_refines)==KProcessRef)
		{
		    APrRef = ADecl.VProcessEntity->syn_refines.VProcessRef;
		    if (APrRef->lex_name == name) {
			if (typeof(APrRef->sem_entity)==KProcessEntity) {
			    found_decl->VProcessEntity = 
					APrRef->sem_entity.VProcessEntity;
			    found = TRUE;
			    break;
			}
		    }
		}
	    }
	}
    }

    return(found);
}


void usage(name)
char *name;
{
 (void)printf("Usage: %s [-V] [-i inputfile] [-f outputfile] [-s st_name].. [-p pr_name]..\n",name);
}


void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)sscanf("$Revision: 5.0 $","%*s %s",revision_str);
 (void)printf("%s: IDL specification expander  Version %s\n",name,revision_str);
 usage(name);
}
