{***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidlP/writer.p 
*				 					* 
*   Copyright (C) 1991 Michael Shapiro
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

#include "/usr/local/scorpion/include/Pascal/global2.h"
#include "/usr/local/scorpion/include/Pascal/writer.h"

procedure WString;
var i:integer;
begin
	write(f, '"');
	for i := 1 to StringInstance^.length do
		write(f,StringInstance^.value[i]);
	write(f, '"')
end;

procedure Winteger;
begin
	write(f,integerNumber);
end;

procedure Wreal;
begin
	write(f,realNumber:16:4);
end;

procedure Wboolean;
begin
	if (booleanInstance = true) then
	    write(f, 'TRUE')
	else
	    write(f, 'FALSE')
end;


procedure WError;
begin
	if ErrorType = ErrPortMode
	then writeln('IDL writer error: Bad Port Mode')
	else if ErrorType = ErrNullNode
	then writeln('IDL writer error: Null Node')
	else if ErrorType = ErrBadClassType
	then writeln('IDL writer error: Bad Class Type')
	else writeln('IDL writer error: Unknown Error')
end;

function Touched;
begin
	Touched := IDLhidden.Touched
end;

function Shared;
begin
	Shared := IDLhidden.Shared
end;

procedure MarkTouched;
begin
	IDLhidden.Touched := true
end;

procedure MarkShared;
begin
	IDLhidden.Shared := true
end;

procedure UnmarkTouched;
begin
	IDLhidden.Touched := false
end;

procedure UnmarkShared;
begin
	IDLhidden.Shared := false

end;

procedure IDLoutLabel;
begin
	write(f, 'L', IDLhidden.Label:1)
end;
