{***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidlP/string.p 
*				 					* 
*   Copyright (C) 1991 Michael Shapiro
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

#include "/usr/local/scorpion/include/Pascal/global2.h"
#include "/usr/local/scorpion/include/Pascal/global3.h"

(*	string.p						*)

const STABSIZ = 250;	(* string table size *)

type PHashTableCell = ^HashTableCell;
     HashTableCell =
     record
           next:  PHashTableCell;
           value:  String
     end;

(* assume initialized to 0 *)
var IDLStringTable: array [0..STABSIZ] of PHashTableCell;

function StringHash(this: packedArrayType; length: integer): integer;
var i, result: integer;
begin
	result := 0;
	for i := 1 to length do result := result + ord(this[i]);
	StringHash := result mod STABSIZ;
end;

function stringsEqual (String1, String2: packedArrayType; length: integer):boolean;
var	i: integer;
	match:boolean;
begin	
	match := true;
	i := 1;
	while (match and (i<=length)) do begin
	    if (String1[i] <> String2[i])
		then match := false
	    else i := i+1
	end;
	stringsEqual := match
end;


function NewString (* length: integer; value: packedArrayType): String *);
var	i,index: integer;
	thisCell: PHashTableCell;
	s: String;
	found: boolean;
begin
	if (length < 0) or (length > 512) then halt;
	index := StringHash(value, length);
	thisCell := IDLStringTable[index];
	found := false;
	while (not found) and (thisCell <> nil) do begin
		if (thisCell^.value^.length = length)
			and stringsEqual(thisCell^.value^.value, value, length)
		then begin
			found := true;
			s := thisCell^.value;
			end;
		thisCell := thisCell^.next;
		end;
	if not found
	then begin
		new(s);
		for i:=1 to length do
		    s^.value[i] := value[i];
		s^.length := length;
		new(thisCell);
		thisCell^.next := IDLStringTable[index];
		thisCell^.value := s;
		IDLStringTable[index] := thisCell;
		end;
	NewString := s;
end;

function StringTopacked (* source: String): packedArrayType *);
begin
	StringTopacked := source^.value;
end;

function StringAppend (* source, added: String): String *);
var	i, j: integer;
	temparray: packedArrayType;
begin
	j := added^.length + 1;
	for i:=1 to source^.length do 
	    temparray[i] := source^.value[i];
	for i := 1 to added^.length do
	    temparray[i + source^.length] := added^.value[i];
	StringAppend := NewString(source^.length + added^.length, temparray);
end;

function StringLength (* StringInstance: String): integer *);
begin
	StringLength := StringInstance^.length
end;


const MAXSTRINGLEN = 5000;
const TILDE = 0176;
const DEL = 0177;
const QUOTE = '"';

function checkstring(S: String): String;
var	newS: String;
	i: integer;
	j: integer;
begin
	j := 1;
	for i:=1 to S^.length do begin

	    if (ord(S^.value[i]) <= 037) then (* char is between '@' and '_' *)
	    begin
		newS^.value[j] := '~';
		j := j+1;
		newS^.value[j] := chr(ord(S^.value[i]) + ord('@'));
	    end
	    else if (ord(S^.value[i]) = TILDE) then 
	    begin
	    
		newS^.value[j] := '~';
		j := j+1;
		newS^.value[j] := '~';
	    end
	    else if (ord(S^.value[i]) = DEL) then
	    begin
		newS^.value[j] := '~';
		j := j+1;
		newS^.value[j] := '{';
	    end
	    else if (S^.value[i] = QUOTE) then
	    begin
		newS^.value[j] := '"';
		j := j+1;
		newS^.value[j] := '"';
	    end
	    else newS^.value[j] := S^.value[i];
	    j := j+1;
	end;
	newS^.length := j;

	checkstring := newS;
end;
