/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/writeext.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include <string.h>
#include <C/global.h>
#include <C/writer.h>

#define TILDE 0176
#define DEL 0177
#define QUOTE '"'

static char buffer[256];

int 
IDLBooleanToExternal(value, result, len)
Boolean value;
char *result;
int len;
{
  if (value == TRUE)
    {
      if (len < 5)
	return 5;
      else
        (void)strcpy (result,"TRUE");
    }
  else if (value == FALSE)
    {
      if (len < 6)
	return 6;
      else
        (void)strcpy (result,"FALSE");
    }
  else
    return -1;
  return 0;
}

int 
IDLdoubleToExternal(value, result, len, base)
double value;
char *result;
int len;
int base;
{
  register int i;
  register int lenbuf;
  
  if (base != 10)
    return -1;
  (void)sprintf (buffer,"%g",(float) value);
  lenbuf = strlen (buffer);
  if (len < lenbuf+1)
    return lenbuf + 1;
  for (i=0;i<lenbuf;i++)
    if (buffer[i]=='e')
      buffer[i] = 'E';
  (void)strcpy (result,buffer);
  return 0;
}


int 
IDLfloatToExternal(value, result, len, base)
float value;
char *result;
int len;
int base;
{
  register int i;
  register int lenbuf;
  
  if (base != 10)
    return -1;
  (void)sprintf (buffer,"%g",(float) value);
  lenbuf = strlen (buffer);
  if (len < lenbuf+1)
    return lenbuf + 1;
  for (i=0;i<lenbuf;i++)
    if (buffer[i]=='e')
      buffer[i] = 'E';
  (void)strcpy (result,buffer);
  return 0;
}


int
IDLintToExternal(value, result, len)
int value;
char *result;
int len;
{
  register int lenbuf;

  (void)sprintf (buffer,"%d",value);
  lenbuf = strlen (buffer);
  if (len < lenbuf+1)
    return lenbuf + 1;
  (void)strcpy (result,buffer);
  return 0;
}

int
IDLUnsignedIntToExternal(value, result, len)
unsigned int value;
char *result;
int len;
{
  register int lenbuf;

  (void)sprintf (buffer,"%u",value);
  lenbuf = strlen (buffer);
  if (len < lenbuf+1)
    return lenbuf + 1;
  (void)strcpy (result,buffer);
  return 0;
}

int
IDLlongToExternal(value, result, len)
long value;
char *result;
int len;
{
  register int lenbuf;

  (void)sprintf (buffer,"%ld",value);
  lenbuf = strlen (buffer);
  if (len < lenbuf+1)
    return lenbuf + 1;
  (void)strcpy (result,buffer);
  return 0;
}

int
IDLUnsignedLongToExternal(value, result, len)
unsigned long value;
char *result;
int len;
{
  register int lenbuf;

  (void)sprintf (buffer,"%lu",value);
  lenbuf = strlen (buffer);
  if (len < lenbuf+1)
    return lenbuf + 1;
  (void)strcpy (result,buffer);
  return 0;
}

int
IDLStringToExternal(value, result, len)
String value;
char *result;
int len;
{
  register int i;
  register char *S;
  
  i = 0;
  if (value == NULL)
    {
     if (len < 3)
       return 3;
     else
       {
	(void)strcpy (result,"");
        return 0;
       } 
    }
  if (i+1 <= len)
    {
      i++;
      *result++ = '\"';
    }
  S = value;
  for (;*S;S++)
    {
      if(*S <= 037)         /* character is between '@' and '_' */
	{
	  if (i+2 <= len)
	    {
	      *result++ = '~';
	      *result++ = *S + '@';
	    }
	  i += 2;
	}
      else if(*S == TILDE)
	{
	  if (i+2 <= len)
	    {
	      *result++ = '~';
	      *result++ = '~';
	    }
	  i += 2;
	}
      else if(*S == DEL)
	{
	  if (i+2 <= len)
	    {
	      *result++ = '~';
	      *result++ = '{';
	    }
	  i += 2;
	}
      else if(*S == QUOTE)
	{
	  if (i+2 <= len)
	    {
	      *result++ = '"';
	      *result++ = '"';
	    }
	  i += 2;
	}
      else 
	{
	  if (i+1 <= len)
	    *result++ = *S;
	  i++;
	}
    }
  if (i+2 > len)
    return i+2;
  else
    {
      *result++ = '\"';
      *result = '\0';
    }
  return 0;
}
