/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/wmisc.c 
*				 					* 
*   Copyright (C) 1991 Tim Maroney
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: miscellaneous writing routines				*
*									* 
\***********************************************************************/ 

#ifndef lint
static char rcsid[] = "$Header: /r/zep/usr/rts/p/personal/hkaram/tech/src/lib/libidl/RCS/wmisc.c,v 4.2 90/08/20 16:30:08 hkaram Release42 Locker: hkaram $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	wmisc.c,v $
 * Revision 4.2  90/08/20  16:30:08  hkaram
 * @
 * 
 * Revision 4.0  89/04/12  08:53:48  cheung
 * wmisc.c  Ver 4.0
 * 
 * Revision 3.9  89/04/07  23:39:41  cheung
 * wmisc.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  12:36:05  cheung
 * wmisc.c
 * 
 * Revision 3.2  88/03/05  14:02:34  rajan
 * This is the version distributed with release 3.2
 * 
 * Revision 1.1  87/04/18  13:42:18  shannon
 * Initial revision
 * 
 * Revision 1.2  85/06/20  10:43:14  shannon
 * added sequence and set writing routines for scalar types.
 * 
 * Revision 1.1  85/06/11  10:34:11  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     May  1984 (maroney) Created.					*
*									*
\* ******************************************************************* */
#include <stdio.h>
#include <C/global.h>
#include <C/writer.h>

#define MAXSTRINGLEN 5000
#define TILDE 0176
#define DEL 0177
#define QUOTE '"'
#define IDLStringSize 20

char *malloc();
void exit();

/* buffer used by ToExternal writer routines */
char IDLExternBuf[IDLExternBufSize];

void WError(E)
WErrType E;
{	switch (E) {
	case ErrNullNode:
		IDLout("**Null Node**");
		(void)fprintf(stderr,"Writer Error: null node\n");
		break;
	case ErrPortMode:
		(void)fprintf(stderr,"Writer error: bad port mode\n");
		break;
	case ErrBadClassType:
		IDLout("**Bad Node For Class**");
		(void)fprintf(stderr,"Writer error: bad class type\n");
		break;
	}
}

void WString(S)
register String S;
{	register char *IDLStringBuf;
	register int IDLStringLength;

	if (S == NULL)
	  {
 	    IDLout ("\"\"");
	    return ;
	  }
	if ((IDLStringLength = strlen(S) + IDLStringSize) > IDLExternBufSize) {
	  IDLStringBuf = (char *)malloc((unsigned)IDLStringLength);
	}
	else {
	  IDLStringBuf = IDLExternBuf;
	  IDLStringLength = IDLExternBufSize;
	}

	if ((IDLStringLength = IDLStringToExternal(S, IDLStringBuf, IDLStringLength)) > 0) {
	  if (IDLStringBuf != IDLExternBuf) free(IDLStringBuf);
	  IDLStringBuf = (char *)malloc((unsigned)IDLStringLength);
	  if ((IDLStringLength = IDLStringToExternal(S, IDLStringBuf, IDLStringLength)) > 0) {
	    (void)fprintf(stderr, "Internal error in WString\n");
	    exit(-1);
	  }
	}
	IDLout(IDLStringBuf);
	if (IDLStringBuf != IDLExternBuf) free(IDLStringBuf);
}

/**********************
void WSETBoolean (SB)
register SETBoolean SB;
{	IDLoutC( OpenBrace );
	if (SB.true) {
	    WBoolean(TRUE);
	    if (SB.false) {
		IDLoutC (ListLink);
		WBoolean(FALSE);
	    }
	}
	else if (SB.false) WBoolean(FALSE);
	IDLoutC ( CloseBrace );
}
************************/

char *check_string(S)
String	S;
{

	static char stringbuf[MAXSTRINGLEN];
	register char *	result;
	int len;
	
	if ((len = strlen(S)) >= MAXSTRINGLEN)
	    result = (char *)GetHeap(len + 1);
	else result = stringbuf;

	while (*S != '\0')
	{
	    if(*S <= 037)	  /* character is between '@' and '_' */
	    {
		*result++ = '~';
		*result++ = *S + '@';
	    }
	    else if(*S == TILDE)  
	    	 {
		     *result++ = '~';
		     *result++ = '~';
	    	 }
	    else if(*S == DEL)
		 {
		     *result++ = '~';
		     *result++ = '{';
		 }
	    else if(*S == QUOTE)
	         {
		     *result++ = '"';
		     *result++ = '"';
		 }
	    else *result++ = *S;
	    ++S;
	}

	*result = '\0';

	return(stringbuf);
}
