/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/source.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/* we start with an attribute pointer out of Candle */
typedef union {
    int IDLinternal;
    CPTypeEntity IDLclassCommon;
    SetOrSeq VSetOrSeq;
    SeqOf VSeqOf;
    SetOf VSetOf;
    NamedType VNamedType;
    Class VClass;
    Atomic VAtomic;
    unknown Vunknown;
} TypeEntity;

/* its 'common' attributes are of type CPTypeEntity */
typedef struct CATypeEntity * CPTypeEntity;

struct CATypeEntity {
    IDLnodeHeader IDLhidden;
    String sem_name;
    String rep_name;
    int rep_size;
    TypeEntityOrVoid sem_copiedfrom;
};

/* evidently if a typeentity is copied, we get another typeentity
 * of the item it is copied from.  This would only be useful, I
 * suppose, in a case of 'derives' or 'defines'
 */
typedef union {
    int IDLinternal;
    HgenericHeader IDLclassCommon;
    TypeEntity VTypeEntity;
    unknown Vunknown;
    Atomic VAtomic;
    Class VClass;
    NamedType VNamedType;
    SetOf VSetOf;
    SeqOf VSeqOf;
    SetOrSeq VSetOrSeq;
    Tvoid VTvoid;
} TypeEntityOrVoid;

/* also from the original attribute pointer, we have SetSeqOf,
 * SetOf, and SeqOf.  V... is a pointer to these.
 */
typedef union {
    int IDLinternal;
    CPSetOrSeq IDLclassCommon;
    SetOf VSetOf;
    SeqOf VSeqOf;
} SetOrSeq;

struct RSeqOf { IDLnodeHeader IDLhidden;
    String sem_name;
    String rep_name;
    int rep_size;
    TypeEntityOrVoid sem_copiedfrom;
    SetSeqSize rep_numelements;
    String rep_package;
    NamedType sem_component;
    SETSeqOperation rep_allowedOps;
};

struct RSetOf { IDLnodeHeader IDLhidden;
    String sem_name;
    String rep_name;
    int rep_size;
    TypeEntityOrVoid sem_copiedfrom;
    SetSeqSize rep_numelements;
    String rep_package;
    NamedType sem_component;
    SETSetOperation rep_allowedOps;
};

/* next on the 'attribute' list is 'namedtype' and 'class' */

typedef union {
    int IDLinternal;
    CPNamedType IDLclassCommon;
    Atomic VAtomic;
    Class VClass;
} NamedType;

typedef struct RClass * Class;

struct RClass { IDLnodeHeader IDLhidden;
    String sem_name;
    String rep_name;
    int rep_size;
    TypeEntityOrVoid sem_copiedfrom;
    SETClassOperation rep_allowedOps;
    int rep_nodeId;
    SEQAttribute sem_allattributes;
    SETClass sem_ancestors;
    SETClass sem_subclasses;
    Boolean rep_enumerated;
};

/* next for Attribute -- atomic */

typedef struct RAtomic * Atomic;

struct RAtomic { IDLnodeHeader IDLhidden;
    String sem_name;
    String rep_name;
    int rep_size;
    TypeEntityOrVoid sem_copiedfrom;
    SETAtomicOperation rep_allowedOps;
    ExternalType rep_externalType;
    InternalType rep_internalType;
};

/* final attribute for 'Attribute': unknown */

typedef struct Runknown * unknown;

struct Runknown { IDLnodeHeader IDLhidden;
    String sem_name;
    String rep_name;
    int rep_size;
    TypeEntityOrVoid sem_copiedfrom;
};

