/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/sndwdwmsg.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

		/*DOC+*/
/* sndwdwmsg -- library -- send message to window process
 *          callers must test for and report errors 
 *          on their own (w/ perror, e.g.)
 *  9-Aug-1987
 *  9-Oct-1988 -- added code for write of "successful transmission"
 *                bytes if additional message write succeeds.
 */
		/*DOC-*/

#include "ivw.h"
#include <stdio.h>

void iniacktrl();
void sndabomsg();

extern int usrdsc;

		/*DOC+*/
/* int */
sndwdwmsg(hdr)		/* send window a message */
  ivwmsghdr hdr;	/* window message header */
		/*DOC-*/
{
  char acktrl[ACKTRLSIZ];
  int wrtsts;		/* write status -- status from socket write */
  int chksts;		/* address checking status */


  /* this 'write' call requires 4 arguments -- I found that
   * out from an example in an IPC document by Sechrist
   * from Berkeley.  The fourth argument does not appear
   * in either 4.2 or 4.3 documentation, and I haven't found
   * anyone who has heard that 'write' needs one.  However,
   * without it, the 'write' call bombs consistently.
   * Ralph Cook, Summer, 1987.
   */

   wrtsts = write (usrdsc, (char *)&hdr, sizeof(hdr), 0);
   if (wrtsts == -1) { 
     sndabomsg((int)sizeof(ivwmsghdr));
/*     iniivwmsg(&dummy);
     write(usrdsc, dummy, sizeof(dummy), 0);*/
     return -1;
	             }
     else 
     { if (hdr.addmsglng != 0) 
         { /* check the additional address area to ensure
	    * it is within legal address limits
	    */
	   chksts = chkadr ((int)(hdr.adr), hdr.addmsglng);
	   if (chksts==IVWFLS)
	          { /* additional address area not within bounds;
		     * send bad address message and abort
		     */
		    sndabomsg (hdr.addmsglng);
                    return -1;
	          }
	     else { wrtsts = write (usrdsc, hdr.adr, hdr.addmsglng, 0); 
   	            if (wrtsts != -1)
	                 { /* success -- write success trailer */
		           iniacktrl(acktrl);
	                   if((wrtsts = write (usrdsc, acktrl, ACKTRLSIZ, 0)) == -1)
			     {
			       sndabomsg(hdr.addmsglng);
			       return -1;
			     }
			   else
			     return wrtsts;
	                 }
	               else { /* write failed;
			       * send abort message and 
			       * signal error
			       */
			      sndabomsg (hdr.addmsglng);
		              return -1;
			    }
	           }
         }
     }
  return 0;
}
