/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/sndfstnod.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

		/*DOC+*/
/* sndfstnod.c -- library -- send first IDL node to window process.
 * This routine is called by the dbx alias "shownod".
 *  9-Aug-1987
 */
		/*DOC-*/


#include <stdio.h>
#include <string.h>
#include "ivw.h"	/* IDLView general include */

/* external routines */
int sndwdwmsg();	/* send message to window */
int cmmlop();		/* communications loop with IDLView */
void iniivwmsg();	/* init ivw message header */
int chkadr();		/* check legality of address */
extern int ivwup;       /* check if idlview is invoked already */

		/*DOC+*/
int IDLsndfstnod(adr)
  ptr    adr;		/* address of node */
		/*DOC-*/
{
  int    wrtsts;	/* write/read status: status of commun. w/ window */
  ivwmsghdr ivwmsg;	/* IDLView message header */
  
  if (ivwup == IVWFLS)
    (void)fprintf(stderr, "Invoke idlview before shownode.\n");
  if (adr==IVWNUL)
    (void)fprintf(stderr,"Null node address\n");
  else if (IVWFLS == chkadr((int)(adr), 4))
    (void)fprintf(stderr,"Illegal address (%x)\nNo node sent\n", adr);
  else
    { 
      iniivwmsg(&ivwmsg);
      ivwmsg.msgtyp = FSTNODMSG;
      ivwmsg.nodidt = *(short *)adr;
      ivwmsg.adr    = adr;
      
      wrtsts = sndwdwmsg (ivwmsg);
      if (wrtsts == -1) 
	{ perror ("IDLVlib: error sending first node");
	  return wrtsts;
	}
      
      (void)cmmlop();	/* enter communications loop for IDLView */
    }
 return 0;
}
