/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/sndcdlwdw.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

		/*DOC+*/
/* sndcdlwdw.c  -- IDLView -- send Candle filename to window process
 *  6-Aug-1987 22:00
 * 20-Nov-1987 14:29
 *    changed 'gets' call to get filename from user to console input.
 *    This fixes bug where, if you provide 'standard input' to
 *    your user program, gets will read the first line of it as
 *    the Candle file name.
 * 26-Mar-1989 16:16
 *    If the parameter is null, get the Candle filename from
 *    an external variable in the generated .o file, not from
 *    the user.
 */

#include <stdio.h>
#include <string.h>
#include "ivw.h"	/* IDLView general include */

#ifdef NeXT
#define TYPEOFMEMPARAM void
#endif
#ifndef NeXT
#define TYPEOFMEMPARAM char
#endif

void exit();

TYPEOFMEMPARAM *malloc();

/* name of Candle file from IDL-generated .o file */
extern char *IDLcandlefilename;
extern int usrdsc;	/* user descriptor used for window communication */
extern int  IDLwdwsys;          /* Variable to denote Window System used */
int ivwup=IVWFLS;

int  sndwdwmsg();	/* send a message to the IDLView window */
void iniivwmsg();	/* initialize an IVW message header structure */
char *getstrttyprm();	/* get a string from user's console */
char *getwd();

int
IDLcalivw (id)
     int id;

{
  char idstr[20];

  if (id)
    {
      (void)sprintf (idstr, "%d", id);
      (void)sndcdlwdw (idstr, IDLwdwsys, "", "", 0, "");
    }
  else
    {
      (void)sndcdlwdw ("", IDLwdwsys, "", "", 0, "");
    }
}



int
sndcdlwdw (id, wdw, server, display, idlb, port)
     char *id;
     int wdw;
     char *server, *display;
     int idlb;
     char *port;

{

  ivwmsghdr ivwmsg;	/* IDLView message -- message being sent */
  int       wrtsts;	/* write status -- status return from socket write */
  char	    *inpfilnam; /* file name input by user  */
  int       redsts;	/* status from read of Candle ack */
  ptr	    blkptr;	/* dummy block pointer for rcv call */

  char     *fulfilnam;	/* file name with working directory */
  char     *serv;
  char     *disp;
  int       wdwid;
  
  /* Get the Window ID */
  if (!id || strlen (id) == 0)
    wdwid = 0;
  else
    {
      if(atoi (id))
	wdwid = atoi(id);
      else
	{
	  (void)fprintf(stderr, "sndcdlwdw: Invalid idlview ID specified.\n");
	  (void)fflush(stderr);
	  exit(1);
	}
    }

  /* Get the Preferred Window System */
  if (!IDLwdwsys)
    {
      if (wdw)
	IDLwdwsys = wdw;
      else
	{
	  (void)fprintf(stderr, "shownode: Invalid Window System specified.\n");
	  (void)fflush(stderr);
	  exit(1);
	}
    }

  /* Get the Server Name */
  if ((serv = (TYPEOFMEMPARAM *)malloc((unsigned int)MAXHSTNAMLNG)) == NULL)
    {
      (void)fprintf(stderr,"sndcdlwdw: Memory allocation failure.\n");
      (void)fflush(stderr);
    }
  bzero(serv, MAXHSTNAMLNG);
  if (strlen (server) == 0)
    (void)gethostname(serv, MAXHSTNAMLNG);
  else
    (void)strcpy (serv, server);

  /* Get the Display Name */
  if ((disp = (TYPEOFMEMPARAM *)malloc((unsigned int)MAXHSTNAMLNG)) == NULL)
    {
      (void)fprintf(stderr,"sndcdlwdw: Memory allocation failure.\n");
      (void)fflush(stderr);
    }
  bzero(disp, MAXHSTNAMLNG);

  if (strlen (display) == 0)
    (void)gethostname(disp, MAXHSTNAMLNG);
  else
    (void)strcpy (disp, display);


  /* Get the CANDLE File Name */
    inpfilnam = IDLcandlefilename;

  /* if the filename we have does not start with a slash,
   * build a filename which contains the current path name
   */

  if ( !strcmp(IDLcandlefilename, "") )
    fulfilnam = inpfilnam;
  else if (inpfilnam[0] == '/')
    fulfilnam = inpfilnam;
  else { fulfilnam = (TYPEOFMEMPARAM *)malloc((unsigned int)MAXFILNAMLNG);
	 (void)getwd(fulfilnam);
	 (void)strcat (fulfilnam,"/");
	 (void)strcat (fulfilnam,inpfilnam);
       }


  /* initialize the window communications */
  usrdsc = libcnncmm(wdwid, IDLwdwsys, fulfilnam, serv, disp, idlb, port);
  if (usrdsc == 0) return -1;

  /* send candle file in its proper message */
  if (IDLcandlefilename && strlen(IDLcandlefilename) > 0)
    {
      iniivwmsg(&ivwmsg);
      ivwmsg.msgtyp = CDLMSG;
      ivwmsg.adr    = fulfilnam;
      ivwmsg.addmsglng = strlen(fulfilnam) + 1;
      wrtsts = sndwdwmsg (ivwmsg);

      (void)printf("waiting for ack from idlview\n");
      (void)fflush(stdout);

      if (wrtsts == -1) { perror ("IDLVlib: error writing Candle name");
			  return -1;
			}
      
      /* get ack back from IDLView window */
      redsts = rcvwdwmsg (&ivwmsg, &blkptr);

      (void)printf("Got ack from idlview\n");
      (void)fflush(stdout);
      if (redsts == -1) { perror ("IDLVlib: error reading Candle ack");
			  return -1;
			}
      
      if (ivwmsg.msgtyp != ENDCMM)
	{ (void)fprintf (stderr,"IDLVlib: message %d after Candle sent\n", ivwmsg.msgtyp);
	  return -1;
	}
    }
  ivwup =  IVWTRU;
  return 0; 
}

